/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk.beacon;

import android.app.PendingIntent;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.WorkerThread;
import com.tamoco.sdk.BeaconEntity;
import com.tamoco.sdk.BeaconState;
import com.tamoco.sdk.DataRepositories;
import com.tamoco.sdk.JobDispatcher;
import com.tamoco.sdk.NotificationUtils;
import com.tamoco.sdk.PermissionUtils;
import com.tamoco.sdk.PreferencesManager;
import com.tamoco.sdk.StoredBeacon;
import com.tamoco.sdk.TamocoLog;
import com.tamoco.sdk.TamocoRequestCallback;
import com.tamoco.sdk.beacon.BeaconBroadcast;
import com.tamoco.sdk.beacon.BeaconParser;
import com.tamoco.sdk.beacon.BeaconTrigger;
import com.tamoco.sdk.beacon.BluetoothJobService;
import com.tamoco.sdk.beacon.BluetoothScanReceiver;
import com.tamoco.sdk.beacon.ScanResultApi18;
import com.tamoco.sdk.beacon.a;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

class b {
    private static b a;
    private ExecutorService b;
    private PreferencesManager c;
    private DataRepositories d;
    private JobDispatcher e;
    private PendingIntent f;
    private List<BeaconParser> g = new ArrayList<BeaconParser>();
    private AtomicBoolean h;

    private b() {
        this.g.add(new BeaconParser("altbeacon").a("m:2-3=beac,i:4-19,i:20-21,i:22-23,p:24-24,d:25-25"));
        this.g.add(new BeaconParser("ibeacon").a("m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24,d:25-25"));
        this.g.add(new BeaconParser("eddystone_uid").a("s:0-1=feaa,m:2-2=00,p:3-3:-41,i:4-13,i:14-19"));
        this.g.add(new BeaconParser("eddystone_tlm").a("x,s:0-1=feaa,m:2-2=20,d:3-3,d:4-5,d:6-7,d:8-11,d:12-15"));
        this.h = new AtomicBoolean(false);
    }

    static synchronized b a() {
        if (a == null) {
            a = new b();
        }
        return a;
    }

    void a(@NonNull Context context, @NonNull PreferencesManager preferencesManager, @NonNull DataRepositories dataRepositories, @NonNull JobDispatcher jobDispatcher, @NonNull ExecutorService executorService) {
        this.c = preferencesManager;
        this.d = dataRepositories;
        this.e = jobDispatcher;
        this.b = executorService;
        this.f = BluetoothScanReceiver.getPendingIntent(context);
    }

    @RequiresApi(value=26)
    void a(final Context context) {
        if (this.b != null) {
            this.b.submit(new Runnable(){

                @Override
                public void run() {
                    BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
                    if (PermissionUtils.hasBluetoothPermissions(context) && bluetoothManager != null && bluetoothManager.getAdapter() != null && bluetoothManager.getAdapter().getBluetoothLeScanner() != null) {
                        BluetoothLeScanner bluetoothLeScanner = bluetoothManager.getAdapter().getBluetoothLeScanner();
                        ScanSettings scanSettings = new ScanSettings.Builder().setNumOfMatches(2).setReportDelay(b.this.c.getBeaconScanReportDelay()).setScanMode(0).build();
                        int n2 = bluetoothLeScanner.startScan(b.this.f(), scanSettings, b.this.f);
                        if (n2 == 0) {
                            TamocoLog.d("BeaconScanner", "registerScanBroadcast - Start Scan successful");
                        } else {
                            TamocoLog.d("BeaconScanner", "registerScanBroadcast - Start Scan failed");
                        }
                    }
                }
            });
        }
    }

    @RequiresApi(value=26)
    private List<ScanFilter> f() {
        ArrayList<ScanFilter> arrayList = new ArrayList<ScanFilter>();
        ScanFilter.Builder builder = new ScanFilter.Builder();
        arrayList.add(builder.build());
        return arrayList;
    }

    @RequiresApi(api=26)
    void b(Context context) {
        BluetoothLeScanner bluetoothLeScanner;
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        if (bluetoothManager != null && bluetoothManager.getAdapter() != null && PermissionUtils.hasBluetoothPermissions(context) && (bluetoothLeScanner = bluetoothManager.getAdapter().getBluetoothLeScanner()) != null) {
            try {
                bluetoothLeScanner.stopScan(this.f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void b() {
        if (this.c != null && this.e != null) {
            Bundle bundle = new Bundle();
            bundle.putLong("com.tamoco.sdk.beacon.EXTRA_HIT_TRIGGER", this.c.getBeaconScanDuration());
            this.e.scheduleRecurringJob("beacon-scan-recurring", BluetoothJobService.class, null, this.c.getBeaconScanInterval(), bundle);
        }
    }

    void c() {
        if (this.c != null && this.e != null) {
            Bundle bundle = new Bundle();
            bundle.putLong("com.tamoco.sdk.beacon.EXTRA_HIT_TRIGGER", this.c.getBeaconScanDuration());
            this.e.dispatchImmediateJob("beacon-scan", BluetoothJobService.class, null, bundle);
        }
    }

    void d() {
        if (this.e != null) {
            this.e.cancelJob("beacon-scan-recurring");
        }
    }

    @RequiresApi(api=21)
    void a(final @NonNull Context context, final @Nullable List<ScanResult> list) {
        if (list != null && this.b != null && this.d != null) {
            this.b.submit(new Runnable(){

                @Override
                public void run() {
                    if (!b.this.h.get()) {
                        TamocoLog.d("BeaconScanner", "Processing scan results");
                        b.this.h.set(true);
                        List list2 = b.this.a(list);
                        b.this.c(context, list2);
                        b.this.h.set(false);
                        TamocoLog.d("BeaconScanner", "Finished processing scan results");
                    }
                }
            });
        }
    }

    @RequiresApi(api=21)
    private List<a> a(@Nullable List<ScanResult> list) {
        ArrayList<a> arrayList = new ArrayList<a>();
        if (list != null) {
            block0: for (ScanResult scanResult : list) {
                for (BeaconParser beaconParser : this.g) {
                    byte[] byArray;
                    a a2 = beaconParser.a(byArray = scanResult.getScanRecord() != null ? scanResult.getScanRecord().getBytes() : null, scanResult.getRssi(), scanResult.getDevice());
                    if (a2 == null) continue;
                    arrayList.add(a2);
                    continue block0;
                }
            }
        }
        return arrayList;
    }

    @RequiresApi(api=18)
    void b(final @NonNull Context context, final @Nullable List<ScanResultApi18> list) {
        if (list != null && this.b != null) {
            this.b.submit(new Runnable(){

                @Override
                public void run() {
                    List list2 = b.this.b(list);
                    b.this.c(context, list2);
                }
            });
        }
    }

    @RequiresApi(api=18)
    private List<a> b(@Nullable List<ScanResultApi18> list) {
        ArrayList<a> arrayList = new ArrayList<a>();
        if (list != null) {
            block0: for (ScanResultApi18 scanResultApi18 : list) {
                for (BeaconParser beaconParser : this.g) {
                    a a2 = beaconParser.a(scanResultApi18.getData(), scanResultApi18.getRssi(), scanResultApi18.getDevice());
                    if (a2 == null) continue;
                    arrayList.add(a2);
                    continue block0;
                }
            }
        }
        return arrayList;
    }

    @WorkerThread
    private void c(@NonNull Context context, @Nullable List<a> list) {
        if (list != null) {
            this.d(context, list);
            this.c(context);
        }
    }

    @WorkerThread
    private void d(@NonNull Context context, @NonNull List<a> list) {
        for (a a2 : list) {
            Integer n2;
            StoredBeacon storedBeacon = this.a(a2);
            if (storedBeacon != null && storedBeacon.entity != null) {
                String string = a2.j();
                BeaconState beaconState = storedBeacon.getEntityState();
                boolean bl = false;
                n2 = 0;
                long l2 = System.currentTimeMillis();
                if (beaconState.getProximityStatus() == 0 || beaconState.getProximityStatus() == 10) {
                    n2 = this.a(string);
                    bl = true;
                } else if (beaconState.getProximityStatus() == 11) {
                    if (this.a(storedBeacon.entity, storedBeacon.state, a2.d())) {
                        n2 = this.b(string);
                        bl = true;
                        l2 = storedBeacon.state.getProximityStatusTimestamp() + this.b(storedBeacon.entity);
                        beaconState.setHoverReported(true);
                    } else if (this.a(storedBeacon.entity, storedBeacon.state)) {
                        n2 = this.c(string);
                        bl = true;
                        l2 = storedBeacon.state.getProximityStatusTimestamp() + this.a(storedBeacon.entity);
                        beaconState.setDwellReported(true);
                    }
                }
                beaconState.setBeaconType(a2.j());
                beaconState.setFoundInPreviousScan(true);
                if (bl) {
                    boolean bl2;
                    beaconState.setProximity(a2.d());
                    beaconState.setScannedMac(a2.h());
                    beaconState.setLastEvent(n2);
                    beaconState.setLastEventTimeStamp(l2);
                    Double d2 = a2.e();
                    if (d2 != null) {
                        beaconState.setRssi(Math.round(a2.e().floatValue()));
                    }
                    beaconState.setManufacturer(a2.g());
                    beaconState.setBluetoothName(a2.i());
                    beaconState.setTxPower(a2.f());
                    boolean bl3 = bl2 = beaconState.getProximityStatus() != 11;
                    if (bl2) {
                        beaconState.setProximityStatus(11);
                        beaconState.setProximityStatusTimestamp(System.currentTimeMillis());
                    }
                    this.a(context, storedBeacon);
                }
                this.d.inventory().updateBeaconState(beaconState);
            } else {
                n2 = this.a(a2.j());
            }
            this.a(context, a2);
        }
    }

    @WorkerThread
    private void c(@NonNull Context context) {
        List<StoredBeacon> list = this.d.inventory().getBeaconsNotFoundByStatus(11);
        for (StoredBeacon storedBeacon : list) {
            if (storedBeacon.entity == null) continue;
            BeaconState beaconState = storedBeacon.getEntityState();
            beaconState.setLastEvent(this.d(beaconState.getBeaconType()));
            beaconState.setLastEventTimeStamp(System.currentTimeMillis());
            beaconState.setProximityStatus(10);
            beaconState.setProximityStatusTimestamp(System.currentTimeMillis());
            beaconState.setHoverReported(false);
            beaconState.setDwellReported(false);
            beaconState.setProximity(null);
            beaconState.setRssi(null);
            this.d.inventory().updateBeaconState(beaconState);
            this.a(context, storedBeacon);
        }
        this.d.inventory().resetBeaconsFound();
    }

    private int a(@Nullable String string) {
        if (string != null) {
            switch (string) {
                case "altbeacon": 
                case "ibeacon": {
                    return 11;
                }
                case "eddystone_tlm": 
                case "eddystone_uid": {
                    return 61;
                }
            }
        }
        return 0;
    }

    private int b(@Nullable String string) {
        if (string != null) {
            switch (string) {
                case "altbeacon": 
                case "ibeacon": {
                    return 12;
                }
                case "eddystone_tlm": 
                case "eddystone_uid": {
                    return 62;
                }
            }
        }
        return 0;
    }

    private int c(@Nullable String string) {
        if (string != null) {
            switch (string) {
                case "altbeacon": 
                case "ibeacon": {
                    return 13;
                }
                case "eddystone_tlm": 
                case "eddystone_uid": {
                    return 63;
                }
            }
        }
        return 0;
    }

    private int d(@Nullable String string) {
        if (string != null) {
            switch (string) {
                case "altbeacon": 
                case "ibeacon": {
                    return 14;
                }
                case "eddystone_tlm": 
                case "eddystone_uid": {
                    return 64;
                }
            }
        }
        return 0;
    }

    private void a(@NonNull Context context, @NonNull a a2) {
        String string = a2.h();
        Integer n2 = a2.e() == null ? null : Integer.valueOf(Math.round(a2.e().floatValue()));
        Integer n3 = a2.g();
        String string2 = a2.i();
        Integer n4 = a2.f();
        if (a2.a != null && a2.a.size() > 0) {
            switch (a2.j()) {
                case "altbeacon": 
                case "ibeacon": {
                    String string3 = a2.a().d().toString();
                    Integer n5 = a2.b().a();
                    Integer n6 = a2.c().a();
                    this.d.inventory().reportAroundMeBleBeacon(context, string3, n5, n6, string, n2, n3, string2, n4);
                }
                case "eddystone_tlm": 
                case "eddystone_uid": {
                    String string4 = a2.a().c();
                    String string5 = a2.b().c();
                    this.d.inventory().reportAroundMeEddystone(context, string4, string5, string, n2, n3, string2, n4);
                }
            }
        }
    }

    private void a(@NonNull Context context, @NonNull StoredBeacon storedBeacon) {
        BeaconBroadcast.a(context, new BeaconTrigger(storedBeacon.entity, storedBeacon.state));
        this.a(context, storedBeacon.entity, storedBeacon.state);
        this.d.hits().trackBeaconHit(context, storedBeacon);
    }

    private void a(@NonNull Context context, @NonNull BeaconEntity beaconEntity, @NonNull BeaconState beaconState) {
        String string = "Unknown";
        switch (beaconState.getLastEvent()) {
            case 11: 
            case 61: {
                string = "Enter";
                break;
            }
            case 12: 
            case 62: {
                string = "Hover";
                break;
            }
            case 13: 
            case 63: {
                string = "Dwell";
                break;
            }
            case 14: 
            case 64: {
                string = "Exit";
            }
        }
        TamocoLog.d("BeaconScanner", "Beacon update: " + string + ": " + beaconEntity.getName());
        int n2 = (int)System.currentTimeMillis();
        NotificationUtils.showDebugNotification(context, n2, "Beacon Trigger Hit", String.format(Locale.UK, "%s : %s", string, beaconEntity.getName()));
    }

    private boolean a(@NonNull BeaconEntity beaconEntity, @NonNull BeaconState beaconState) {
        long l2 = this.a(beaconEntity);
        return !beaconState.isDwellReported() && beaconState.getProximityStatus() == 11 && System.currentTimeMillis() - beaconState.getProximityStatusTimestamp() >= l2;
    }

    private long a(@NonNull BeaconEntity beaconEntity) {
        return beaconEntity.getDwellMillis() > 0L ? beaconEntity.getDwellMillis() : this.c.getDefaultBeaconDwellDelay();
    }

    private boolean a(@NonNull BeaconEntity beaconEntity, BeaconState beaconState, double d2) {
        if (beaconState == null || beaconState.isHoverReported()) {
            return false;
        }
        long l2 = this.b(beaconEntity);
        double d3 = this.c.getBeaconNearDistance();
        boolean bl = beaconState.getProximity() <= d3;
        boolean bl2 = d2 <= d3;
        boolean bl3 = System.currentTimeMillis() - beaconState.getProximityStatusTimestamp() >= l2;
        return bl && bl2 && bl3;
    }

    private long b(@NonNull BeaconEntity beaconEntity) {
        return beaconEntity.getHoverMillis() > 0L ? beaconEntity.getHoverMillis() : this.c.getDefaultBeaconHoverDelay();
    }

    @WorkerThread
    private StoredBeacon a(@NonNull a a2) {
        switch (a2.j()) {
            case "altbeacon": 
            case "ibeacon": {
                return this.c(a2);
            }
            case "eddystone_tlm": 
            case "eddystone_uid": {
                return this.b(a2);
            }
        }
        return null;
    }

    @WorkerThread
    private StoredBeacon b(@NonNull a a2) {
        try {
            if (a2.a != null && a2.a.size() > 0) {
                String string = a2.a().c();
                String string2 = a2.b().c();
                if (string != null && string2 != null) {
                    return this.d.inventory().getEddystone(string, string2);
                }
            }
        }
        catch (Exception exception) {
            TamocoLog.e("BeaconScanner", "Error trying to find monitored eddystone.", exception);
        }
        return null;
    }

    @WorkerThread
    private StoredBeacon c(@NonNull a a2) {
        try {
            if (a2.a != null && a2.a.size() > 0) {
                String string = a2.a().d().toString();
                Integer n2 = a2.b().a();
                Integer n3 = a2.c().a();
                if (string != null) {
                    return this.d.inventory().getAltBeacon(string, n2, n3);
                }
            }
        }
        catch (Exception exception) {
            TamocoLog.e("BeaconScanner", "Error trying to find monitored alt beacon.", exception);
        }
        return null;
    }

    void a(final @NonNull TamocoRequestCallback<List<BeaconTrigger>> tamocoRequestCallback) {
        if (this.b != null) {
            final Handler handler = new Handler();
            this.b.submit(new Runnable(){

                @Override
                public void run() {
                    final ArrayList<BeaconTrigger> arrayList = new ArrayList<BeaconTrigger>();
                    List<StoredBeacon> list = b.this.d.inventory().getBeacons();
                    if (list != null) {
                        for (StoredBeacon storedBeacon : list) {
                            arrayList.add(new BeaconTrigger(storedBeacon.entity, storedBeacon.state));
                        }
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            tamocoRequestCallback.onResult(arrayList);
                        }
                    });
                }
            });
        } else {
            tamocoRequestCallback.onResult(null);
        }
    }

    ExecutorService e() {
        return this.b != null ? this.b : Executors.newSingleThreadExecutor();
    }
}

