/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.location.Location;
import com.squareup.moshi.Json;
import com.tamoco.sdk.StoredBeacon;
import com.tamoco.sdk.StoredGeofence;
import com.tamoco.sdk.StoredWifi;

class TriggerData {
    @Json(name="trigger_type")
    @ColumnInfo(name="trigger_type")
    Integer triggerType;
    @Json(name="inventory_id")
    @ColumnInfo(name="inventory_id")
    Long inventoryId;
    @Json(name="beacon_id")
    @ColumnInfo(name="beacon_id")
    String uuid;
    @Json(name="major")
    @ColumnInfo(name="major")
    Integer major;
    @Json(name="minor")
    @ColumnInfo(name="minor")
    Integer minor;
    @Json(name="namespace")
    @ColumnInfo(name="namespace")
    String namespace;
    @Json(name="instance")
    @ColumnInfo(name="instance")
    String instance;
    @Json(name="rssi")
    @ColumnInfo(name="rssi")
    Integer rssi;
    @Json(name="bluetooth_name")
    @ColumnInfo(name="bluetooth_name")
    String bluetoothName;
    @Json(name="manufactuer")
    @ColumnInfo(name="manufactuer")
    Integer manufactuer;
    @Json(name="tx_power")
    @ColumnInfo(name="tx_power")
    Integer txPower;
    @Json(name="ssid")
    @ColumnInfo(name="ssid")
    String ssid;
    @Json(name="capabilities")
    @ColumnInfo(name="capabilities")
    String capabilities;
    @Json(name="mac")
    @ColumnInfo(name="mac")
    String mac;
    @Json(name="frequency")
    @ColumnInfo(name="frequency")
    Integer frequency;
    @Json(name="center_freq_0")
    @ColumnInfo(name="center_freq_0")
    Integer centerFreq0;
    @Json(name="center_freq_1")
    @ColumnInfo(name="center_freq_1")
    Integer centerFreq1;
    @Json(name="venue_name")
    @ColumnInfo(name="venue_name")
    String venueName;
    @Json(name="operator_name")
    @ColumnInfo(name="operator_name")
    String operatorName;
    @Json(name="channel_width")
    @ColumnInfo(name="channel_width")
    Integer channelWidth;
    @Json(name="trigger_code")
    @ColumnInfo(name="trigger_code")
    String triggerCode;
    @Json(name="trigger_variant")
    @ColumnInfo(name="trigger_variant")
    String triggerVariant;
    @Json(name="tag_id")
    @ColumnInfo(name="tag_id")
    String tagId;
    @Json(name="tac")
    @ColumnInfo(name="tac")
    String tac;
    @Json(name="proximity")
    @ColumnInfo(name="proximity")
    Float proximity;

    TriggerData() {
    }

    TriggerData(Integer type) {
        this.triggerType = type;
    }

    TriggerData(StoredGeofence geofence, Location location) {
        if (geofence != null) {
            if (geofence.entity != null) {
                this.inventoryId = geofence.entity.getId();
                if (location != null) {
                    Location location2 = new Location("aux");
                    location2.setLatitude(geofence.entity.getLatitude());
                    location2.setLongitude(geofence.entity.getLongitude());
                    this.proximity = Float.valueOf(location.distanceTo(location2));
                }
            }
            if (geofence.state != null) {
                this.triggerType = geofence.state.getLastEvent();
            }
        }
    }

    TriggerData(StoredWifi wifi, Location location) {
        if (wifi != null) {
            if (wifi.entity != null) {
                this.inventoryId = wifi.entity.getId();
                this.ssid = wifi.entity.getSSid();
                this.mac = wifi.entity.getMac();
                if (location != null) {
                    Location location2 = new Location("aux");
                    location2.setLatitude(wifi.entity.getLatitude());
                    location2.setLongitude(wifi.entity.getLongitude());
                    this.proximity = Float.valueOf(location.distanceTo(location2));
                }
            }
            if (wifi.state != null) {
                if (wifi.state.getScannedMac() != null) {
                    this.mac = wifi.state.getScannedMac();
                }
                this.capabilities = wifi.state.getCapabilities();
                this.rssi = wifi.state.getLevel();
                this.frequency = wifi.state.getFrequency();
                this.centerFreq0 = wifi.state.getCenterFreq0();
                this.centerFreq1 = wifi.state.getCenterFreq1();
                this.venueName = wifi.state.getVenueName();
                this.operatorName = wifi.state.getOperatorFriendlyName();
                this.channelWidth = wifi.state.getChannelWidth();
                this.triggerType = wifi.state.getLastEvent();
            }
        }
    }

    TriggerData(StoredBeacon beacon, Location location) {
        if (beacon != null) {
            if (beacon.entity != null) {
                this.inventoryId = beacon.entity.getId();
                this.uuid = beacon.entity.getUuid();
                this.major = beacon.entity.getMajor();
                this.minor = beacon.entity.getMinor();
                this.namespace = beacon.entity.getNamespace();
                this.instance = beacon.entity.getInstance();
                this.mac = beacon.entity.getMac();
            }
            if (beacon.state != null) {
                if (beacon.state.getScannedMac() != null) {
                    this.mac = beacon.state.getScannedMac();
                }
                if (beacon.state.getProximity() != null) {
                    this.proximity = Float.valueOf((float)beacon.state.getProximity().doubleValue());
                } else if (beacon.entity != null && location != null) {
                    Location location2 = new Location("aux");
                    location2.setLatitude(beacon.entity.getLatitude());
                    location2.setLongitude(beacon.entity.getLongitude());
                    this.proximity = Float.valueOf(location.distanceTo(location2));
                }
                this.rssi = beacon.state.getRssi();
                this.manufactuer = beacon.state.getManufacturer();
                this.bluetoothName = beacon.state.getBluetoothName();
                this.txPower = beacon.state.getTxPower();
                this.triggerType = beacon.state.getLastEvent();
            }
        }
    }
}

