/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;
import com.tamoco.sdk.NearbyItemDto;
import java.util.concurrent.TimeUnit;

abstract class InventoryEntity {
    @PrimaryKey
    @ColumnInfo(name="id")
    protected long mId;
    @ColumnInfo(name="name")
    protected String mName;
    @ColumnInfo(name="latitude")
    protected double mLatitude;
    @ColumnInfo(name="longitude")
    protected double mLongitude;
    @ColumnInfo(name="dwell_millis")
    protected long mDwellMillis;
    @ColumnInfo(name="hover_millis")
    protected long mHoverMillis;
    @ColumnInfo(name="distance")
    protected float mDistance;
    @ColumnInfo(name="ttl")
    protected Long mTtl;
    @ColumnInfo(name="created_at")
    protected long mCreatedAt;

    public InventoryEntity() {
    }

    @Ignore
    InventoryEntity(@NonNull NearbyItemDto item) {
        this.mId = item.inventoryId;
        this.mName = item.name;
        this.mLatitude = item.latitude;
        this.mLongitude = item.longitude;
        this.mDwellMillis = TimeUnit.MILLISECONDS.convert(item.dwellInterval, TimeUnit.SECONDS);
        this.mHoverMillis = TimeUnit.MILLISECONDS.convert(item.hoverInterval, TimeUnit.SECONDS);
        this.mDistance = item.distance;
        this.mCreatedAt = System.currentTimeMillis();
        if (item.ttl != null) {
            this.mTtl = TimeUnit.MILLISECONDS.convert(Math.round(item.ttl.floatValue()), TimeUnit.SECONDS);
        }
    }

    public long getId() {
        return this.mId;
    }

    public void setId(long id) {
        this.mId = id;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public void setLatitude(double latitude) {
        this.mLatitude = latitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public void setLongitude(double longitude) {
        this.mLongitude = longitude;
    }

    public long getDwellMillis() {
        return this.mDwellMillis;
    }

    public void setDwellMillis(long dwellMillis) {
        this.mDwellMillis = dwellMillis;
    }

    public long getHoverMillis() {
        return this.mHoverMillis;
    }

    public void setHoverMillis(long hoverMillis) {
        this.mHoverMillis = hoverMillis;
    }

    public float getDistance() {
        return this.mDistance;
    }

    public void setDistance(float distance) {
        this.mDistance = distance;
    }

    public Long getTtl() {
        return this.mTtl;
    }

    public void setTtl(Long ttl) {
        this.mTtl = ttl;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public void setCreatedAt(long createdAt) {
        this.mCreatedAt = createdAt;
    }
}

