/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.Index;
import android.support.annotation.NonNull;
import com.tamoco.sdk.InventoryEntity;
import com.tamoco.sdk.NearbyItemDto;

@Entity(tableName="beacon_inventory", indices={@Index(value={"uuid"})})
public class BeaconEntity
extends InventoryEntity {
    @ColumnInfo(name="uuid")
    private String mUuid;
    @ColumnInfo(name="namespace")
    private String mNamespace;
    @ColumnInfo(name="major")
    private Integer mMajor;
    @ColumnInfo(name="minor")
    private Integer mMinor;
    @ColumnInfo(name="instance")
    private String mInstance;
    @ColumnInfo(name="mac")
    private String mMac;

    public BeaconEntity() {
    }

    @Ignore
    BeaconEntity(@NonNull NearbyItemDto item) {
        super(item);
        String string;
        this.mUuid = item.beaconId;
        this.mMajor = item.major;
        this.mMinor = item.minor;
        this.mMac = item.mac;
        if (item.namespace != null && item.instance != null) {
            this.mNamespace = item.namespace;
            this.mInstance = item.instance;
        } else if (item.beaconId != null && (string = item.beaconId.replace("-", "")).length() == 32) {
            this.mNamespace = string.substring(0, 20);
            this.mInstance = string.substring(20, 32);
        }
    }

    public String getUuid() {
        return this.mUuid;
    }

    public void setUuid(String uuid) {
        this.mUuid = uuid;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public void setNamespace(String namespace) {
        this.mNamespace = namespace;
    }

    public Integer getMajor() {
        return this.mMajor;
    }

    public void setMajor(Integer major) {
        this.mMajor = major;
    }

    public Integer getMinor() {
        return this.mMinor;
    }

    public void setMinor(Integer minor) {
        this.mMinor = minor;
    }

    public String getInstance() {
        return this.mInstance;
    }

    public void setInstance(String instance) {
        this.mInstance = instance;
    }

    public String getMac() {
        return this.mMac;
    }

    public void setMac(String mac) {
        this.mMac = mac;
    }
}

