/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Ignore;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PowerManager;
import com.squareup.moshi.Json;

class BatteryData {
    @Json(name="level")
    @ColumnInfo(name="level")
    Integer level;
    @Json(name="health")
    @ColumnInfo(name="health")
    Integer health;
    @Json(name="saver")
    @ColumnInfo(name="saver")
    boolean saver;
    @Json(name="temperature")
    @ColumnInfo(name="temperature")
    Integer temperature;
    @Json(name="technology")
    @ColumnInfo(name="technology")
    String technology;
    @Json(name="voltage")
    @ColumnInfo(name="voltage")
    int voltage;

    BatteryData() {
    }

    @Ignore
    BatteryData(Context context, Intent batteryStatus) {
        this.level = this.getBatteryLevel(batteryStatus);
        this.health = this.getBatteryHealth(batteryStatus);
        this.temperature = this.getBatteryTemperature(batteryStatus);
        this.technology = this.getBatteryTechnology(batteryStatus);
        this.voltage = this.getBatteryVoltage(batteryStatus);
        this.saver = this.isBatterySaverEnabled(context);
    }

    private Integer getBatteryHealth(Intent batteryStatus) {
        Integer n2 = 0;
        if (batteryStatus != null) {
            int n3 = batteryStatus.getIntExtra("health", 0);
            n2 = n3 == 2 ? Integer.valueOf(1) : Integer.valueOf(2);
        }
        return n2;
    }

    private Integer getBatteryLevel(Intent batteryStatus) {
        int n2 = batteryStatus != null ? batteryStatus.getIntExtra("level", -1) : -1;
        return n2 >= 0 ? Integer.valueOf(n2) : null;
    }

    private boolean isBatterySaverEnabled(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        return Build.VERSION.SDK_INT >= 21 && powerManager != null && powerManager.isPowerSaveMode();
    }

    private String getBatteryTechnology(Intent batteryStatus) {
        return batteryStatus != null ? batteryStatus.getStringExtra("technology") : null;
    }

    private int getBatteryTemperature(Intent batteryStatus) {
        return batteryStatus != null ? (int)((double)batteryStatus.getIntExtra("temperature", 0) / 10.0) : -1;
    }

    private int getBatteryVoltage(Intent batteryStatus) {
        return batteryStatus != null ? batteryStatus.getIntExtra("voltage", 0) : -1;
    }
}

