/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Embedded;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.location.Location;
import android.net.wifi.ScanResult;
import android.os.Build;
import com.squareup.moshi.Json;
import com.tamoco.sdk.GeoData;
import com.tamoco.sdk.TriggerData;
import com.tamoco.sdk.l;

@Entity(tableName="around_me_triggers")
class AroundMeTrigger {
    @PrimaryKey(autoGenerate=true)
    Long id;
    @Json(name="trigger")
    @Embedded(prefix="trigger_")
    TriggerData trigger;
    @Json(name="geo")
    @Embedded(prefix="geo_")
    GeoData geo;
    @Json(name="sdk_timestamp")
    @ColumnInfo(name="sdk_timestamp")
    long sdkTimestamp;

    AroundMeTrigger() {
    }

    @Ignore
    private AroundMeTrigger(Location location, Float pressure, l getMotion) {
        this.geo = new GeoData(location, pressure, getMotion);
        if (location != null) {
            this.sdkTimestamp = location.getTime();
        }
        this.trigger = new TriggerData();
        this.trigger.triggerType = 71;
    }

    @Ignore
    AroundMeTrigger(Location location, String beaconId, Integer major, Integer minor, String mac, Integer rssi, Integer manufacturer, String bluetoothName, Integer txPower, l getMotion) {
        this(location, null, getMotion);
        this.trigger.uuid = beaconId;
        this.trigger.major = major;
        this.trigger.minor = minor;
        this.trigger.mac = mac;
        this.trigger.rssi = rssi;
        this.trigger.manufactuer = manufacturer;
        this.trigger.bluetoothName = bluetoothName;
        this.trigger.txPower = txPower;
    }

    @Ignore
    AroundMeTrigger(Location location, String namespace, String instance, String mac, Integer rssi, Integer manufacturer, String bluetoothName, Integer txPower, l getMotion) {
        this(location, null, getMotion);
        this.trigger.namespace = namespace;
        this.trigger.instance = instance;
        this.trigger.mac = mac;
        this.trigger.rssi = rssi;
        this.trigger.manufactuer = manufacturer;
        this.trigger.bluetoothName = bluetoothName;
        this.trigger.txPower = txPower;
    }

    @Ignore
    AroundMeTrigger(Location location, Float pressure, ScanResult scanResult, l getMotion) {
        this(location, pressure, getMotion);
        this.trigger.ssid = scanResult.SSID;
        this.trigger.mac = scanResult.BSSID;
        this.trigger.rssi = scanResult.level;
        this.trigger.frequency = scanResult.frequency;
        this.trigger.capabilities = scanResult.capabilities;
        if (Build.VERSION.SDK_INT >= 23) {
            this.trigger.centerFreq0 = scanResult.centerFreq0;
            this.trigger.centerFreq1 = scanResult.centerFreq1;
            this.trigger.venueName = scanResult.venueName != null ? scanResult.venueName.toString() : null;
            this.trigger.operatorName = scanResult.operatorFriendlyName != null ? scanResult.operatorFriendlyName.toString() : null;
            this.trigger.channelWidth = scanResult.channelWidth;
        }
    }
}

