package com.tamoco.sdk.doc;

import android.content.Context;

import com.tamoco.sdk.Kit;
import com.tamoco.sdk.Tamoco;
import com.tamoco.sdk.TamocoConfig;

/*
 * *******************************************************
 * Copyright (C) 2013-2018 Tamoco Limited
 * This file is part of the Tamoco SDKs.
 *
 * Tamocos SDKs can not be copied and/or distributed without the express
 * permission of Tamoco Limited.
 *
 * https://www.tamoco.com/terms-and-conditions/
 * *******************************************************
 */

/**
 * Builder to create a new instance of {@link TamocoConfig}.
 * <p>
 * Use this class to set all the configuration parameters of the Tamoco SDK depending on your needs.
 */
public interface ITamocoConfigBuilder {
    /**
     * Determines if the SDK should start scanning as soon as it is initialized
     * or if an explicit call to {@link Tamoco#startScanning(Context)} is needed.
     * <p>
     * true by default.
     *
     * @param startImmediately whether the sdk should start scanning immediately or not.
     * @return the builder.
     */
    TamocoConfig.Builder startImmediately(boolean startImmediately);

    /**
     * Determines if the SDK debug logs will be shown in Logcat or not.
     * <p>
     * false by default.
     *
     * @param enabled whether the debug logs will be shown in Logcat or not.
     * @return the builder.
     */
    TamocoConfig.Builder debugLogs(boolean enabled);

    /**
     * Determines if the SDK will only work when the app is in foreground or not.
     * <p>
     * false by default.
     *
     * @param enabled whether the SDK will show debug notifications or not.
     * @return the builder.
     */
    TamocoConfig.Builder foregroundOnly(boolean enabled);

    /**
     * Sets the kits to be initialized when using the SDK. Only the kits that will be used
     * should be included here.
     * <p>
     * null by default
     *
     * @param kits the kits
     * @return the builder
     */
    TamocoConfig.Builder kits(Kit... kits);

    /**
     * Sets all the kits initialized with the SDK
     * <p>
     *
     * @return the builder
     */
    TamocoConfig.Builder allKits();

    /**
     * Create a {@link TamocoConfig} using the builder parameters.
     *
     * @return the configurations for the Tamoco SDK.
     */
    TamocoConfig build();

}
