/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk.geofence;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.tamoco.sdk.DataRepositories;
import com.tamoco.sdk.GeofenceState;
import com.tamoco.sdk.NotificationUtils;
import com.tamoco.sdk.PermissionUtils;
import com.tamoco.sdk.PreferencesManager;
import com.tamoco.sdk.StoredGeofence;
import com.tamoco.sdk.TamocoLog;
import com.tamoco.sdk.TamocoRequestCallback;
import com.tamoco.sdk.geofence.GeofenceBroadcast;
import com.tamoco.sdk.geofence.GeofenceTransitionReceiver;
import com.tamoco.sdk.geofence.GeofenceTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class a {
    private static a a;
    private ExecutorService b;
    private PreferencesManager c;
    private DataRepositories d;
    private GeofencingClient e;
    private PendingIntent f;

    private a() {
    }

    static synchronized a a() {
        if (a == null) {
            a = new a();
        }
        return a;
    }

    void a(@NonNull Context context, @NonNull PreferencesManager preferencesManager, @NonNull DataRepositories dataRepositories, @NonNull ExecutorService executorService) {
        this.e = LocationServices.getGeofencingClient((Context)context.getApplicationContext());
        this.c = preferencesManager;
        this.d = dataRepositories;
        this.b = executorService;
        this.f = GeofenceTransitionReceiver.getPendingIntent(context);
    }

    void a(final @NonNull Context context) {
        if (this.b != null) {
            this.b.submit(new Runnable(){

                @Override
                @SuppressLint(value={"MissingPermission"})
                public void run() {
                    if (a.this.e != null) {
                        List<StoredGeofence> list = a.this.d.inventory().getGeofences();
                        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
                        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>();
                        for (StoredGeofence storedGeofence : list) {
                            if (storedGeofence.entity == null) continue;
                            Geofence geofence = storedGeofence.entity.toGeofence(a.this.c.getDefaultGeofenceDwellDelay());
                            if (storedGeofence.state == null || storedGeofence.state.getProximityStatus() == 20 || storedGeofence.state.getProximityStatus() == 0) {
                                arrayList2.add(geofence);
                                continue;
                            }
                            arrayList.add(geofence);
                        }
                        if (PermissionUtils.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION")) {
                            if (!arrayList.isEmpty()) {
                                a.this.e.addGeofences(a.this.a(arrayList, true), a.this.f).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

                                    public void a(Void void_) {
                                        TamocoLog.d("GeofenceScanner", "Entered Geofences registered successfully.");
                                    }

                                    public /* synthetic */ void onSuccess(Object object) {
                                        this.a((Void)object);
                                    }
                                }).addOnFailureListener(new OnFailureListener(){

                                    public void onFailure(@NonNull Exception e2) {
                                        TamocoLog.d("GeofenceScanner", "Unable to register entered geofences.", e2);
                                    }
                                });
                            }
                            if (!arrayList2.isEmpty()) {
                                a.this.e.addGeofences(a.this.a(arrayList2, false), a.this.f).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

                                    public void a(Void void_) {
                                        TamocoLog.d("GeofenceScanner", "Not Entered Geofences registered successfully.");
                                    }

                                    public /* synthetic */ void onSuccess(Object object) {
                                        this.a((Void)object);
                                    }
                                }).addOnFailureListener(new OnFailureListener(){

                                    public void onFailure(@NonNull Exception e2) {
                                        TamocoLog.d("GeofenceScanner", "Unable to register non entered geofences.", e2);
                                    }
                                });
                            }
                        }
                    }
                }
            });
        }
    }

    private GeofencingRequest a(@NonNull List<Geofence> list, boolean bl) {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        if (!bl) {
            builder.setInitialTrigger(1);
        }
        builder.addGeofences(list);
        return builder.build();
    }

    void b() {
        if (this.e != null) {
            this.e.removeGeofences(this.f);
        }
    }

    void a(Context context, int n2, List<Geofence> list) {
        int n3 = this.a(n2);
        int n4 = this.b(n2);
        for (Geofence geofence : list) {
            this.a(context.getApplicationContext(), n3, n4, geofence);
        }
    }

    private int a(int n2) {
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = 21;
                break;
            }
            case 4: {
                n3 = 22;
                break;
            }
            case 2: {
                n3 = 23;
            }
        }
        return n3;
    }

    private int b(int n2) {
        int n3 = 0;
        switch (n2) {
            case 1: 
            case 4: {
                n3 = 21;
                break;
            }
            case 2: {
                n3 = 20;
            }
        }
        return n3;
    }

    private void a(@NonNull Context context, @NonNull StoredGeofence storedGeofence) {
        String string = "Unknown";
        switch (storedGeofence.state.getLastEvent()) {
            case 21: {
                string = "Enter";
                break;
            }
            case 22: {
                string = "Dwell";
                break;
            }
            case 23: {
                string = "Exit";
            }
        }
        TamocoLog.d("GeofenceScanner", "Geofence update: " + string + ": " + storedGeofence.entity.getName());
        int n2 = (int)System.currentTimeMillis();
        NotificationUtils.showDebugNotification(context, n2, "Geofence Trigger Hi", String.format(Locale.UK, "%s : %s", string, storedGeofence.entity.getName()));
    }

    private void a(final @NonNull Context context, final int n2, final int n3, final @NonNull Geofence geofence) {
        if (this.b != null) {
            this.b.submit(new Runnable(){

                @Override
                public void run() {
                    StoredGeofence storedGeofence = a.this.d.inventory().getGeofence(Long.parseLong(geofence.getRequestId()));
                    if (storedGeofence != null && storedGeofence.entity != null) {
                        boolean bl;
                        GeofenceState geofenceState = storedGeofence.getEntityState();
                        boolean bl2 = geofenceState.getLastEvent() != n2;
                        boolean bl3 = bl = geofenceState.getProximityStatus() != n3;
                        if (bl2) {
                            geofenceState.setLastEvent(n2);
                            geofenceState.setLastEventTimeStamp(System.currentTimeMillis());
                        }
                        if (bl) {
                            geofenceState.setProximityStatus(n3);
                            geofenceState.setProximityStatusTimestamp(System.currentTimeMillis());
                        }
                        if (bl2 || bl) {
                            a.this.d.inventory().updateGeofenceState(geofenceState);
                        }
                        if (bl2) {
                            a.this.b(context, storedGeofence);
                        }
                    }
                }
            });
        }
    }

    @WorkerThread
    private void b(@NonNull Context context, @NonNull StoredGeofence storedGeofence) {
        GeofenceTrigger geofenceTrigger = new GeofenceTrigger(storedGeofence.entity, storedGeofence.state);
        this.a(context, storedGeofence);
        GeofenceBroadcast.a(context, geofenceTrigger);
        this.d.hits().trackGeofenceHit(context, storedGeofence);
    }

    void a(final @NonNull TamocoRequestCallback<List<GeofenceTrigger>> tamocoRequestCallback) {
        if (this.b != null) {
            final Handler handler = new Handler();
            this.b.submit(new Runnable(){

                @Override
                public void run() {
                    final ArrayList<GeofenceTrigger> arrayList = new ArrayList<GeofenceTrigger>();
                    List<StoredGeofence> list = a.this.d.inventory().getGeofences();
                    if (list != null) {
                        for (StoredGeofence storedGeofence : list) {
                            arrayList.add(new GeofenceTrigger(storedGeofence.entity, storedGeofence.state));
                        }
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            tamocoRequestCallback.onResult(arrayList);
                        }
                    });
                }
            });
        } else {
            tamocoRequestCallback.onResult(null);
        }
    }

    ExecutorService c() {
        return this.b != null ? this.b : Executors.newSingleThreadExecutor();
    }
}

