/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk.anrwatchdogs;

import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.tamoco.sdk.anrwatchdogs.ANRError;

public class ANRWatchDog
extends Thread {
    private static final ANRListener a = new ANRListener(){

        @Override
        public void onAppNotResponding(ANRError error) {
        }
    };
    private static final InterruptionListener b = new InterruptionListener(){

        @Override
        public void onInterrupted(InterruptedException exception) {
            Log.w((String)"ANRWatchdog", (String)("Interrupted: " + exception.getMessage()));
        }
    };
    private ANRListener c = a;
    private InterruptionListener d = b;
    private final Handler e = new Handler(Looper.getMainLooper());
    private final int f;
    private String g = "";
    private boolean h = false;
    private boolean i = false;
    private volatile int j = 0;
    private final Runnable k = new Runnable(){

        @Override
        public void run() {
            ANRWatchDog.this.j = (ANRWatchDog.this.j + 1) % Integer.MAX_VALUE;
        }
    };

    public ANRWatchDog() {
        this(5000);
    }

    public ANRWatchDog(int timeoutInterval) {
        this.f = timeoutInterval;
    }

    public ANRWatchDog setANRListener(ANRListener listener) {
        this.c = listener == null ? a : listener;
        return this;
    }

    public ANRWatchDog setInterruptionListener(InterruptionListener listener) {
        this.d = listener == null ? b : listener;
        return this;
    }

    public ANRWatchDog setReportThreadNamePrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.g = prefix;
        return this;
    }

    public ANRWatchDog setReportMainThreadOnly() {
        this.g = null;
        return this;
    }

    public ANRWatchDog setLogThreadsWithoutStackTrace(boolean logThreadsWithoutStackTrace) {
        this.h = logThreadsWithoutStackTrace;
        return this;
    }

    public ANRWatchDog setIgnoreDebugger(boolean ignoreDebugger) {
        this.i = ignoreDebugger;
        return this;
    }

    @Override
    public void run() {
        this.setName("|ANR-WatchDog|");
        int n2 = -1;
        while (!this.isInterrupted()) {
            int n3 = this.j;
            this.e.post(this.k);
            try {
                Thread.sleep(this.f);
            }
            catch (InterruptedException interruptedException) {
                this.d.onInterrupted(interruptedException);
                return;
            }
            if (this.j != n3) continue;
            if (!this.i && Debug.isDebuggerConnected()) {
                if (this.j != n2) {
                    Log.w((String)"ANRWatchdog", (String)"An ANR was detected but ignored because the debugger is connected (you can prevent this with setIgnoreDebugger(true))");
                }
                n2 = this.j;
                continue;
            }
            ANRError aNRError = this.g != null ? ANRError.a(this.g, this.h) : ANRError.a();
            this.c.onAppNotResponding(aNRError);
            return;
        }
    }

    public static interface InterruptionListener {
        public void onInterrupted(InterruptedException var1);
    }

    public static interface ANRListener {
        public void onAppNotResponding(ANRError var1);
    }
}

