/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.Index;
import android.net.wifi.ScanResult;
import android.os.Build;
import com.tamoco.sdk.InventoryEntityState;

@Entity(tableName="wifis_state", indices={@Index(value={"last_event"}), @Index(value={"connection_status"})})
public class WifiState
extends InventoryEntityState {
    @ColumnInfo(name="connection_status")
    private int mConnectionStatus;
    @ColumnInfo(name="scanned_mac")
    private String mScannedMac;
    @ColumnInfo(name="level")
    private Integer mLevel;
    @ColumnInfo(name="frequency")
    private Integer mFrequency;
    @ColumnInfo(name="center_freq0")
    private Integer mCenterFreq0;
    @ColumnInfo(name="center_freq1")
    private Integer mCenterFreq1;
    @ColumnInfo(name="venue_name")
    private String mVenueName;
    @ColumnInfo(name="operator_friendly_name")
    private String mOperatorFriendlyName;
    @ColumnInfo(name="capabilities")
    private String mCapabilities;
    @ColumnInfo(name="channel_width")
    private Integer mChannelWidth;

    public WifiState() {
    }

    @Ignore
    public WifiState(long inventoryId) {
        super(inventoryId);
    }

    public int getConnectionStatus() {
        return this.mConnectionStatus;
    }

    public void setConnectionStatus(int connectionStatus) {
        this.mConnectionStatus = connectionStatus;
    }

    public String getScannedMac() {
        return this.mScannedMac;
    }

    public void setScannedMac(String scannedMac) {
        this.mScannedMac = scannedMac;
    }

    public void setScanValues(ScanResult scanResult) {
        this.mScannedMac = scanResult.BSSID;
        this.mLevel = scanResult.level;
        this.mFrequency = scanResult.frequency;
        this.mCapabilities = scanResult.capabilities;
        if (Build.VERSION.SDK_INT >= 23) {
            this.mCenterFreq0 = scanResult.centerFreq0;
            this.mCenterFreq1 = scanResult.centerFreq1;
            this.mVenueName = scanResult.venueName != null ? scanResult.venueName.toString() : null;
            this.mOperatorFriendlyName = scanResult.operatorFriendlyName != null ? scanResult.operatorFriendlyName.toString() : null;
            this.mChannelWidth = scanResult.channelWidth;
        }
    }

    public Integer getLevel() {
        return this.mLevel;
    }

    public void setLevel(Integer level) {
        this.mLevel = level;
    }

    public Integer getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(Integer frequency) {
        this.mFrequency = frequency;
    }

    public Integer getCenterFreq0() {
        return this.mCenterFreq0;
    }

    public void setCenterFreq0(Integer centerFreq0) {
        this.mCenterFreq0 = centerFreq0;
    }

    public Integer getCenterFreq1() {
        return this.mCenterFreq1;
    }

    public void setCenterFreq1(Integer centerFreq1) {
        this.mCenterFreq1 = centerFreq1;
    }

    public String getVenueName() {
        return this.mVenueName;
    }

    public void setVenueName(String venueName) {
        this.mVenueName = venueName;
    }

    public String getOperatorFriendlyName() {
        return this.mOperatorFriendlyName;
    }

    public void setOperatorFriendlyName(String operatorFriendlyName) {
        this.mOperatorFriendlyName = operatorFriendlyName;
    }

    public Integer getChannelWidth() {
        return this.mChannelWidth;
    }

    public void setChannelWidth(Integer channelWidth) {
        this.mChannelWidth = channelWidth;
    }

    public String getCapabilities() {
        return this.mCapabilities;
    }

    public void setCapabilities(String capabilities) {
        this.mCapabilities = capabilities;
    }
}

