/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tamoco.sdk.InventoryEntity;
import com.tamoco.sdk.InventoryEntityState;
import com.tamoco.sdk.doc.ITrigger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Trigger
implements Parcelable,
ITrigger {
    public static final int EVENT_UNKNOWN = 0;
    public static final int EVENT_SDK_BACKGROUND_JOB = 1;
    public static final int EVENT_BLE_ENTER = 11;
    public static final int EVENT_BLE_HOVER = 12;
    public static final int EVENT_BLE_DWELL = 13;
    public static final int EVENT_BLE_EXIT = 14;
    public static final int EVENT_GEOFENCE_ENTER = 21;
    public static final int EVENT_GEOFENCE_DWELL = 22;
    public static final int EVENT_GEOFENCE_EXIT = 23;
    public static final int EVENT_WIFI_ENTER = 31;
    public static final int EVENT_WIFI_DWELL = 32;
    public static final int EVENT_WIFI_EXIT = 33;
    public static final int EVENT_WIFI_CONNECT = 34;
    public static final int EVENT_WIFI_DISCONNECT = 35;
    public static final int EVENT_NFC_TAP = 41;
    public static final int EVENT_QR_SCAN = 51;
    public static final int EVENT_EDY_ENTER = 61;
    public static final int EVENT_EDY_HOVER = 62;
    public static final int EVENT_EDY_DWELL = 63;
    public static final int EVENT_EDY_EXIT = 64;
    public static final int EVENT_SENSOR_SCAN = 71;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_BEACON_OUT_OF_RANGE = 10;
    public static final int STATUS_BEACON_IN_RANGE = 11;
    public static final int STATUS_GEOFENCE_OUTSIDE = 20;
    public static final int STATUS_GEOFENCE_INSIDE = 21;
    public static final int STATUS_WIFI_OUT_OF_RANGE = 30;
    public static final int STATUS_WIFI_IN_RANGE = 31;
    public static final Parcelable.Creator<Trigger> CREATOR = new Parcelable.Creator<Trigger>(){

        public Trigger a(Parcel parcel) {
            return new Trigger(parcel);
        }

        public Trigger[] a(int n2) {
            return new Trigger[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };
    protected final long mId;
    protected final String mName;
    protected final double mLatitude;
    protected final double mLongitude;
    protected final long mDwellMillis;
    private int mLastEvent = 0;
    private int mStatus = 0;

    protected Trigger(@NonNull InventoryEntity entity, @Nullable InventoryEntityState state) {
        this.mId = entity.getId();
        this.mName = entity.getName();
        this.mLatitude = entity.getLatitude();
        this.mLongitude = entity.getLongitude();
        this.mDwellMillis = entity.getDwellMillis();
        if (state != null) {
            this.mLastEvent = state.getLastEvent();
            this.mStatus = state.getProximityStatus();
        }
    }

    protected Trigger(Parcel in) {
        this.mId = in.readLong();
        this.mName = in.readString();
        this.mLatitude = in.readDouble();
        this.mLongitude = in.readDouble();
        this.mDwellMillis = in.readLong();
        this.mLastEvent = in.readInt();
        this.mStatus = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i2) {
        parcel.writeLong(this.mId);
        parcel.writeString(this.mName);
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        parcel.writeLong(this.mDwellMillis);
        parcel.writeInt(this.mLastEvent);
        parcel.writeInt(this.mStatus);
    }

    @Override
    public long getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public double getLatitude() {
        return this.mLatitude;
    }

    @Override
    public double getLongitude() {
        return this.mLongitude;
    }

    public long getDwellMillis() {
        return this.mDwellMillis;
    }

    @Override
    public int getLastEvent() {
        return this.mLastEvent;
    }

    @Override
    public int getStatus() {
        return this.mStatus;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TriggerStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventType {
    }
}

