/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Embedded;
import android.arch.persistence.room.Entity;
import android.content.Context;
import android.location.Location;
import com.squareup.moshi.Json;
import com.tamoco.sdk.ApiRequestBody;
import com.tamoco.sdk.StoredBeacon;
import com.tamoco.sdk.StoredGeofence;
import com.tamoco.sdk.StoredWifi;
import com.tamoco.sdk.TriggerData;
import com.tamoco.sdk.l;

@Entity(tableName="batched_hits")
class TrackBody
extends ApiRequestBody {
    @Json(name="trigger")
    @Embedded(prefix="trigger_")
    TriggerData trigger;
    @ColumnInfo(name="expiration")
    long expiration;

    TrackBody() {
    }

    TrackBody(Context context, Location location, boolean foreground, Integer triggerType, long timestamp, l geoMotion) {
        super(context, location, foreground, geoMotion);
        this.trigger = new TriggerData(triggerType);
        this.sdkTimestamp = timestamp;
    }

    TrackBody(Context context, StoredGeofence geofence, Location location, boolean foreground, long defaultTtl, l geoMotion) {
        super(context, location, foreground, geoMotion);
        this.trigger = new TriggerData(geofence, location);
        long l2 = geofence.entity.mTtl != null ? geofence.entity.mTtl : defaultTtl;
        this.expiration = geofence.entity.mCreatedAt + l2;
    }

    TrackBody(Context context, StoredWifi wifi, Location location, Float environmentPressure, boolean foreground, long defaultTtl, l geoMotion) {
        super(context, location, environmentPressure, foreground, geoMotion);
        this.trigger = new TriggerData(wifi, location);
        long l2 = wifi.entity.mTtl != null ? wifi.entity.mTtl : defaultTtl;
        this.expiration = wifi.entity.mCreatedAt + l2;
    }

    TrackBody(Context context, StoredBeacon beacon, Location location, boolean foreground, long defaultTtl, l geoMotion) {
        super(context, location, foreground, geoMotion);
        this.trigger = new TriggerData(beacon, location);
        long l2 = beacon.entity.mTtl != null ? beacon.entity.mTtl : defaultTtl;
        this.expiration = beacon.entity.mCreatedAt + l2;
    }
}

