/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.support.annotation.NonNull;
import com.google.android.gms.location.Geofence;
import com.tamoco.sdk.InventoryEntity;
import com.tamoco.sdk.NearbyItemDto;
import java.util.concurrent.TimeUnit;

@Entity(tableName="geofence_inventory")
public class GeofenceEntity
extends InventoryEntity {
    @ColumnInfo(name="radius")
    private float mRadius;

    public GeofenceEntity() {
    }

    @Ignore
    GeofenceEntity(@NonNull NearbyItemDto item) {
        super(item);
        this.mRadius = item.radius != null ? item.radius.floatValue() : 0.0f;
    }

    public Geofence toGeofence(long defaultDwellMillis) {
        return new Geofence.Builder().setRequestId(String.valueOf(this.mId)).setCircularRegion(this.mLatitude, this.mLongitude, this.mRadius).setTransitionTypes(7).setLoiteringDelay((int)(this.mDwellMillis > 0L ? this.mDwellMillis : defaultDwellMillis)).setExpirationDuration(TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)).build();
    }

    public float getRadius() {
        return this.mRadius;
    }

    public void setRadius(float radius) {
        this.mRadius = radius;
    }
}

