/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.util.StringUtil;
import android.database.Cursor;
import com.tamoco.sdk.GeofenceDao;
import com.tamoco.sdk.GeofenceEntity;
import com.tamoco.sdk.GeofenceState;
import com.tamoco.sdk.StoredGeofence;
import java.util.ArrayList;
import java.util.List;

public class GeofenceDao_Impl
extends GeofenceDao {
    private final RoomDatabase a;
    private final EntityInsertionAdapter b;
    private final EntityInsertionAdapter c;

    public GeofenceDao_Impl(RoomDatabase __db) {
        this.a = __db;
        this.b = new EntityInsertionAdapter<GeofenceEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `geofence_inventory`(`id`,`name`,`latitude`,`longitude`,`dwell_millis`,`hover_millis`,`distance`,`ttl`,`created_at`,`radius`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void a(SupportSQLiteStatement supportSQLiteStatement, GeofenceEntity geofenceEntity) {
                supportSQLiteStatement.bindLong(1, geofenceEntity.getId());
                if (geofenceEntity.getName() == null) {
                    supportSQLiteStatement.bindNull(2);
                } else {
                    supportSQLiteStatement.bindString(2, geofenceEntity.getName());
                }
                supportSQLiteStatement.bindDouble(3, geofenceEntity.getLatitude());
                supportSQLiteStatement.bindDouble(4, geofenceEntity.getLongitude());
                supportSQLiteStatement.bindLong(5, geofenceEntity.getDwellMillis());
                supportSQLiteStatement.bindLong(6, geofenceEntity.getHoverMillis());
                supportSQLiteStatement.bindDouble(7, (double)geofenceEntity.getDistance());
                if (geofenceEntity.getTtl() == null) {
                    supportSQLiteStatement.bindNull(8);
                } else {
                    supportSQLiteStatement.bindLong(8, geofenceEntity.getTtl().longValue());
                }
                supportSQLiteStatement.bindLong(9, geofenceEntity.getCreatedAt());
                supportSQLiteStatement.bindDouble(10, (double)geofenceEntity.getRadius());
            }

            public /* synthetic */ void bind(SupportSQLiteStatement supportSQLiteStatement, Object object) {
                this.a(supportSQLiteStatement, (GeofenceEntity)object);
            }
        };
        this.c = new EntityInsertionAdapter<GeofenceState>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `geofences_state`(`inventory_id`,`last_event`,`last_event_timestamp`,`proximity_status`,`proximity_timestamp`,`dwell_reported`,`hover_reported`) VALUES (?,?,?,?,?,?,?)";
            }

            public void a(SupportSQLiteStatement supportSQLiteStatement, GeofenceState geofenceState) {
                supportSQLiteStatement.bindLong(1, geofenceState.getInventoryId());
                supportSQLiteStatement.bindLong(2, (long)geofenceState.getLastEvent());
                supportSQLiteStatement.bindLong(3, geofenceState.getLastEventTimeStamp());
                supportSQLiteStatement.bindLong(4, (long)geofenceState.getProximityStatus());
                supportSQLiteStatement.bindLong(5, geofenceState.getProximityStatusTimestamp());
                int n2 = geofenceState.isDwellReported() ? 1 : 0;
                supportSQLiteStatement.bindLong(6, (long)n2);
                int n3 = geofenceState.isHoverReported() ? 1 : 0;
                supportSQLiteStatement.bindLong(7, (long)n3);
            }

            public /* synthetic */ void bind(SupportSQLiteStatement supportSQLiteStatement, Object object) {
                this.a(supportSQLiteStatement, (GeofenceState)object);
            }
        };
    }

    @Override
    void b(List<GeofenceEntity> list) {
        this.a.beginTransaction();
        try {
            this.b.insert(list);
            this.a.setTransactionSuccessful();
        }
        finally {
            this.a.endTransaction();
        }
    }

    @Override
    void a(GeofenceState geofenceState) {
        this.a.beginTransaction();
        try {
            this.c.insert((Object)geofenceState);
            this.a.setTransactionSuccessful();
        }
        finally {
            this.a.endTransaction();
        }
    }

    @Override
    void a(List<GeofenceEntity> list) {
        this.a.beginTransaction();
        try {
            super.a(list);
            this.a.setTransactionSuccessful();
        }
        finally {
            this.a.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<StoredGeofence> a() {
        String string = "SELECT * FROM geofence_inventory geofence LEFT JOIN geofences_state state ON(geofence.id = state.inventory_id)";
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM geofence_inventory geofence LEFT JOIN geofences_state state ON(geofence.id = state.inventory_id)", (int)0);
        Cursor cursor = this.a.query((SupportSQLiteQuery)roomSQLiteQuery);
        try {
            Object object;
            int n2 = cursor.getColumnIndexOrThrow("id");
            int n3 = cursor.getColumnIndexOrThrow("name");
            int n4 = cursor.getColumnIndexOrThrow("latitude");
            int n5 = cursor.getColumnIndexOrThrow("longitude");
            int n6 = cursor.getColumnIndexOrThrow("dwell_millis");
            int n7 = cursor.getColumnIndexOrThrow("hover_millis");
            int n8 = cursor.getColumnIndexOrThrow("distance");
            int n9 = cursor.getColumnIndexOrThrow("ttl");
            int n10 = cursor.getColumnIndexOrThrow("created_at");
            int n11 = cursor.getColumnIndexOrThrow("radius");
            int n12 = cursor.getColumnIndexOrThrow("inventory_id");
            int n13 = cursor.getColumnIndexOrThrow("last_event");
            int n14 = cursor.getColumnIndexOrThrow("last_event_timestamp");
            int n15 = cursor.getColumnIndexOrThrow("proximity_status");
            int n16 = cursor.getColumnIndexOrThrow("proximity_timestamp");
            int n17 = cursor.getColumnIndexOrThrow("dwell_reported");
            int n18 = cursor.getColumnIndexOrThrow("hover_reported");
            ArrayList<StoredGeofence> arrayList = new ArrayList<StoredGeofence>(cursor.getCount());
            while (cursor.moveToNext()) {
                GeofenceState geofenceState;
                long l2;
                GeofenceEntity geofenceEntity;
                if (!(cursor.isNull(n2) && cursor.isNull(n3) && cursor.isNull(n4) && cursor.isNull(n5) && cursor.isNull(n6) && cursor.isNull(n7) && cursor.isNull(n8) && cursor.isNull(n9) && cursor.isNull(n10) && cursor.isNull(n11))) {
                    geofenceEntity = new GeofenceEntity();
                    long l3 = cursor.getLong(n2);
                    geofenceEntity.setId(l3);
                    String string2 = cursor.getString(n3);
                    geofenceEntity.setName(string2);
                    double d2 = cursor.getDouble(n4);
                    geofenceEntity.setLatitude(d2);
                    double d3 = cursor.getDouble(n5);
                    geofenceEntity.setLongitude(d3);
                    l2 = cursor.getLong(n6);
                    geofenceEntity.setDwellMillis(l2);
                    long l4 = cursor.getLong(n7);
                    geofenceEntity.setHoverMillis(l4);
                    float f2 = cursor.getFloat(n8);
                    geofenceEntity.setDistance(f2);
                    Long l5 = cursor.isNull(n9) ? null : Long.valueOf(cursor.getLong(n9));
                    geofenceEntity.setTtl(l5);
                    long l6 = cursor.getLong(n10);
                    geofenceEntity.setCreatedAt(l6);
                    float f3 = cursor.getFloat(n11);
                    geofenceEntity.setRadius(f3);
                } else {
                    geofenceEntity = null;
                }
                if (!(cursor.isNull(n12) && cursor.isNull(n13) && cursor.isNull(n14) && cursor.isNull(n15) && cursor.isNull(n16) && cursor.isNull(n17) && cursor.isNull(n18))) {
                    geofenceState = new GeofenceState();
                    long l7 = cursor.getLong(n12);
                    geofenceState.setInventoryId(l7);
                    int n19 = cursor.getInt(n13);
                    geofenceState.setLastEvent(n19);
                    long l8 = cursor.getLong(n14);
                    geofenceState.setLastEventTimeStamp(l8);
                    int n20 = cursor.getInt(n15);
                    geofenceState.setProximityStatus(n20);
                    l2 = cursor.getLong(n16);
                    geofenceState.setProximityStatusTimestamp(l2);
                    int n21 = cursor.getInt(n17);
                    boolean bl = n21 != 0;
                    geofenceState.setDwellReported(bl);
                    int n22 = cursor.getInt(n18);
                    boolean bl2 = n22 != 0;
                    geofenceState.setHoverReported(bl2);
                } else {
                    geofenceState = null;
                }
                object = new StoredGeofence();
                ((StoredGeofence)object).entity = geofenceEntity;
                ((StoredGeofence)object).state = geofenceState;
                arrayList.add((StoredGeofence)object);
            }
            object = arrayList;
            return object;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    StoredGeofence a(long l2) {
        String string = "SELECT * FROM geofence_inventory geofence LEFT JOIN geofences_state state ON(geofence.id = state.inventory_id) WHERE id = ?";
        RoomSQLiteQuery roomSQLiteQuery = RoomSQLiteQuery.acquire((String)"SELECT * FROM geofence_inventory geofence LEFT JOIN geofences_state state ON(geofence.id = state.inventory_id) WHERE id = ?", (int)1);
        int n2 = 1;
        roomSQLiteQuery.bindLong(n2, l2);
        Cursor cursor = this.a.query((SupportSQLiteQuery)roomSQLiteQuery);
        try {
            Object object;
            GeofenceEntity geofenceEntity;
            int n3 = cursor.getColumnIndexOrThrow("id");
            int n4 = cursor.getColumnIndexOrThrow("name");
            int n5 = cursor.getColumnIndexOrThrow("latitude");
            int n6 = cursor.getColumnIndexOrThrow("longitude");
            int n7 = cursor.getColumnIndexOrThrow("dwell_millis");
            int n8 = cursor.getColumnIndexOrThrow("hover_millis");
            int n9 = cursor.getColumnIndexOrThrow("distance");
            int n10 = cursor.getColumnIndexOrThrow("ttl");
            int n11 = cursor.getColumnIndexOrThrow("created_at");
            int n12 = cursor.getColumnIndexOrThrow("radius");
            int n13 = cursor.getColumnIndexOrThrow("inventory_id");
            int n14 = cursor.getColumnIndexOrThrow("last_event");
            int n15 = cursor.getColumnIndexOrThrow("last_event_timestamp");
            int n16 = cursor.getColumnIndexOrThrow("proximity_status");
            int n17 = cursor.getColumnIndexOrThrow("proximity_timestamp");
            int n18 = cursor.getColumnIndexOrThrow("dwell_reported");
            int n19 = cursor.getColumnIndexOrThrow("hover_reported");
            if (cursor.moveToFirst()) {
                GeofenceState geofenceState;
                long l3;
                if (!(cursor.isNull(n3) && cursor.isNull(n4) && cursor.isNull(n5) && cursor.isNull(n6) && cursor.isNull(n7) && cursor.isNull(n8) && cursor.isNull(n9) && cursor.isNull(n10) && cursor.isNull(n11) && cursor.isNull(n12))) {
                    geofenceEntity = new GeofenceEntity();
                    long l4 = cursor.getLong(n3);
                    geofenceEntity.setId(l4);
                    String string2 = cursor.getString(n4);
                    geofenceEntity.setName(string2);
                    double d2 = cursor.getDouble(n5);
                    geofenceEntity.setLatitude(d2);
                    double d3 = cursor.getDouble(n6);
                    geofenceEntity.setLongitude(d3);
                    l3 = cursor.getLong(n7);
                    geofenceEntity.setDwellMillis(l3);
                    long l5 = cursor.getLong(n8);
                    geofenceEntity.setHoverMillis(l5);
                    float f2 = cursor.getFloat(n9);
                    geofenceEntity.setDistance(f2);
                    Long l6 = cursor.isNull(n10) ? null : Long.valueOf(cursor.getLong(n10));
                    geofenceEntity.setTtl(l6);
                    long l7 = cursor.getLong(n11);
                    geofenceEntity.setCreatedAt(l7);
                    float f3 = cursor.getFloat(n12);
                    geofenceEntity.setRadius(f3);
                } else {
                    geofenceEntity = null;
                }
                if (!(cursor.isNull(n13) && cursor.isNull(n14) && cursor.isNull(n15) && cursor.isNull(n16) && cursor.isNull(n17) && cursor.isNull(n18) && cursor.isNull(n19))) {
                    geofenceState = new GeofenceState();
                    long l8 = cursor.getLong(n13);
                    geofenceState.setInventoryId(l8);
                    int n20 = cursor.getInt(n14);
                    geofenceState.setLastEvent(n20);
                    long l9 = cursor.getLong(n15);
                    geofenceState.setLastEventTimeStamp(l9);
                    int n21 = cursor.getInt(n16);
                    geofenceState.setProximityStatus(n21);
                    l3 = cursor.getLong(n17);
                    geofenceState.setProximityStatusTimestamp(l3);
                    int n22 = cursor.getInt(n18);
                    boolean bl = n22 != 0;
                    geofenceState.setDwellReported(bl);
                    int n23 = cursor.getInt(n19);
                    boolean bl2 = n23 != 0;
                    geofenceState.setHoverReported(bl2);
                } else {
                    geofenceState = null;
                }
                object = new StoredGeofence();
                ((StoredGeofence)object).entity = geofenceEntity;
                ((StoredGeofence)object).state = geofenceState;
            } else {
                object = null;
            }
            geofenceEntity = object;
            return geofenceEntity;
        }
        finally {
            cursor.close();
            roomSQLiteQuery.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void c(List<Long> list) {
        StringBuilder stringBuilder = StringUtil.newStringBuilder();
        stringBuilder.append("DELETE FROM geofence_inventory WHERE id NOT IN(");
        int n2 = list.size();
        StringUtil.appendPlaceholders((StringBuilder)stringBuilder, (int)n2);
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        SupportSQLiteStatement supportSQLiteStatement = this.a.compileStatement(string);
        int n3 = 1;
        for (Long l2 : list) {
            if (l2 == null) {
                supportSQLiteStatement.bindNull(n3);
            } else {
                supportSQLiteStatement.bindLong(n3, l2.longValue());
            }
            ++n3;
        }
        this.a.beginTransaction();
        try {
            supportSQLiteStatement.executeUpdateDelete();
            this.a.setTransactionSuccessful();
        }
        finally {
            this.a.endTransaction();
        }
    }
}

