/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.content.Intent;
import com.squareup.moshi.Json;

class ChargingData {
    @Json(name="on")
    @ColumnInfo(name="on")
    boolean on;
    @Json(name="source")
    @ColumnInfo(name="source")
    Integer source;

    ChargingData() {
    }

    ChargingData(Intent batteryStatus) {
        this.on = this.isCharging(batteryStatus);
        this.source = this.getChargingSource(batteryStatus);
    }

    private boolean isCharging(Intent batteryStatus) {
        int n2 = batteryStatus != null ? batteryStatus.getIntExtra("status", -1) : 1;
        return n2 == 2 || n2 == 5;
    }

    private Integer getChargingSource(Intent batteryStatus) {
        if (batteryStatus != null) {
            int n2 = batteryStatus.getIntExtra("plugged", 0);
            switch (n2) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
            }
        }
        return 0;
    }
}

