/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.location.Location;
import android.os.Build;
import android.support.annotation.NonNull;

@Entity(tableName="batched_locations")
class BatchedLocation {
    @PrimaryKey(autoGenerate=true)
    @ColumnInfo(name="id")
    long id;
    @ColumnInfo(name="latitude")
    double latitude;
    @ColumnInfo(name="longitude")
    double longitude;
    @ColumnInfo(name="accuracy")
    Float accuracy;
    @ColumnInfo(name="bearing")
    float bearing;
    @ColumnInfo(name="altitude")
    double altitude;
    @ColumnInfo(name="altitude_accuracy")
    Float altitudeAccuracy;
    @ColumnInfo(name="speed")
    Float speed;
    @ColumnInfo(name="speed_accuracy")
    Float speedAccuracy;
    @ColumnInfo(name="sdk_timestamp")
    long sdkTimestamp;
    @ColumnInfo(name="provider")
    String provider;

    BatchedLocation() {
    }

    @Ignore
    BatchedLocation(@NonNull Location location) {
        this.latitude = location.getLatitude();
        this.longitude = location.getLongitude();
        if (location.hasAccuracy()) {
            this.accuracy = Float.valueOf(location.getAccuracy());
        }
        this.bearing = location.getBearing();
        this.altitude = location.getAltitude();
        if (Build.VERSION.SDK_INT >= 26) {
            this.altitudeAccuracy = Float.valueOf(location.getVerticalAccuracyMeters());
        }
        if (location.hasSpeed()) {
            this.speed = Float.valueOf(location.getSpeed());
            if (Build.VERSION.SDK_INT >= 26) {
                this.speedAccuracy = Float.valueOf(location.getSpeedAccuracyMetersPerSecond());
            }
        }
        this.sdkTimestamp = location.getTime();
        this.provider = location.getProvider();
    }

    @Ignore
    Location toLocation() {
        Location location = new Location(this.provider);
        location.setLatitude(this.latitude);
        location.setLongitude(this.longitude);
        if (this.accuracy != null) {
            location.setAccuracy(this.accuracy.floatValue());
        }
        location.setBearing(this.bearing);
        location.setAltitude(this.altitude);
        if (this.speed != null) {
            location.setSpeed(this.speed.floatValue());
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (this.altitudeAccuracy != null) {
                location.setVerticalAccuracyMeters(this.altitudeAccuracy.floatValue());
            }
            if (this.speedAccuracy != null) {
                location.setSpeedAccuracyMetersPerSecond(this.speedAccuracy.floatValue());
            }
        }
        location.setTime(this.sdkTimestamp);
        return location;
    }
}

