/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Ignore;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.squareup.moshi.Json;
import com.tamoco.sdk.TamocoLog;

class AppData {
    @Json(name="app_id")
    @ColumnInfo(name="app_id")
    String appId;
    @Json(name="bundle_id")
    @ColumnInfo(name="bundle_id")
    String bundleId;
    @Json(name="app_name")
    @ColumnInfo(name="app_name")
    String appName;
    @Json(name="normalized_app_name")
    @ColumnInfo(name="normalized_app_name")
    String normalizedAppName;
    @Json(name="app_version")
    @ColumnInfo(name="app_version")
    String appVersion;
    @Json(name="sdk_version")
    @ColumnInfo(name="sdk_version")
    String sdkVersion;
    @Json(name="foreground")
    @ColumnInfo(name="foreground")
    boolean foreground;

    AppData() {
    }

    @Ignore
    AppData(Context context, boolean foreground) {
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            this.appId = packageInfo.packageName;
            this.bundleId = packageInfo.packageName;
            this.appName = context.getString(applicationInfo.labelRes);
            if (Build.VERSION.SDK_INT >= 17) {
                Context context2 = context.createConfigurationContext(context.getResources().getConfiguration());
                this.normalizedAppName = context2.getString(applicationInfo.labelRes);
            }
            this.appVersion = packageInfo.versionName;
            this.sdkVersion = "2.2.0";
            this.foreground = foreground;
        }
        catch (Exception exception) {
            TamocoLog.e("AppData", "Error creating new instance.", exception);
        }
    }
}

