/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.content.Context;
import android.location.Location;
import android.net.wifi.ScanResult;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.tamoco.sdk.ApiRequestBody;
import com.tamoco.sdk.AroundMeBody;
import com.tamoco.sdk.AroundMeTrigger;
import com.tamoco.sdk.BeaconEntity;
import com.tamoco.sdk.BeaconState;
import com.tamoco.sdk.GeofenceEntity;
import com.tamoco.sdk.GeofenceState;
import com.tamoco.sdk.InventoryRepository;
import com.tamoco.sdk.LocalDatabase;
import com.tamoco.sdk.NearbyItemDto;
import com.tamoco.sdk.NearbyResponse;
import com.tamoco.sdk.NotificationSettings;
import com.tamoco.sdk.PreferencesManager;
import com.tamoco.sdk.RemoteSettingsResponse;
import com.tamoco.sdk.StoredBeacon;
import com.tamoco.sdk.StoredGeofence;
import com.tamoco.sdk.StoredWifi;
import com.tamoco.sdk.TamocoLog;
import com.tamoco.sdk.TrackBodyBroadcast;
import com.tamoco.sdk.WifiEntity;
import com.tamoco.sdk.WifiState;
import com.tamoco.sdk.c;
import com.tamoco.sdk.f;
import com.tamoco.sdk.l;
import com.tamoco.sdk.q;
import com.tamoco.sdk.s;
import com.tamoco.sdk.w;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import retrofit2.Response;

@WorkerThread
class o
implements InventoryRepository {
    private LocalDatabase a;
    private q b;
    private PreferencesManager c;
    private f d;
    private c e;

    o(@NonNull c c2, @NonNull LocalDatabase localDatabase, @NonNull f f2, @NonNull q q2, @NonNull PreferencesManager preferencesManager) {
        this.e = c2;
        this.a = localDatabase;
        this.d = f2;
        this.b = q2;
        this.c = preferencesManager;
    }

    @Override
    public synchronized boolean updateInventory(@NonNull Context context, @NonNull Location currentLocation) {
        l l2 = this.c.getGeoMotionData();
        s s2 = new s(context, currentLocation, this.c.isInForeground(), l2);
        try {
            Response response = this.e.a(s2).execute();
            TrackBodyBroadcast.sendBodyTrigger(context, new w(s2, response.code()), 13);
            if (response.isSuccessful()) {
                NearbyResponse nearbyResponse = (NearbyResponse)response.body();
                if (nearbyResponse != null) {
                    Location location;
                    this.c.setLastUpdateInterval(TimeUnit.MILLISECONDS.convert(nearbyResponse.interval, TimeUnit.SECONDS));
                    this.c.setLastUpdateThreshold(nearbyResponse.threshold);
                    if (nearbyResponse.wakeup != null && nearbyResponse.wakeup.latitude != null && nearbyResponse.wakeup.longitude != null && (nearbyResponse.wakeup.latitude != 0.0 || nearbyResponse.wakeup.longitude != 0.0)) {
                        location = new Location("");
                        location.setLatitude(nearbyResponse.wakeup.latitude.doubleValue());
                        location.setLongitude(nearbyResponse.wakeup.longitude.doubleValue());
                        this.c.setWakeupGeofenceCenter(location);
                        this.c.setWakeupGeofenceRadius(nearbyResponse.wakeup.radius.floatValue());
                    } else {
                        this.c.setWakeupGeofenceCenter(null);
                    }
                    if (nearbyResponse.inventory != null) {
                        location = new ArrayList();
                        ArrayList<WifiEntity> arrayList = new ArrayList<WifiEntity>();
                        ArrayList<BeaconEntity> arrayList2 = new ArrayList<BeaconEntity>();
                        for (NearbyItemDto nearbyItemDto : nearbyResponse.inventory) {
                            switch (nearbyItemDto.inventoryType) {
                                case 2: {
                                    location.add(new GeofenceEntity(nearbyItemDto));
                                    break;
                                }
                                case 3: {
                                    arrayList.add(new WifiEntity(nearbyItemDto));
                                    break;
                                }
                                case 1: 
                                case 7: {
                                    arrayList2.add(new BeaconEntity(nearbyItemDto));
                                }
                            }
                        }
                        this.a.geofenceDao().a((List<GeofenceEntity>)location);
                        this.a.wifiDao().a(arrayList);
                        this.a.beaconDao().a(arrayList2);
                        return true;
                    }
                    TamocoLog.d("InventoryRepository", "Empty inventory received");
                    return false;
                }
                TamocoLog.d("InventoryRepository", "Null inventory received");
                return false;
            }
            TamocoLog.d("InventoryRepository", "Inventory update failed with code: " + response.code());
            return false;
        }
        catch (IOException iOException) {
            TamocoLog.d("InventoryRepository", "Error getting nearby inventory", iOException);
            return false;
        }
    }

    @Override
    public synchronized boolean updateRemoteSettings(@NonNull Context context) {
        try {
            l l2 = this.c.getGeoMotionData();
            Location location = this.b.a(context);
            Response response = this.e.a(new ApiRequestBody(context, location, this.c.isInForeground(), l2)).execute();
            if (response.isSuccessful()) {
                this.a((RemoteSettingsResponse)response.body());
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            TamocoLog.d("InventoryRepository", "Error getting remote configuration", iOException);
            return false;
        }
    }

    @Override
    public synchronized boolean flushTriggersAroundMe(@NonNull Context context) {
        List<AroundMeTrigger> list = this.a.aroundMeTriggerDao().a();
        if (!list.isEmpty()) {
            Location location = this.b.a(context);
            try {
                l l2 = this.c.getGeoMotionData();
                AroundMeBody aroundMeBody = new AroundMeBody(context, location, this.c.isInForeground(), list, l2);
                Response response = this.e.a(aroundMeBody).execute();
                TrackBodyBroadcast.sendBodyTrigger(context, new w(aroundMeBody, response.code()), 11);
                if (response.isSuccessful()) {
                    this.a.aroundMeTriggerDao().a(list);
                    return true;
                }
                return false;
            }
            catch (IOException iOException) {
                TamocoLog.d("InventoryRepository", "Error flushing around me triggers", iOException);
                return false;
            }
        }
        return true;
    }

    @Override
    public void reportAroundMeBleBeacon(@NonNull Context context, String beaconId, Integer major, Integer minor, String mac, Integer rssi, Integer manufacturer, String bluetoothName, Integer txPower) {
        boolean bl = this.a.aroundMeTriggerDao().a(beaconId, major, minor);
        l l2 = this.c.getGeoMotionData();
        if (!bl) {
            Location location = this.b.a(context);
            AroundMeTrigger aroundMeTrigger = new AroundMeTrigger(location, beaconId, major, minor, mac, rssi, manufacturer, bluetoothName, txPower, l2);
            if (location.getLongitude() != 0.0 && location.getLatitude() != 0.0) {
                this.a.aroundMeTriggerDao().a(aroundMeTrigger);
            }
        }
    }

    @Override
    public void reportAroundMeEddystone(@NonNull Context context, String namespace, String instance, String mac, Integer rssi, Integer manufacturer, String bluetoothName, Integer txPower) {
        boolean bl = this.a.aroundMeTriggerDao().a(namespace, instance);
        l l2 = this.c.getGeoMotionData();
        if (!bl) {
            Location location = this.b.a(context);
            AroundMeTrigger aroundMeTrigger = new AroundMeTrigger(location, namespace, instance, mac, rssi, manufacturer, bluetoothName, txPower, l2);
            if (location.getLongitude() != 0.0 && location.getLatitude() != 0.0) {
                this.a.aroundMeTriggerDao().a(aroundMeTrigger);
            }
        }
    }

    @Override
    public void reportWifiAroundMe(@NonNull Context context, ScanResult scanResult) {
        boolean bl = this.a.aroundMeTriggerDao().b(scanResult.SSID, scanResult.BSSID);
        if (!bl) {
            Location location = this.b.a(context);
            Float f2 = null;
            if (this.c.isBarometerEnabled()) {
                f2 = Float.valueOf(this.d.a());
            }
            l l2 = this.c.getGeoMotionData();
            AroundMeTrigger aroundMeTrigger = new AroundMeTrigger(location, f2, scanResult, l2);
            if (location.getLongitude() != 0.0 && location.getLatitude() != 0.0) {
                this.a.aroundMeTriggerDao().a(aroundMeTrigger);
            }
        }
    }

    private void a(RemoteSettingsResponse remoteSettingsResponse) {
        if (remoteSettingsResponse != null) {
            if (remoteSettingsResponse.barometer != null && remoteSettingsResponse.barometer.enabled != null) {
                this.c.setBarometerEnabled(remoteSettingsResponse.barometer.enabled);
            }
            if (remoteSettingsResponse.beacon != null) {
                if (remoteSettingsResponse.beacon.dwellDelay != null) {
                    this.c.setDefaultBeaconDwellDelay(remoteSettingsResponse.beacon.dwellDelay.intValue());
                }
                if (remoteSettingsResponse.beacon.scanDuration != null) {
                    this.c.setBeaconScanDuration(remoteSettingsResponse.beacon.scanDuration.intValue());
                }
                if (remoteSettingsResponse.beacon.scanInterval != null) {
                    this.c.setBeaconScanInterval(remoteSettingsResponse.beacon.scanInterval.intValue());
                }
                if (remoteSettingsResponse.beacon.reportDelay != null) {
                    this.c.setBeaconScanReportDelay(remoteSettingsResponse.beacon.reportDelay.intValue());
                }
                if (remoteSettingsResponse.beacon.nearDistance != null) {
                    this.c.setBeaconNearDistance(remoteSettingsResponse.beacon.nearDistance.intValue());
                }
                if (remoteSettingsResponse.beacon.hoverDelay != null) {
                    this.c.setDefaultBeaconHoverDelay(remoteSettingsResponse.beacon.hoverDelay.intValue());
                }
            }
            if (remoteSettingsResponse.geofence != null && remoteSettingsResponse.geofence.dwellDelay != null) {
                this.c.setDefaultGeofenceDwellDelay(remoteSettingsResponse.geofence.dwellDelay.intValue());
            }
            if (remoteSettingsResponse.hit != null && remoteSettingsResponse.hit.uploadInterval != null) {
                this.c.setHitUploadInterval(remoteSettingsResponse.hit.uploadInterval.intValue());
            }
            if (remoteSettingsResponse.inventory != null) {
                if (remoteSettingsResponse.inventory.updateInterval != null) {
                    this.c.setLastUpdateInterval(remoteSettingsResponse.inventory.updateInterval.intValue());
                }
                if (remoteSettingsResponse.inventory.ttl != null) {
                    this.c.setDefaultInventoryTtl(remoteSettingsResponse.inventory.ttl.intValue());
                }
            }
            if (remoteSettingsResponse.location != null) {
                if (remoteSettingsResponse.location.uploadInterval != null) {
                    this.c.setLocationsUploadInterval(remoteSettingsResponse.location.uploadInterval.intValue());
                }
                if (remoteSettingsResponse.location.updateInterval != null) {
                    this.c.setLocationUpdateInterval(remoteSettingsResponse.location.updateInterval.intValue());
                }
            }
            if (remoteSettingsResponse.notification != null) {
                for (NotificationSettings notificationSettings : remoteSettingsResponse.notification) {
                    if (!NotificationSettings.TYPE_ROLLBAR.equals(notificationSettings.type)) continue;
                    if (notificationSettings.token == null) break;
                    this.c.setRollbarToken(notificationSettings.token);
                    break;
                }
            }
            if (remoteSettingsResponse.wifi != null) {
                if (remoteSettingsResponse.wifi.dwellDelay != null) {
                    this.c.setDefaultWifiDwellDelay(remoteSettingsResponse.wifi.dwellDelay.intValue());
                }
                if (remoteSettingsResponse.wifi.scanInterval != null) {
                    this.c.setWifiScanInterval(remoteSettingsResponse.wifi.scanInterval.intValue());
                }
            }
            if (remoteSettingsResponse.settings != null && remoteSettingsResponse.settings.updateInterval != null) {
                this.c.setSettingsUpdateInterval(remoteSettingsResponse.settings.updateInterval.intValue());
            }
        }
    }

    @Override
    public List<StoredGeofence> getGeofences() {
        return this.a.geofenceDao().a();
    }

    @Override
    public StoredGeofence getGeofence(long id) {
        return this.a.geofenceDao().a(id);
    }

    @Override
    public void updateGeofenceState(GeofenceState state) {
        this.a.geofenceDao().a(state);
    }

    @Override
    public List<StoredWifi> getWifiNetworks() {
        return this.a.wifiDao().a();
    }

    @Override
    public StoredWifi getWifi(long id) {
        return this.a.wifiDao().a(id);
    }

    @Override
    public List<StoredWifi> getWifiBySSid(String ssid) {
        return this.a.wifiDao().a(ssid);
    }

    @Override
    public List<StoredWifi> getWifiByStatus(int status) {
        return this.a.wifiDao().a(status);
    }

    @Override
    public void updateWifiState(WifiState state) {
        this.a.wifiDao().a(state);
    }

    @Override
    public List<StoredWifi> getWifisNotScanned(Integer state, List<String> ssids) {
        return this.a.wifiDao().a(state, ssids);
    }

    @Override
    public List<StoredBeacon> getBeacons() {
        return this.a.beaconDao().a();
    }

    @Override
    public StoredBeacon getBeacon(long id) {
        return this.a.beaconDao().a(id);
    }

    @Override
    public StoredBeacon getAltBeacon(String uuid, Integer major, Integer minor) {
        return this.a.beaconDao().a(uuid, major, minor);
    }

    @Override
    public StoredBeacon getEddystone(String namespace, String instance) {
        return this.a.beaconDao().a(namespace, instance);
    }

    @Override
    public List<StoredBeacon> getBeaconsNotFoundByStatus(int status) {
        return this.a.beaconDao().a(status);
    }

    @Override
    public void resetBeaconsFound() {
        this.a.beaconDao().b();
    }

    @Override
    public StoredBeacon getBeaconByMac(String mac) {
        return this.a.beaconDao().a(mac);
    }

    @Override
    public void updateBeaconState(BeaconState state) {
        this.a.beaconDao().a(state);
    }
}

