/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.room.DatabaseConfiguration;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomOpenHelper;
import android.arch.persistence.room.util.TableInfo;
import android.content.Context;
import com.tamoco.sdk.AroundMeDao_Impl;
import com.tamoco.sdk.BatchedLocationDao_Impl;
import com.tamoco.sdk.BeaconDao;
import com.tamoco.sdk.BeaconDao_Impl;
import com.tamoco.sdk.GeofenceDao;
import com.tamoco.sdk.GeofenceDao_Impl;
import com.tamoco.sdk.HitDao;
import com.tamoco.sdk.HitDao_Impl;
import com.tamoco.sdk.LocalDatabase;
import com.tamoco.sdk.WifiDao;
import com.tamoco.sdk.WifiDao_Impl;
import com.tamoco.sdk.e;
import com.tamoco.sdk.g;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class LocalDatabase_Impl
extends LocalDatabase {
    private volatile GeofenceDao a;
    private volatile WifiDao b;
    private volatile BeaconDao c;
    private volatile HitDao d;
    private volatile e e;
    private volatile g f;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper roomOpenHelper = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(12){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `geofence_inventory` (`id` INTEGER NOT NULL, `name` TEXT, `latitude` REAL NOT NULL, `longitude` REAL NOT NULL, `dwell_millis` INTEGER NOT NULL, `hover_millis` INTEGER NOT NULL, `distance` REAL NOT NULL, `ttl` INTEGER, `created_at` INTEGER NOT NULL, `radius` REAL NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `wifi_inventory` (`id` INTEGER NOT NULL, `name` TEXT, `latitude` REAL NOT NULL, `longitude` REAL NOT NULL, `dwell_millis` INTEGER NOT NULL, `hover_millis` INTEGER NOT NULL, `distance` REAL NOT NULL, `ttl` INTEGER, `created_at` INTEGER NOT NULL, `ssid` TEXT, `mac` TEXT, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE  INDEX `index_wifi_inventory_ssid` ON `wifi_inventory` (`ssid`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `beacon_inventory` (`id` INTEGER NOT NULL, `name` TEXT, `latitude` REAL NOT NULL, `longitude` REAL NOT NULL, `dwell_millis` INTEGER NOT NULL, `hover_millis` INTEGER NOT NULL, `distance` REAL NOT NULL, `ttl` INTEGER, `created_at` INTEGER NOT NULL, `uuid` TEXT, `namespace` TEXT, `major` INTEGER, `minor` INTEGER, `instance` TEXT, `mac` TEXT, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE  INDEX `index_beacon_inventory_uuid` ON `beacon_inventory` (`uuid`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `geofences_state` (`inventory_id` INTEGER NOT NULL, `last_event` INTEGER NOT NULL, `last_event_timestamp` INTEGER NOT NULL, `proximity_status` INTEGER NOT NULL, `proximity_timestamp` INTEGER NOT NULL, `dwell_reported` INTEGER NOT NULL, `hover_reported` INTEGER NOT NULL, PRIMARY KEY(`inventory_id`))");
                _db.execSQL("CREATE  INDEX `index_geofences_state_last_event` ON `geofences_state` (`last_event`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `wifis_state` (`inventory_id` INTEGER NOT NULL, `last_event` INTEGER NOT NULL, `last_event_timestamp` INTEGER NOT NULL, `connection_status` INTEGER NOT NULL, `scanned_mac` TEXT, `level` INTEGER, `frequency` INTEGER, `center_freq0` INTEGER, `center_freq1` INTEGER, `venue_name` TEXT, `operator_friendly_name` TEXT, `capabilities` TEXT, `channel_width` INTEGER, `proximity_status` INTEGER NOT NULL, `proximity_timestamp` INTEGER NOT NULL, `dwell_reported` INTEGER NOT NULL, `hover_reported` INTEGER NOT NULL, PRIMARY KEY(`inventory_id`))");
                _db.execSQL("CREATE  INDEX `index_wifis_state_last_event` ON `wifis_state` (`last_event`)");
                _db.execSQL("CREATE  INDEX `index_wifis_state_connection_status` ON `wifis_state` (`connection_status`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `beacons_state` (`inventory_id` INTEGER NOT NULL, `last_event` INTEGER NOT NULL, `last_event_timestamp` INTEGER NOT NULL, `scanned_mac` TEXT, `proximity` REAL, `found_in_previous_scan` INTEGER NOT NULL, `beacon_type` TEXT, `rssi` INTEGER, `manufacturer` INTEGER, `bluetooth_name` TEXT, `tx_power` INTEGER, `proximity_status` INTEGER NOT NULL, `proximity_timestamp` INTEGER NOT NULL, `dwell_reported` INTEGER NOT NULL, `hover_reported` INTEGER NOT NULL, PRIMARY KEY(`inventory_id`))");
                _db.execSQL("CREATE  INDEX `index_beacons_state_last_event` ON `beacons_state` (`last_event`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `batched_hits` (`event_id` TEXT NOT NULL, `sdk_timestamp` INTEGER, `custom_id` TEXT, `expiration` INTEGER NOT NULL, `device_device_id` TEXT, `device_lmt` INTEGER, `device_device_type` INTEGER, `device_make` TEXT, `device_model` TEXT, `device_screen_width` INTEGER, `device_screen_height` INTEGER, `device_sd_card_mounted` INTEGER, `device_locale` TEXT, `device_os` TEXT, `device_os_version` TEXT, `device_timezone` TEXT, `device_location` INTEGER, `device_ip` TEXT, `device_bluetooth` INTEGER, `device_wifi` INTEGER, `device_nfc` INTEGER, `device_pressure` REAL, `device_battery_level` INTEGER, `device_battery_health` INTEGER, `device_battery_saver` INTEGER, `device_battery_temperature` INTEGER, `device_battery_technology` TEXT, `device_battery_voltage` INTEGER, `device_charging_on` INTEGER, `device_charging_source` INTEGER, `device_carrier_network_operator_name` TEXT, `device_carrier_network_operator` TEXT, `device_carrier_network_country_iso` TEXT, `device_carrier_network_specifier` TEXT, `device_carrier_sim_country_iso` TEXT, `device_carrier_sim_operator_name` TEXT, `device_carrier_network_roaming` INTEGER, `device_carrier_data_activity` INTEGER, `app_app_id` TEXT, `app_bundle_id` TEXT, `app_app_name` TEXT, `app_normalized_app_name` TEXT, `app_app_version` TEXT, `app_sdk_version` TEXT, `app_foreground` INTEGER, `geo_provider` TEXT, `geo_latitude` REAL, `geo_longitude` REAL, `geo_accuracy` REAL, `geo_bearing` REAL, `geo_pressure` REAL, `geo_altitudevalue` REAL, `geo_altitudeaccuracy` REAL, `geo_speedvalue` REAL, `geo_speedaccuracy` REAL, `geo_motion_type` INTEGER, `geo_motion_confidence` INTEGER, `trigger_trigger_type` INTEGER, `trigger_inventory_id` INTEGER, `trigger_beacon_id` TEXT, `trigger_major` INTEGER, `trigger_minor` INTEGER, `trigger_namespace` TEXT, `trigger_instance` TEXT, `trigger_rssi` INTEGER, `trigger_bluetooth_name` TEXT, `trigger_manufactuer` INTEGER, `trigger_tx_power` INTEGER, `trigger_ssid` TEXT, `trigger_capabilities` TEXT, `trigger_mac` TEXT, `trigger_frequency` INTEGER, `trigger_center_freq_0` INTEGER, `trigger_center_freq_1` INTEGER, `trigger_venue_name` TEXT, `trigger_operator_name` TEXT, `trigger_channel_width` INTEGER, `trigger_trigger_code` TEXT, `trigger_trigger_variant` TEXT, `trigger_tag_id` TEXT, `trigger_tac` TEXT, `trigger_proximity` REAL, PRIMARY KEY(`event_id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `around_me_triggers` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `sdk_timestamp` INTEGER NOT NULL, `trigger_trigger_type` INTEGER, `trigger_inventory_id` INTEGER, `trigger_beacon_id` TEXT, `trigger_major` INTEGER, `trigger_minor` INTEGER, `trigger_namespace` TEXT, `trigger_instance` TEXT, `trigger_rssi` INTEGER, `trigger_bluetooth_name` TEXT, `trigger_manufactuer` INTEGER, `trigger_tx_power` INTEGER, `trigger_ssid` TEXT, `trigger_capabilities` TEXT, `trigger_mac` TEXT, `trigger_frequency` INTEGER, `trigger_center_freq_0` INTEGER, `trigger_center_freq_1` INTEGER, `trigger_venue_name` TEXT, `trigger_operator_name` TEXT, `trigger_channel_width` INTEGER, `trigger_trigger_code` TEXT, `trigger_trigger_variant` TEXT, `trigger_tag_id` TEXT, `trigger_tac` TEXT, `trigger_proximity` REAL, `geo_provider` TEXT, `geo_latitude` REAL, `geo_longitude` REAL, `geo_accuracy` REAL, `geo_bearing` REAL, `geo_pressure` REAL, `geo_altitudevalue` REAL, `geo_altitudeaccuracy` REAL, `geo_speedvalue` REAL, `geo_speedaccuracy` REAL, `geo_motion_type` INTEGER, `geo_motion_confidence` INTEGER)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `batched_locations` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `latitude` REAL NOT NULL, `longitude` REAL NOT NULL, `accuracy` REAL, `bearing` REAL NOT NULL, `altitude` REAL NOT NULL, `altitude_accuracy` REAL, `speed` REAL, `speed_accuracy` REAL, `sdk_timestamp` INTEGER NOT NULL, `provider` TEXT)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, \"a0f9fd9ca6a8d527adbdfa3c7965be14\")");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `geofence_inventory`");
                _db.execSQL("DROP TABLE IF EXISTS `wifi_inventory`");
                _db.execSQL("DROP TABLE IF EXISTS `beacon_inventory`");
                _db.execSQL("DROP TABLE IF EXISTS `geofences_state`");
                _db.execSQL("DROP TABLE IF EXISTS `wifis_state`");
                _db.execSQL("DROP TABLE IF EXISTS `beacons_state`");
                _db.execSQL("DROP TABLE IF EXISTS `batched_hits`");
                _db.execSQL("DROP TABLE IF EXISTS `around_me_triggers`");
                _db.execSQL("DROP TABLE IF EXISTS `batched_locations`");
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (LocalDatabase_Impl.this.mCallbacks != null) {
                    int n2 = LocalDatabase_Impl.this.mCallbacks.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        ((RoomDatabase.Callback)LocalDatabase_Impl.this.mCallbacks.get(i2)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                LocalDatabase_Impl.this.mDatabase = _db;
                LocalDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (LocalDatabase_Impl.this.mCallbacks != null) {
                    int n2 = LocalDatabase_Impl.this.mCallbacks.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        ((RoomDatabase.Callback)LocalDatabase_Impl.this.mCallbacks.get(i2)).onOpen(_db);
                    }
                }
            }

            protected void validateMigration(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> hashMap = new HashMap<String, TableInfo.Column>(10);
                hashMap.put("id", new TableInfo.Column("id", "INTEGER", true, 1));
                hashMap.put("name", new TableInfo.Column("name", "TEXT", false, 0));
                hashMap.put("latitude", new TableInfo.Column("latitude", "REAL", true, 0));
                hashMap.put("longitude", new TableInfo.Column("longitude", "REAL", true, 0));
                hashMap.put("dwell_millis", new TableInfo.Column("dwell_millis", "INTEGER", true, 0));
                hashMap.put("hover_millis", new TableInfo.Column("hover_millis", "INTEGER", true, 0));
                hashMap.put("distance", new TableInfo.Column("distance", "REAL", true, 0));
                hashMap.put("ttl", new TableInfo.Column("ttl", "INTEGER", false, 0));
                hashMap.put("created_at", new TableInfo.Column("created_at", "INTEGER", true, 0));
                hashMap.put("radius", new TableInfo.Column("radius", "REAL", true, 0));
                HashSet hashSet = new HashSet(0);
                HashSet hashSet2 = new HashSet(0);
                TableInfo tableInfo = new TableInfo("geofence_inventory", hashMap, hashSet, hashSet2);
                TableInfo tableInfo2 = TableInfo.read((SupportSQLiteDatabase)_db, (String)"geofence_inventory");
                if (!tableInfo.equals((Object)tableInfo2)) {
                    throw new IllegalStateException("Migration didn't properly handle geofence_inventory(com.tamoco.sdk.GeofenceEntity).\n Expected:\n" + tableInfo + "\n Found:\n" + tableInfo2);
                }
                HashMap<String, TableInfo.Column> hashMap2 = new HashMap<String, TableInfo.Column>(11);
                hashMap2.put("id", new TableInfo.Column("id", "INTEGER", true, 1));
                hashMap2.put("name", new TableInfo.Column("name", "TEXT", false, 0));
                hashMap2.put("latitude", new TableInfo.Column("latitude", "REAL", true, 0));
                hashMap2.put("longitude", new TableInfo.Column("longitude", "REAL", true, 0));
                hashMap2.put("dwell_millis", new TableInfo.Column("dwell_millis", "INTEGER", true, 0));
                hashMap2.put("hover_millis", new TableInfo.Column("hover_millis", "INTEGER", true, 0));
                hashMap2.put("distance", new TableInfo.Column("distance", "REAL", true, 0));
                hashMap2.put("ttl", new TableInfo.Column("ttl", "INTEGER", false, 0));
                hashMap2.put("created_at", new TableInfo.Column("created_at", "INTEGER", true, 0));
                hashMap2.put("ssid", new TableInfo.Column("ssid", "TEXT", false, 0));
                hashMap2.put("mac", new TableInfo.Column("mac", "TEXT", false, 0));
                HashSet hashSet3 = new HashSet(0);
                HashSet<TableInfo.Index> hashSet4 = new HashSet<TableInfo.Index>(1);
                hashSet4.add(new TableInfo.Index("index_wifi_inventory_ssid", false, Arrays.asList("ssid")));
                TableInfo tableInfo3 = new TableInfo("wifi_inventory", hashMap2, hashSet3, hashSet4);
                TableInfo tableInfo4 = TableInfo.read((SupportSQLiteDatabase)_db, (String)"wifi_inventory");
                if (!tableInfo3.equals((Object)tableInfo4)) {
                    throw new IllegalStateException("Migration didn't properly handle wifi_inventory(com.tamoco.sdk.WifiEntity).\n Expected:\n" + tableInfo3 + "\n Found:\n" + tableInfo4);
                }
                HashMap<String, TableInfo.Column> hashMap3 = new HashMap<String, TableInfo.Column>(15);
                hashMap3.put("id", new TableInfo.Column("id", "INTEGER", true, 1));
                hashMap3.put("name", new TableInfo.Column("name", "TEXT", false, 0));
                hashMap3.put("latitude", new TableInfo.Column("latitude", "REAL", true, 0));
                hashMap3.put("longitude", new TableInfo.Column("longitude", "REAL", true, 0));
                hashMap3.put("dwell_millis", new TableInfo.Column("dwell_millis", "INTEGER", true, 0));
                hashMap3.put("hover_millis", new TableInfo.Column("hover_millis", "INTEGER", true, 0));
                hashMap3.put("distance", new TableInfo.Column("distance", "REAL", true, 0));
                hashMap3.put("ttl", new TableInfo.Column("ttl", "INTEGER", false, 0));
                hashMap3.put("created_at", new TableInfo.Column("created_at", "INTEGER", true, 0));
                hashMap3.put("uuid", new TableInfo.Column("uuid", "TEXT", false, 0));
                hashMap3.put("namespace", new TableInfo.Column("namespace", "TEXT", false, 0));
                hashMap3.put("major", new TableInfo.Column("major", "INTEGER", false, 0));
                hashMap3.put("minor", new TableInfo.Column("minor", "INTEGER", false, 0));
                hashMap3.put("instance", new TableInfo.Column("instance", "TEXT", false, 0));
                hashMap3.put("mac", new TableInfo.Column("mac", "TEXT", false, 0));
                HashSet hashSet5 = new HashSet(0);
                HashSet<TableInfo.Index> hashSet6 = new HashSet<TableInfo.Index>(1);
                hashSet6.add(new TableInfo.Index("index_beacon_inventory_uuid", false, Arrays.asList("uuid")));
                TableInfo tableInfo5 = new TableInfo("beacon_inventory", hashMap3, hashSet5, hashSet6);
                TableInfo tableInfo6 = TableInfo.read((SupportSQLiteDatabase)_db, (String)"beacon_inventory");
                if (!tableInfo5.equals((Object)tableInfo6)) {
                    throw new IllegalStateException("Migration didn't properly handle beacon_inventory(com.tamoco.sdk.BeaconEntity).\n Expected:\n" + tableInfo5 + "\n Found:\n" + tableInfo6);
                }
                HashMap<String, TableInfo.Column> hashMap4 = new HashMap<String, TableInfo.Column>(7);
                hashMap4.put("inventory_id", new TableInfo.Column("inventory_id", "INTEGER", true, 1));
                hashMap4.put("last_event", new TableInfo.Column("last_event", "INTEGER", true, 0));
                hashMap4.put("last_event_timestamp", new TableInfo.Column("last_event_timestamp", "INTEGER", true, 0));
                hashMap4.put("proximity_status", new TableInfo.Column("proximity_status", "INTEGER", true, 0));
                hashMap4.put("proximity_timestamp", new TableInfo.Column("proximity_timestamp", "INTEGER", true, 0));
                hashMap4.put("dwell_reported", new TableInfo.Column("dwell_reported", "INTEGER", true, 0));
                hashMap4.put("hover_reported", new TableInfo.Column("hover_reported", "INTEGER", true, 0));
                HashSet hashSet7 = new HashSet(0);
                HashSet<TableInfo.Index> hashSet8 = new HashSet<TableInfo.Index>(1);
                hashSet8.add(new TableInfo.Index("index_geofences_state_last_event", false, Arrays.asList("last_event")));
                TableInfo tableInfo7 = new TableInfo("geofences_state", hashMap4, hashSet7, hashSet8);
                TableInfo tableInfo8 = TableInfo.read((SupportSQLiteDatabase)_db, (String)"geofences_state");
                if (!tableInfo7.equals((Object)tableInfo8)) {
                    throw new IllegalStateException("Migration didn't properly handle geofences_state(com.tamoco.sdk.GeofenceState).\n Expected:\n" + tableInfo7 + "\n Found:\n" + tableInfo8);
                }
                HashMap<String, TableInfo.Column> hashMap5 = new HashMap<String, TableInfo.Column>(17);
                hashMap5.put("inventory_id", new TableInfo.Column("inventory_id", "INTEGER", true, 1));
                hashMap5.put("last_event", new TableInfo.Column("last_event", "INTEGER", true, 0));
                hashMap5.put("last_event_timestamp", new TableInfo.Column("last_event_timestamp", "INTEGER", true, 0));
                hashMap5.put("connection_status", new TableInfo.Column("connection_status", "INTEGER", true, 0));
                hashMap5.put("scanned_mac", new TableInfo.Column("scanned_mac", "TEXT", false, 0));
                hashMap5.put("level", new TableInfo.Column("level", "INTEGER", false, 0));
                hashMap5.put("frequency", new TableInfo.Column("frequency", "INTEGER", false, 0));
                hashMap5.put("center_freq0", new TableInfo.Column("center_freq0", "INTEGER", false, 0));
                hashMap5.put("center_freq1", new TableInfo.Column("center_freq1", "INTEGER", false, 0));
                hashMap5.put("venue_name", new TableInfo.Column("venue_name", "TEXT", false, 0));
                hashMap5.put("operator_friendly_name", new TableInfo.Column("operator_friendly_name", "TEXT", false, 0));
                hashMap5.put("capabilities", new TableInfo.Column("capabilities", "TEXT", false, 0));
                hashMap5.put("channel_width", new TableInfo.Column("channel_width", "INTEGER", false, 0));
                hashMap5.put("proximity_status", new TableInfo.Column("proximity_status", "INTEGER", true, 0));
                hashMap5.put("proximity_timestamp", new TableInfo.Column("proximity_timestamp", "INTEGER", true, 0));
                hashMap5.put("dwell_reported", new TableInfo.Column("dwell_reported", "INTEGER", true, 0));
                hashMap5.put("hover_reported", new TableInfo.Column("hover_reported", "INTEGER", true, 0));
                HashSet hashSet9 = new HashSet(0);
                HashSet<TableInfo.Index> hashSet10 = new HashSet<TableInfo.Index>(2);
                hashSet10.add(new TableInfo.Index("index_wifis_state_last_event", false, Arrays.asList("last_event")));
                hashSet10.add(new TableInfo.Index("index_wifis_state_connection_status", false, Arrays.asList("connection_status")));
                TableInfo tableInfo9 = new TableInfo("wifis_state", hashMap5, hashSet9, hashSet10);
                TableInfo tableInfo10 = TableInfo.read((SupportSQLiteDatabase)_db, (String)"wifis_state");
                if (!tableInfo9.equals((Object)tableInfo10)) {
                    throw new IllegalStateException("Migration didn't properly handle wifis_state(com.tamoco.sdk.WifiState).\n Expected:\n" + tableInfo9 + "\n Found:\n" + tableInfo10);
                }
                HashMap<String, TableInfo.Column> hashMap6 = new HashMap<String, TableInfo.Column>(15);
                hashMap6.put("inventory_id", new TableInfo.Column("inventory_id", "INTEGER", true, 1));
                hashMap6.put("last_event", new TableInfo.Column("last_event", "INTEGER", true, 0));
                hashMap6.put("last_event_timestamp", new TableInfo.Column("last_event_timestamp", "INTEGER", true, 0));
                hashMap6.put("scanned_mac", new TableInfo.Column("scanned_mac", "TEXT", false, 0));
                hashMap6.put("proximity", new TableInfo.Column("proximity", "REAL", false, 0));
                hashMap6.put("found_in_previous_scan", new TableInfo.Column("found_in_previous_scan", "INTEGER", true, 0));
                hashMap6.put("beacon_type", new TableInfo.Column("beacon_type", "TEXT", false, 0));
                hashMap6.put("rssi", new TableInfo.Column("rssi", "INTEGER", false, 0));
                hashMap6.put("manufacturer", new TableInfo.Column("manufacturer", "INTEGER", false, 0));
                hashMap6.put("bluetooth_name", new TableInfo.Column("bluetooth_name", "TEXT", false, 0));
                hashMap6.put("tx_power", new TableInfo.Column("tx_power", "INTEGER", false, 0));
                hashMap6.put("proximity_status", new TableInfo.Column("proximity_status", "INTEGER", true, 0));
                hashMap6.put("proximity_timestamp", new TableInfo.Column("proximity_timestamp", "INTEGER", true, 0));
                hashMap6.put("dwell_reported", new TableInfo.Column("dwell_reported", "INTEGER", true, 0));
                hashMap6.put("hover_reported", new TableInfo.Column("hover_reported", "INTEGER", true, 0));
                HashSet hashSet11 = new HashSet(0);
                HashSet<TableInfo.Index> hashSet12 = new HashSet<TableInfo.Index>(1);
                hashSet12.add(new TableInfo.Index("index_beacons_state_last_event", false, Arrays.asList("last_event")));
                TableInfo tableInfo11 = new TableInfo("beacons_state", hashMap6, hashSet11, hashSet12);
                TableInfo tableInfo12 = TableInfo.read((SupportSQLiteDatabase)_db, (String)"beacons_state");
                if (!tableInfo11.equals((Object)tableInfo12)) {
                    throw new IllegalStateException("Migration didn't properly handle beacons_state(com.tamoco.sdk.BeaconState).\n Expected:\n" + tableInfo11 + "\n Found:\n" + tableInfo12);
                }
                HashMap<String, TableInfo.Column> hashMap7 = new HashMap<String, TableInfo.Column>(82);
                hashMap7.put("event_id", new TableInfo.Column("event_id", "TEXT", true, 1));
                hashMap7.put("sdk_timestamp", new TableInfo.Column("sdk_timestamp", "INTEGER", false, 0));
                hashMap7.put("custom_id", new TableInfo.Column("custom_id", "TEXT", false, 0));
                hashMap7.put("expiration", new TableInfo.Column("expiration", "INTEGER", true, 0));
                hashMap7.put("device_device_id", new TableInfo.Column("device_device_id", "TEXT", false, 0));
                hashMap7.put("device_lmt", new TableInfo.Column("device_lmt", "INTEGER", false, 0));
                hashMap7.put("device_device_type", new TableInfo.Column("device_device_type", "INTEGER", false, 0));
                hashMap7.put("device_make", new TableInfo.Column("device_make", "TEXT", false, 0));
                hashMap7.put("device_model", new TableInfo.Column("device_model", "TEXT", false, 0));
                hashMap7.put("device_screen_width", new TableInfo.Column("device_screen_width", "INTEGER", false, 0));
                hashMap7.put("device_screen_height", new TableInfo.Column("device_screen_height", "INTEGER", false, 0));
                hashMap7.put("device_sd_card_mounted", new TableInfo.Column("device_sd_card_mounted", "INTEGER", false, 0));
                hashMap7.put("device_locale", new TableInfo.Column("device_locale", "TEXT", false, 0));
                hashMap7.put("device_os", new TableInfo.Column("device_os", "TEXT", false, 0));
                hashMap7.put("device_os_version", new TableInfo.Column("device_os_version", "TEXT", false, 0));
                hashMap7.put("device_timezone", new TableInfo.Column("device_timezone", "TEXT", false, 0));
                hashMap7.put("device_location", new TableInfo.Column("device_location", "INTEGER", false, 0));
                hashMap7.put("device_ip", new TableInfo.Column("device_ip", "TEXT", false, 0));
                hashMap7.put("device_bluetooth", new TableInfo.Column("device_bluetooth", "INTEGER", false, 0));
                hashMap7.put("device_wifi", new TableInfo.Column("device_wifi", "INTEGER", false, 0));
                hashMap7.put("device_nfc", new TableInfo.Column("device_nfc", "INTEGER", false, 0));
                hashMap7.put("device_pressure", new TableInfo.Column("device_pressure", "REAL", false, 0));
                hashMap7.put("device_battery_level", new TableInfo.Column("device_battery_level", "INTEGER", false, 0));
                hashMap7.put("device_battery_health", new TableInfo.Column("device_battery_health", "INTEGER", false, 0));
                hashMap7.put("device_battery_saver", new TableInfo.Column("device_battery_saver", "INTEGER", false, 0));
                hashMap7.put("device_battery_temperature", new TableInfo.Column("device_battery_temperature", "INTEGER", false, 0));
                hashMap7.put("device_battery_technology", new TableInfo.Column("device_battery_technology", "TEXT", false, 0));
                hashMap7.put("device_battery_voltage", new TableInfo.Column("device_battery_voltage", "INTEGER", false, 0));
                hashMap7.put("device_charging_on", new TableInfo.Column("device_charging_on", "INTEGER", false, 0));
                hashMap7.put("device_charging_source", new TableInfo.Column("device_charging_source", "INTEGER", false, 0));
                hashMap7.put("device_carrier_network_operator_name", new TableInfo.Column("device_carrier_network_operator_name", "TEXT", false, 0));
                hashMap7.put("device_carrier_network_operator", new TableInfo.Column("device_carrier_network_operator", "TEXT", false, 0));
                hashMap7.put("device_carrier_network_country_iso", new TableInfo.Column("device_carrier_network_country_iso", "TEXT", false, 0));
                hashMap7.put("device_carrier_network_specifier", new TableInfo.Column("device_carrier_network_specifier", "TEXT", false, 0));
                hashMap7.put("device_carrier_sim_country_iso", new TableInfo.Column("device_carrier_sim_country_iso", "TEXT", false, 0));
                hashMap7.put("device_carrier_sim_operator_name", new TableInfo.Column("device_carrier_sim_operator_name", "TEXT", false, 0));
                hashMap7.put("device_carrier_network_roaming", new TableInfo.Column("device_carrier_network_roaming", "INTEGER", false, 0));
                hashMap7.put("device_carrier_data_activity", new TableInfo.Column("device_carrier_data_activity", "INTEGER", false, 0));
                hashMap7.put("app_app_id", new TableInfo.Column("app_app_id", "TEXT", false, 0));
                hashMap7.put("app_bundle_id", new TableInfo.Column("app_bundle_id", "TEXT", false, 0));
                hashMap7.put("app_app_name", new TableInfo.Column("app_app_name", "TEXT", false, 0));
                hashMap7.put("app_normalized_app_name", new TableInfo.Column("app_normalized_app_name", "TEXT", false, 0));
                hashMap7.put("app_app_version", new TableInfo.Column("app_app_version", "TEXT", false, 0));
                hashMap7.put("app_sdk_version", new TableInfo.Column("app_sdk_version", "TEXT", false, 0));
                hashMap7.put("app_foreground", new TableInfo.Column("app_foreground", "INTEGER", false, 0));
                hashMap7.put("geo_provider", new TableInfo.Column("geo_provider", "TEXT", false, 0));
                hashMap7.put("geo_latitude", new TableInfo.Column("geo_latitude", "REAL", false, 0));
                hashMap7.put("geo_longitude", new TableInfo.Column("geo_longitude", "REAL", false, 0));
                hashMap7.put("geo_accuracy", new TableInfo.Column("geo_accuracy", "REAL", false, 0));
                hashMap7.put("geo_bearing", new TableInfo.Column("geo_bearing", "REAL", false, 0));
                hashMap7.put("geo_pressure", new TableInfo.Column("geo_pressure", "REAL", false, 0));
                hashMap7.put("geo_altitudevalue", new TableInfo.Column("geo_altitudevalue", "REAL", false, 0));
                hashMap7.put("geo_altitudeaccuracy", new TableInfo.Column("geo_altitudeaccuracy", "REAL", false, 0));
                hashMap7.put("geo_speedvalue", new TableInfo.Column("geo_speedvalue", "REAL", false, 0));
                hashMap7.put("geo_speedaccuracy", new TableInfo.Column("geo_speedaccuracy", "REAL", false, 0));
                hashMap7.put("geo_motion_type", new TableInfo.Column("geo_motion_type", "INTEGER", false, 0));
                hashMap7.put("geo_motion_confidence", new TableInfo.Column("geo_motion_confidence", "INTEGER", false, 0));
                hashMap7.put("trigger_trigger_type", new TableInfo.Column("trigger_trigger_type", "INTEGER", false, 0));
                hashMap7.put("trigger_inventory_id", new TableInfo.Column("trigger_inventory_id", "INTEGER", false, 0));
                hashMap7.put("trigger_beacon_id", new TableInfo.Column("trigger_beacon_id", "TEXT", false, 0));
                hashMap7.put("trigger_major", new TableInfo.Column("trigger_major", "INTEGER", false, 0));
                hashMap7.put("trigger_minor", new TableInfo.Column("trigger_minor", "INTEGER", false, 0));
                hashMap7.put("trigger_namespace", new TableInfo.Column("trigger_namespace", "TEXT", false, 0));
                hashMap7.put("trigger_instance", new TableInfo.Column("trigger_instance", "TEXT", false, 0));
                hashMap7.put("trigger_rssi", new TableInfo.Column("trigger_rssi", "INTEGER", false, 0));
                hashMap7.put("trigger_bluetooth_name", new TableInfo.Column("trigger_bluetooth_name", "TEXT", false, 0));
                hashMap7.put("trigger_manufactuer", new TableInfo.Column("trigger_manufactuer", "INTEGER", false, 0));
                hashMap7.put("trigger_tx_power", new TableInfo.Column("trigger_tx_power", "INTEGER", false, 0));
                hashMap7.put("trigger_ssid", new TableInfo.Column("trigger_ssid", "TEXT", false, 0));
                hashMap7.put("trigger_capabilities", new TableInfo.Column("trigger_capabilities", "TEXT", false, 0));
                hashMap7.put("trigger_mac", new TableInfo.Column("trigger_mac", "TEXT", false, 0));
                hashMap7.put("trigger_frequency", new TableInfo.Column("trigger_frequency", "INTEGER", false, 0));
                hashMap7.put("trigger_center_freq_0", new TableInfo.Column("trigger_center_freq_0", "INTEGER", false, 0));
                hashMap7.put("trigger_center_freq_1", new TableInfo.Column("trigger_center_freq_1", "INTEGER", false, 0));
                hashMap7.put("trigger_venue_name", new TableInfo.Column("trigger_venue_name", "TEXT", false, 0));
                hashMap7.put("trigger_operator_name", new TableInfo.Column("trigger_operator_name", "TEXT", false, 0));
                hashMap7.put("trigger_channel_width", new TableInfo.Column("trigger_channel_width", "INTEGER", false, 0));
                hashMap7.put("trigger_trigger_code", new TableInfo.Column("trigger_trigger_code", "TEXT", false, 0));
                hashMap7.put("trigger_trigger_variant", new TableInfo.Column("trigger_trigger_variant", "TEXT", false, 0));
                hashMap7.put("trigger_tag_id", new TableInfo.Column("trigger_tag_id", "TEXT", false, 0));
                hashMap7.put("trigger_tac", new TableInfo.Column("trigger_tac", "TEXT", false, 0));
                hashMap7.put("trigger_proximity", new TableInfo.Column("trigger_proximity", "REAL", false, 0));
                HashSet hashSet13 = new HashSet(0);
                HashSet hashSet14 = new HashSet(0);
                TableInfo tableInfo13 = new TableInfo("batched_hits", hashMap7, hashSet13, hashSet14);
                TableInfo tableInfo14 = TableInfo.read((SupportSQLiteDatabase)_db, (String)"batched_hits");
                if (!tableInfo13.equals((Object)tableInfo14)) {
                    throw new IllegalStateException("Migration didn't properly handle batched_hits(com.tamoco.sdk.TrackBody).\n Expected:\n" + tableInfo13 + "\n Found:\n" + tableInfo14);
                }
                HashMap<String, TableInfo.Column> hashMap8 = new HashMap<String, TableInfo.Column>(39);
                hashMap8.put("id", new TableInfo.Column("id", "INTEGER", false, 1));
                hashMap8.put("sdk_timestamp", new TableInfo.Column("sdk_timestamp", "INTEGER", true, 0));
                hashMap8.put("trigger_trigger_type", new TableInfo.Column("trigger_trigger_type", "INTEGER", false, 0));
                hashMap8.put("trigger_inventory_id", new TableInfo.Column("trigger_inventory_id", "INTEGER", false, 0));
                hashMap8.put("trigger_beacon_id", new TableInfo.Column("trigger_beacon_id", "TEXT", false, 0));
                hashMap8.put("trigger_major", new TableInfo.Column("trigger_major", "INTEGER", false, 0));
                hashMap8.put("trigger_minor", new TableInfo.Column("trigger_minor", "INTEGER", false, 0));
                hashMap8.put("trigger_namespace", new TableInfo.Column("trigger_namespace", "TEXT", false, 0));
                hashMap8.put("trigger_instance", new TableInfo.Column("trigger_instance", "TEXT", false, 0));
                hashMap8.put("trigger_rssi", new TableInfo.Column("trigger_rssi", "INTEGER", false, 0));
                hashMap8.put("trigger_bluetooth_name", new TableInfo.Column("trigger_bluetooth_name", "TEXT", false, 0));
                hashMap8.put("trigger_manufactuer", new TableInfo.Column("trigger_manufactuer", "INTEGER", false, 0));
                hashMap8.put("trigger_tx_power", new TableInfo.Column("trigger_tx_power", "INTEGER", false, 0));
                hashMap8.put("trigger_ssid", new TableInfo.Column("trigger_ssid", "TEXT", false, 0));
                hashMap8.put("trigger_capabilities", new TableInfo.Column("trigger_capabilities", "TEXT", false, 0));
                hashMap8.put("trigger_mac", new TableInfo.Column("trigger_mac", "TEXT", false, 0));
                hashMap8.put("trigger_frequency", new TableInfo.Column("trigger_frequency", "INTEGER", false, 0));
                hashMap8.put("trigger_center_freq_0", new TableInfo.Column("trigger_center_freq_0", "INTEGER", false, 0));
                hashMap8.put("trigger_center_freq_1", new TableInfo.Column("trigger_center_freq_1", "INTEGER", false, 0));
                hashMap8.put("trigger_venue_name", new TableInfo.Column("trigger_venue_name", "TEXT", false, 0));
                hashMap8.put("trigger_operator_name", new TableInfo.Column("trigger_operator_name", "TEXT", false, 0));
                hashMap8.put("trigger_channel_width", new TableInfo.Column("trigger_channel_width", "INTEGER", false, 0));
                hashMap8.put("trigger_trigger_code", new TableInfo.Column("trigger_trigger_code", "TEXT", false, 0));
                hashMap8.put("trigger_trigger_variant", new TableInfo.Column("trigger_trigger_variant", "TEXT", false, 0));
                hashMap8.put("trigger_tag_id", new TableInfo.Column("trigger_tag_id", "TEXT", false, 0));
                hashMap8.put("trigger_tac", new TableInfo.Column("trigger_tac", "TEXT", false, 0));
                hashMap8.put("trigger_proximity", new TableInfo.Column("trigger_proximity", "REAL", false, 0));
                hashMap8.put("geo_provider", new TableInfo.Column("geo_provider", "TEXT", false, 0));
                hashMap8.put("geo_latitude", new TableInfo.Column("geo_latitude", "REAL", false, 0));
                hashMap8.put("geo_longitude", new TableInfo.Column("geo_longitude", "REAL", false, 0));
                hashMap8.put("geo_accuracy", new TableInfo.Column("geo_accuracy", "REAL", false, 0));
                hashMap8.put("geo_bearing", new TableInfo.Column("geo_bearing", "REAL", false, 0));
                hashMap8.put("geo_pressure", new TableInfo.Column("geo_pressure", "REAL", false, 0));
                hashMap8.put("geo_altitudevalue", new TableInfo.Column("geo_altitudevalue", "REAL", false, 0));
                hashMap8.put("geo_altitudeaccuracy", new TableInfo.Column("geo_altitudeaccuracy", "REAL", false, 0));
                hashMap8.put("geo_speedvalue", new TableInfo.Column("geo_speedvalue", "REAL", false, 0));
                hashMap8.put("geo_speedaccuracy", new TableInfo.Column("geo_speedaccuracy", "REAL", false, 0));
                hashMap8.put("geo_motion_type", new TableInfo.Column("geo_motion_type", "INTEGER", false, 0));
                hashMap8.put("geo_motion_confidence", new TableInfo.Column("geo_motion_confidence", "INTEGER", false, 0));
                HashSet hashSet15 = new HashSet(0);
                HashSet hashSet16 = new HashSet(0);
                TableInfo tableInfo15 = new TableInfo("around_me_triggers", hashMap8, hashSet15, hashSet16);
                TableInfo tableInfo16 = TableInfo.read((SupportSQLiteDatabase)_db, (String)"around_me_triggers");
                if (!tableInfo15.equals((Object)tableInfo16)) {
                    throw new IllegalStateException("Migration didn't properly handle around_me_triggers(com.tamoco.sdk.AroundMeTrigger).\n Expected:\n" + tableInfo15 + "\n Found:\n" + tableInfo16);
                }
                HashMap<String, TableInfo.Column> hashMap9 = new HashMap<String, TableInfo.Column>(11);
                hashMap9.put("id", new TableInfo.Column("id", "INTEGER", true, 1));
                hashMap9.put("latitude", new TableInfo.Column("latitude", "REAL", true, 0));
                hashMap9.put("longitude", new TableInfo.Column("longitude", "REAL", true, 0));
                hashMap9.put("accuracy", new TableInfo.Column("accuracy", "REAL", false, 0));
                hashMap9.put("bearing", new TableInfo.Column("bearing", "REAL", true, 0));
                hashMap9.put("altitude", new TableInfo.Column("altitude", "REAL", true, 0));
                hashMap9.put("altitude_accuracy", new TableInfo.Column("altitude_accuracy", "REAL", false, 0));
                hashMap9.put("speed", new TableInfo.Column("speed", "REAL", false, 0));
                hashMap9.put("speed_accuracy", new TableInfo.Column("speed_accuracy", "REAL", false, 0));
                hashMap9.put("sdk_timestamp", new TableInfo.Column("sdk_timestamp", "INTEGER", true, 0));
                hashMap9.put("provider", new TableInfo.Column("provider", "TEXT", false, 0));
                HashSet hashSet17 = new HashSet(0);
                HashSet hashSet18 = new HashSet(0);
                TableInfo tableInfo17 = new TableInfo("batched_locations", hashMap9, hashSet17, hashSet18);
                TableInfo tableInfo18 = TableInfo.read((SupportSQLiteDatabase)_db, (String)"batched_locations");
                if (!tableInfo17.equals((Object)tableInfo18)) {
                    throw new IllegalStateException("Migration didn't properly handle batched_locations(com.tamoco.sdk.BatchedLocation).\n Expected:\n" + tableInfo17 + "\n Found:\n" + tableInfo18);
                }
            }
        }, "a0f9fd9ca6a8d527adbdfa3c7965be14", "1ed4cdeb507b4291a34aa7d9c15b8199");
        SupportSQLiteOpenHelper.Configuration configuration2 = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)roomOpenHelper).build();
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = configuration.sqliteOpenHelperFactory.create(configuration2);
        return supportSQLiteOpenHelper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        return new InvalidationTracker((RoomDatabase)this, new String[]{"geofence_inventory", "wifi_inventory", "beacon_inventory", "geofences_state", "wifis_state", "beacons_state", "batched_hits", "around_me_triggers", "batched_locations"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase supportSQLiteDatabase = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            supportSQLiteDatabase.execSQL("DELETE FROM `geofence_inventory`");
            supportSQLiteDatabase.execSQL("DELETE FROM `wifi_inventory`");
            supportSQLiteDatabase.execSQL("DELETE FROM `beacon_inventory`");
            supportSQLiteDatabase.execSQL("DELETE FROM `geofences_state`");
            supportSQLiteDatabase.execSQL("DELETE FROM `wifis_state`");
            supportSQLiteDatabase.execSQL("DELETE FROM `beacons_state`");
            supportSQLiteDatabase.execSQL("DELETE FROM `batched_hits`");
            supportSQLiteDatabase.execSQL("DELETE FROM `around_me_triggers`");
            supportSQLiteDatabase.execSQL("DELETE FROM `batched_locations`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            supportSQLiteDatabase.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!supportSQLiteDatabase.inTransaction()) {
                supportSQLiteDatabase.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeofenceDao geofenceDao() {
        if (this.a != null) {
            return this.a;
        }
        LocalDatabase_Impl localDatabase_Impl = this;
        synchronized (localDatabase_Impl) {
            if (this.a == null) {
                this.a = new GeofenceDao_Impl(this);
            }
            return this.a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WifiDao wifiDao() {
        if (this.b != null) {
            return this.b;
        }
        LocalDatabase_Impl localDatabase_Impl = this;
        synchronized (localDatabase_Impl) {
            if (this.b == null) {
                this.b = new WifiDao_Impl(this);
            }
            return this.b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeaconDao beaconDao() {
        if (this.c != null) {
            return this.c;
        }
        LocalDatabase_Impl localDatabase_Impl = this;
        synchronized (localDatabase_Impl) {
            if (this.c == null) {
                this.c = new BeaconDao_Impl(this);
            }
            return this.c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HitDao hitDao() {
        if (this.d != null) {
            return this.d;
        }
        LocalDatabase_Impl localDatabase_Impl = this;
        synchronized (localDatabase_Impl) {
            if (this.d == null) {
                this.d = new HitDao_Impl(this);
            }
            return this.d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public e aroundMeTriggerDao() {
        if (this.e != null) {
            return this.e;
        }
        LocalDatabase_Impl localDatabase_Impl = this;
        synchronized (localDatabase_Impl) {
            if (this.e == null) {
                this.e = new AroundMeDao_Impl(this);
            }
            return this.e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public g batchedLocationDao() {
        if (this.f != null) {
            return this.f;
        }
        LocalDatabase_Impl localDatabase_Impl = this;
        synchronized (localDatabase_Impl) {
            if (this.f == null) {
                this.f = new BatchedLocationDao_Impl(this);
            }
            return this.f;
        }
    }
}

