/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.content.Context;
import android.location.Location;
import android.net.wifi.ScanResult;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.tamoco.sdk.BeaconState;
import com.tamoco.sdk.GeofenceState;
import com.tamoco.sdk.StoredBeacon;
import com.tamoco.sdk.StoredGeofence;
import com.tamoco.sdk.StoredWifi;
import com.tamoco.sdk.WifiState;
import java.util.List;

@WorkerThread
public interface InventoryRepository {
    public boolean updateInventory(@NonNull Context var1, @NonNull Location var2);

    public boolean updateRemoteSettings(@NonNull Context var1);

    public boolean flushTriggersAroundMe(@NonNull Context var1);

    public void reportAroundMeBleBeacon(@NonNull Context var1, String var2, Integer var3, Integer var4, String var5, Integer var6, Integer var7, String var8, Integer var9);

    public void reportAroundMeEddystone(@NonNull Context var1, String var2, String var3, String var4, Integer var5, Integer var6, String var7, Integer var8);

    public void reportWifiAroundMe(@NonNull Context var1, ScanResult var2);

    public List<StoredGeofence> getGeofences();

    public StoredGeofence getGeofence(long var1);

    public void updateGeofenceState(GeofenceState var1);

    public List<StoredWifi> getWifiNetworks();

    public StoredWifi getWifi(long var1);

    public List<StoredWifi> getWifiBySSid(String var1);

    public List<StoredWifi> getWifiByStatus(int var1);

    public void updateWifiState(WifiState var1);

    public List<StoredWifi> getWifisNotScanned(Integer var1, List<String> var2);

    public List<StoredBeacon> getBeacons();

    public StoredBeacon getBeacon(long var1);

    public StoredBeacon getAltBeacon(String var1, Integer var2, Integer var3);

    public StoredBeacon getEddystone(String var1, String var2);

    public List<StoredBeacon> getBeaconsNotFoundByStatus(int var1);

    public void resetBeaconsFound();

    public StoredBeacon getBeaconByMac(String var1);

    public void updateBeaconState(BeaconState var1);
}

