/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Embedded;
import android.location.Location;
import android.os.Build;
import com.squareup.moshi.Json;
import com.tamoco.sdk.GeoDataValue;
import com.tamoco.sdk.l;

class GeoData {
    @Json(name="provider")
    @ColumnInfo(name="provider")
    String provider;
    @Json(name="latitude")
    @ColumnInfo(name="latitude")
    double latitude;
    @Json(name="longitude")
    @ColumnInfo(name="longitude")
    double longitude;
    @Json(name="accuracy")
    @ColumnInfo(name="accuracy")
    Float accuracy;
    @Json(name="bearing")
    Float bearing;
    @Json(name="altitude")
    @Embedded(prefix="altitude")
    GeoDataValue altitude;
    @Json(name="speed")
    @Embedded(prefix="speed")
    GeoDataValue speed;
    @Json(name="pressure")
    @ColumnInfo(name="pressure")
    Float pressure;
    @Json(name="motion")
    @Embedded(prefix="motion_")
    l motion;

    public GeoData() {
    }

    GeoData(Location location, Float pressure, l geoMotion) {
        this.pressure = pressure;
        if (location != null) {
            this.provider = location.getProvider();
            this.latitude = location.getLatitude();
            this.longitude = location.getLongitude();
            if (location.hasAccuracy()) {
                this.accuracy = Float.valueOf(location.getAccuracy());
            }
            if (location.hasBearing()) {
                this.bearing = Float.valueOf(location.getBearing());
            }
            if (location.hasAltitude()) {
                this.altitude = new GeoDataValue(location.getAltitude(), Build.VERSION.SDK_INT >= 26 ? Float.valueOf(location.getVerticalAccuracyMeters()) : null);
            }
            if (location.hasSpeed()) {
                this.speed = new GeoDataValue(location.getSpeed(), Build.VERSION.SDK_INT >= 26 ? Float.valueOf(location.getSpeedAccuracyMetersPerSecond()) : null);
            }
        }
        this.motion = geoMotion;
    }
}

