/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Embedded;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.content.Context;
import android.location.Location;
import android.support.annotation.NonNull;
import com.squareup.moshi.Json;
import com.tamoco.sdk.AppData;
import com.tamoco.sdk.DeviceData;
import com.tamoco.sdk.GeoData;
import com.tamoco.sdk.Tamoco;
import com.tamoco.sdk.l;
import java.util.UUID;

class ApiRequestBody {
    @Json(name="event_id")
    @PrimaryKey
    @NonNull
    @ColumnInfo(name="event_id")
    protected String eventId;
    @Json(name="sdk_timestamp")
    @ColumnInfo(name="sdk_timestamp")
    protected Long sdkTimestamp;
    @Json(name="device")
    @Embedded(prefix="device_")
    protected DeviceData device;
    @Json(name="app")
    @Embedded(prefix="app_")
    protected AppData app;
    @Json(name="geo")
    @Embedded(prefix="geo_")
    protected GeoData geo;
    @Json(name="custom_id")
    @ColumnInfo(name="custom_id")
    protected String customId;

    protected ApiRequestBody() {
    }

    @Ignore
    protected ApiRequestBody(Context context, Location location, boolean foreground, l geoMotion) {
        this(context, location, null, foreground, geoMotion);
    }

    @Ignore
    protected ApiRequestBody(Context context, Location location, Float environmentPressure, boolean foreground, l geoMotion) {
        this.eventId = UUID.randomUUID().toString();
        this.sdkTimestamp = System.currentTimeMillis();
        this.device = new DeviceData(context);
        this.device.pressure = environmentPressure;
        this.app = new AppData(context, foreground);
        this.customId = Tamoco.getCustomId();
        this.geo = new GeoData(location, environmentPressure, geoMotion);
    }
}

