package com.tamoco.sdk.doc;

import com.tamoco.sdk.Trigger;

/*
 * *******************************************************
 * Copyright (C) 2013-2018 Tamoco Limited
 * This file is part of the Tamoco SDKs.
 *
 * Tamocos SDKs can not be copied and/or distributed without the express
 * permission of Tamoco Limited.
 *
 * https://www.tamoco.com/terms-and-conditions/
 * *******************************************************
 */


/**
 * Representation of an inventory item monitored by the Tamoco SDK.
 */
public interface ITrigger {
    /**
     * Gets the inventory id of the trigger.
     *
     * @return the id.
     */
    long getId();

    /**
     * Gets the name of the trigger.
     *
     * @return the name.
     */
    String getName();

    /**
     * Gets the latitude (geolocation) of where the trigger is.
     *
     * @return the latitude.
     */
    double getLatitude();

    /**
     * Gets the longitude (geolocation) of where the trigger is.
     *
     * @return the longitude.
     */
    double getLongitude();

    /**
     * Gets the last event that occurred to this trigger. (see {@link com.tamoco.sdk.Trigger.EventType})
     *
     * @return the last event.
     */
    @Trigger.EventType
    int getLastEvent();

    /**
     * Gets the current status of the trigger.
     *
     * @return the status.
     */
    int getStatus();
}
