/*
 * Decompiled with CFR 0.152.
 */
package com.talent.compat.web.core.compat;

import android.content.Context;
import android.os.Build;
import android.view.accessibility.AccessibilityManager;
import android.webkit.WebView;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;

public class AccessibilityCompat {
    private final WebView mWebView;
    private Context mContext;
    private Boolean mIsAccessibilityEnabledOriginal;

    public AccessibilityCompat(WebView mWebView) {
        this.mWebView = mWebView;
        this.mContext = mWebView.getContext();
    }

    public void fixedAccessibilityInjectorExceptionForOnPageFinished(String url) {
        if (Build.VERSION.SDK_INT == 16 && this.mWebView.getSettings().getJavaScriptEnabled() && this.mIsAccessibilityEnabledOriginal == null && this.isAccessibilityEnabled()) {
            try {
                try {
                    URLEncoder.encode(String.valueOf(new URI(url)), "utf-8");
                }
                catch (IllegalArgumentException e) {
                    if ("bad parameter".equals(e.getMessage())) {
                        this.mIsAccessibilityEnabledOriginal = true;
                        this.setAccessibilityEnabled(false);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isAccessibilityEnabled() {
        AccessibilityManager am = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        return am != null && am.isEnabled();
    }

    private void setAccessibilityEnabled(boolean enabled) {
        AccessibilityManager am = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        if (am == null) {
            return;
        }
        try {
            Method setAccessibilityState = am.getClass().getDeclaredMethod("setAccessibilityState", Boolean.TYPE);
            setAccessibilityState.setAccessible(true);
            setAccessibilityState.invoke((Object)am, enabled);
            setAccessibilityState.setAccessible(false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void resetAccessibilityEnabled() {
        if (this.mIsAccessibilityEnabledOriginal != null) {
            this.setAccessibilityEnabled(this.mIsAccessibilityEnabledOriginal);
        }
    }
}

