package com.talent.compat.web.core.useage;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.FrameLayout;

import com.talent.compat.web.core.callback.WebClient;

/**
 * Created by wbs on 2018/3/21 0021.
 */

public class WebViewContainer extends FrameLayout implements WebClient {

    private final static String DEFAULT_ERROR_PAGE = "file:///android_asset/error.html";

    private final EasyWebView mWebView;

    private TitleGetter mTitleGetter;

    private WebIndicator mWebIndicator;

    private View mErrorView;

    private boolean mErrorHappened = false;

    private String mLastUrl;

    public WebViewContainer(@NonNull Context context) {
        this(context, null, 0);
    }

    public WebViewContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WebViewContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mWebView = new EasyWebView(context);
        mWebView.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        mWebView.asDefault();
        mWebView.registerWebClient(this);
        mWebView.prepare();
        addView(mWebView);
        mWebIndicator = new ThemeWebIndicator(context);
        mWebIndicator.reset();
        addView((View) mWebIndicator);
    }


    public EasyWebView getWebView() {
        return mWebView;
    }

    public WebSettings getSettings() {
        return mWebView.as();
    }

    public void atTitleGotten(TitleGetter titleGetter) {
        this.mTitleGetter = titleGetter;
    }

    public void setErrorPage(@LayoutRes int layout, @IdRes int actionId) {
        View view = LayoutInflater.from(getContext()).inflate(layout, this, false);
        if (view != null) {
            View actionView = view.findViewById(actionId);
            if (actionView != null) {
                actionView.setOnClickListener(new OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        mWebView.reload();
                    }
                });
            }
            view.setVisibility(GONE);
            addView(view);
            mErrorView = view;
        }
    }

    @Deprecated
    public void setWebIndicator(WebIndicator indicator) {
        if (indicator == null) {
            return;
        }
        if (!(indicator instanceof View)) {
            return;
        }
        View view = (View) indicator;
        int index = indexOfChild((View) mWebIndicator);
        removeViewAt(index);
        addView(view, index);
        mWebIndicator = indicator;
    }

    public void setIndicatorColor(int color){
        if(mWebIndicator!=null){
            if(mWebIndicator instanceof ThemeWebIndicator){
                ((ThemeWebIndicator) mWebIndicator).setColor(color);
            }
        }
    }


    @Override
    public void onReceivedTitle(WebView view, String title) {

        if (mTitleGetter != null) {
            mTitleGetter.onGetTitle(view, title);
        }
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if(!DEFAULT_ERROR_PAGE.equals(url)){
            mLastUrl = url;
        }
        mErrorHappened = false;
        if (mWebIndicator != null) {
            mWebIndicator.show();
        }
    }

    @Override
    public void onProgressChanged(WebView view, int newProgress) {
        if (mWebIndicator != null) {
            mWebIndicator.setProgress(newProgress);
        }
    }

    @Override
    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        mErrorHappened = true;
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        if (mWebIndicator != null) {
            mWebIndicator.setProgress(100);
            mWebIndicator.hide();
        }
        if (mErrorHappened) {
            loadErrorPage();
        } else {
            mWebView.setVisibility(VISIBLE);
            if (mErrorView != null) {
                mErrorView.setVisibility(GONE);
            }
        }
    }

    public void load(String url){
        if(mWebView!=null){
            mWebView.loadUrl(url);
        }
    }

    public void loadErrorPage(){
        if (mErrorView != null) {
            mErrorView.setVisibility(VISIBLE);
            mWebView.setVisibility(GONE);
        } else {
            mWebView.setVisibility(VISIBLE);
            mWebView.loadUrl(DEFAULT_ERROR_PAGE);
        }
    }

    public boolean goBack(){
        if(mWebView==null){
            return false;
        }
        if(indexOfChild(mWebView)<0){
            return false;
        }
        if(mWebView.canGoBack()){
            if(DEFAULT_ERROR_PAGE.equals(mWebView.getUrl())){
                mWebView.goBackOrForward(-2);
                return true;
            }
            mWebView.goBack();
            return true;
        }
        return false;
    }


    public String getUrl(){
        if(mWebView==null){
            return null;
        }
        String url = mWebView.getUrl();
        if(DEFAULT_ERROR_PAGE.equals(url)){
            return mLastUrl;
        }
        return url;
    }


    public interface TitleGetter {

        void onGetTitle(WebView webView, String title);
    }
}
