package com.talent.compat.web.core.useage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;

import com.talent.compat.web.core.CompatWebView;
import com.talent.compat.web.core.DefaultWebLifeCycleImpl;
import com.talent.compat.web.core.WebLifeCycle;

import java.io.File;

/**
 * Created by wbs on 2018/3/20 0020.
 */

public class EasyWebView extends CompatWebView {

    public static final int OPEN_PAGE_AS_DIRECT = 0;

    public static final int OPEN_PAGE_AS_ASKING = 1;

    public static final int OPEN_PAGE_DISALLOWED = 2;

    private boolean mHasSettleDownloadListener = false;

    private final WebLifeCycle mLifecycle = new DefaultWebLifeCycleImpl(this);

    public EasyWebView(Context context) {
        super(context);
    }

    public EasyWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public EasyWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

    }

    public WebLifeCycle getLife(){
        return mLifecycle;
    }

    public WebSettings as(){
        return getSettings();
    }

    @SuppressLint("SetJavaScriptEnabled")
    public EasyWebView asDefault(){
        WebSettings settings = getSettings();
        //硬件加速
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            //适配5.0不允许http和https混合使用情况
            settings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
            setLayerType(View.LAYER_TYPE_HARDWARE, null);
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            setLayerType(View.LAYER_TYPE_HARDWARE, null);
        } else if (Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {
            setLayerType(View.LAYER_TYPE_SOFTWARE, null);
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {//设置底层布局算法
            settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        } else {
            settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }
        //文件
        settings.setAllowFileAccess(true); // 允许加载本地文件html  file协议
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            settings.setAllowFileAccessFromFileURLs(false);// 通过 file url 加载的 Javascript 读取其他的本地文件 .建议关闭
            settings.setAllowUniversalAccessFromFileURLs(false); // 允许通过 file url 加载的 Javascript 可以访问其他的源，包括其他的文件和 http，https 等其他的源
        }
        //设置自适应屏幕，两者合用
        settings.setUseWideViewPort(false); //将图片调整到适合webview的大小
        settings.setLoadWithOverviewMode(false); // 缩放至屏幕的大小
        //缩放操作
        settings.setSupportZoom(true); //支持缩放，默认为true。是下面那个的前提。
        settings.setBuiltInZoomControls(true); //设置内置的缩放控件。若为false，则该WebView不可缩放
        settings.setDisplayZoomControls(false); //隐藏原生的缩放控件

        //开启缓存
        if(checkNetwork(getContext())){
            settings.setCacheMode(WebSettings.LOAD_DEFAULT);//根据cache-control获取数据。
        }else {
            //没网，则从本地获取，即离线加载
            settings.setCacheMode(WebSettings.LOAD_CACHE_ELSE_NETWORK);
        }
        settings.setDomStorageEnabled(true); // 开启 DOM storage API 功能
        settings.setDatabaseEnabled(true);   //开启 database storage API 功能
        settings.setAppCacheEnabled(true);//开启 Application Caches 功能
        String dirPath = getContext().getCacheDir().getAbsolutePath() + File.separator+"web-cache";
        settings.setGeolocationDatabasePath(dirPath);
        settings.setDatabasePath(dirPath);
        settings.setAppCachePath(dirPath);
        settings.setAppCacheMaxSize(Long.MAX_VALUE);

        //功能启用
        settings.setLoadsImagesAutomatically(true);//设置图片自动加载
        settings.setSupportMultipleWindows(false);//支持多窗口
        settings.setBlockNetworkImage(false);// 是否阻塞加载网络图片  协议http or https
        settings.setSavePassword(false);//保存密码
        settings.setGeolocationEnabled(true);//定位
        //配置设置
        settings.setNeedInitialFocus(true);
        settings.setDefaultTextEncodingName("utf-8");//设置编码格式
        settings.setDefaultFontSize(16);
        settings.setMinimumFontSize(12);//设置 WebView 支持的最小字体大小，默认为 8
        settings.setTextZoom(100);
        //JavScript启用
        settings.setJavaScriptEnabled(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true); //支持通过JS打开新窗口
        return this;

    }

    protected static boolean checkNetwork(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        if (connectivity == null) {
            return false;
        }
        @SuppressLint("MissingPermission") NetworkInfo info = connectivity.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    @Override
    public void destroy() {
        clearWebView(this);
        super.destroy();
    }

    @Override
    public final void setDownloadListener(DownloadListener listener) {
        mHasSettleDownloadListener = true;
        super.setDownloadListener(listener);
    }

    private static void clearWebView(WebView web) {
        if (web == null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return;
        }
        web.loadUrl("about:blank");
        web.stopLoading();
        if (web.getHandler() != null) {
            web.getHandler().removeCallbacksAndMessages(null);
        }
        web.removeAllViews();
        ViewGroup mViewGroup = null;
        if ((mViewGroup = ((ViewGroup) web.getParent())) != null) {
            mViewGroup.removeView(web);
        }
        web.setTag(null);
        web.clearHistory();
    }



    @Override
    public void prepare() {
        if(!isInstallWebViewClient()){
            setWebViewClient(DefaultWebViewClient.asBuilder()
                    .autoDealLink(true)
                    .component((Activity) getContext())
                    .interceptUnknownSchema(true)
                    .linkPageOpenMode(OPEN_PAGE_AS_DIRECT)
                    .build());
        }
        if(!mHasSettleDownloadListener) {
            setDownloadListener(new DownloadListener() {
                @Override
                public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                    Intent intent = new Intent();
                    intent.setAction(Intent.ACTION_VIEW);
                    intent.setData(Uri.parse(url));
                    getContext().startActivity(intent);
                }
            });
        }
        super.prepare();

    }
}
