package com.talent.compat.web.core;

import android.graphics.Bitmap;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;

import com.talent.compat.web.core.compat.AccessibilityCompat;

/**
 * Created by wbs on 2018/3/20 0020.
 */

public class WebViewClientWrapper extends WebViewClientBase {

    private final CompatWebView mWebView;


    private final AccessibilityCompat mAccessCompat;

    public WebViewClientWrapper(CompatWebView mWebView, AccessibilityCompat mAccessCompat) {
        super(null);
        this.mWebView = mWebView;
        this.mAccessCompat = mAccessCompat;
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        mWebView.getJsInjection().injectJavaScript(view);
        mWebView.injectJavaScript();
        mWebView.onPageStarted(view, url, favicon);
        mAccessCompat.fixedAccessibilityInjectorExceptionForOnPageFinished(url);
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        mWebView.onPageFinished(view, url);
    }

    @RequiresApi(api = Build.VERSION_CODES.M)
    @Override
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        if (request.isForMainFrame()) {
            onReceivedError(view,
                    error.getErrorCode(), error.getDescription().toString(),
                    request.getUrl().toString());
        }
    }

    @Override
    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {

        super.onReceivedError(view, errorCode, description, failingUrl);
        mWebView.onReceivedError(view, errorCode, description, failingUrl);
    }
}
