/*
 * Decompiled with CFR 0.152.
 */
package com.talent.compat.web.core.useage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.talent.compat.web.core.CompatWebView;
import com.talent.compat.web.core.DefaultWebLifeCycleImpl;
import com.talent.compat.web.core.WebLifeCycle;
import com.talent.compat.web.core.useage.DefaultWebViewClient;
import java.io.File;

public class EasyWebView
extends CompatWebView {
    public static final int OPEN_PAGE_AS_DIRECT = 0;
    public static final int OPEN_PAGE_AS_ASKING = 1;
    public static final int OPEN_PAGE_DISALLOWED = 2;
    private boolean mHasSettleDownloadListener = false;
    private final WebLifeCycle mLifecycle = new DefaultWebLifeCycleImpl(this);

    public EasyWebView(Context context) {
        super(context);
    }

    public EasyWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public EasyWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public WebLifeCycle getLife() {
        return this.mLifecycle;
    }

    public WebSettings as() {
        return this.getSettings();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public EasyWebView asDefault() {
        WebSettings settings = this.getSettings();
        if (Build.VERSION.SDK_INT >= 21) {
            settings.setMixedContentMode(0);
            this.setLayerType(2, null);
        } else if (Build.VERSION.SDK_INT >= 19) {
            this.setLayerType(2, null);
        } else if (Build.VERSION.SDK_INT < 19) {
            this.setLayerType(1, null);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        } else {
            settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }
        settings.setAllowFileAccess(true);
        if (Build.VERSION.SDK_INT >= 16) {
            settings.setAllowFileAccessFromFileURLs(false);
            settings.setAllowUniversalAccessFromFileURLs(false);
        }
        settings.setUseWideViewPort(false);
        settings.setLoadWithOverviewMode(false);
        settings.setSupportZoom(true);
        settings.setBuiltInZoomControls(true);
        settings.setDisplayZoomControls(false);
        if (EasyWebView.checkNetwork(this.getContext())) {
            settings.setCacheMode(-1);
        } else {
            settings.setCacheMode(1);
        }
        settings.setDomStorageEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setAppCacheEnabled(true);
        String dirPath = this.getContext().getCacheDir().getAbsolutePath() + File.separator + "web-cache";
        settings.setGeolocationDatabasePath(dirPath);
        settings.setDatabasePath(dirPath);
        settings.setAppCachePath(dirPath);
        settings.setAppCacheMaxSize(Long.MAX_VALUE);
        settings.setLoadsImagesAutomatically(true);
        settings.setSupportMultipleWindows(false);
        settings.setBlockNetworkImage(false);
        settings.setSavePassword(false);
        settings.setGeolocationEnabled(true);
        settings.setNeedInitialFocus(true);
        settings.setDefaultTextEncodingName("utf-8");
        settings.setDefaultFontSize(16);
        settings.setMinimumFontSize(12);
        settings.setTextZoom(100);
        settings.setJavaScriptEnabled(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        return this;
    }

    protected static boolean checkNetwork(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo info = connectivity.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    @Override
    public void destroy() {
        EasyWebView.clearWebView(this);
        super.destroy();
    }

    public final void setDownloadListener(DownloadListener listener) {
        this.mHasSettleDownloadListener = true;
        super.setDownloadListener(listener);
    }

    private static void clearWebView(WebView web) {
        if (web == null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return;
        }
        web.loadUrl("about:blank");
        web.stopLoading();
        if (web.getHandler() != null) {
            web.getHandler().removeCallbacksAndMessages(null);
        }
        web.removeAllViews();
        ViewGroup mViewGroup = null;
        mViewGroup = (ViewGroup)web.getParent();
        if (mViewGroup != null) {
            mViewGroup.removeView((View)web);
        }
        web.setTag(null);
        web.clearHistory();
    }

    @Override
    public void prepare() {
        if (!this.isInstallWebViewClient()) {
            this.setWebViewClient(DefaultWebViewClient.asBuilder().autoDealLink(true).component((Activity)this.getContext()).interceptUnknownSchema(true).linkPageOpenMode(0).build());
        }
        if (!this.mHasSettleDownloadListener) {
            this.setDownloadListener(new DownloadListener(){

                public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                    Intent intent = new Intent();
                    intent.setAction("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    EasyWebView.this.getContext().startActivity(intent);
                }
            });
        }
        super.prepare();
    }
}

