/*
 * Decompiled with CFR 0.152.
 */
package com.talent.compat.web.core.js;

import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import com.talent.compat.web.core.js.JsCallback;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsCallJava {
    private static final String TAG = "JsCallJava";
    private static final String RETURN_RESULT_FORMAT = "{\"CODE\": %d, \"result\": %s}";
    private static final String MSG_PROMPT_HEADER = "CompatWebView:";
    private static final String KEY_OBJ = "obj";
    private static final String KEY_METHOD = "method";
    private static final String KEY_TYPES = "types";
    private static final String KEY_ARGS = "args";
    private static final String[] IGNORE_UNSAFE_METHODS = new String[]{"getClass", "hashCode", "notify", "notifyAll", "equals", "toString", "wait"};
    private final HashMap<String, Method> mMethodsMap = new HashMap();
    private Object mInterfaceObj;
    private String mInterfacedName;
    private String mPreloadInterfaceJs;

    private JsCallJava(Object interfaceObj, String interfaceName) {
        if (TextUtils.isEmpty((CharSequence)interfaceName)) {
            throw new IllegalArgumentException("interfaceName can not be null");
        }
        this.mInterfaceObj = interfaceObj;
        this.mInterfacedName = interfaceName;
        Method[] methods = this.mInterfaceObj.getClass().getMethods();
        StringBuilder sb = new StringBuilder("javascript:(function(b){console.log(\"");
        sb.append(this.mInterfacedName);
        sb.append(" init begin\");var a={queue:[],callback:function(){var d=Array.prototype.slice.call(arguments,0);var c=d.shift();var e=d.shift();this.queue[c].apply(this,d);if(!e){delete this.queue[c]}}};");
        for (Method method : methods) {
            Log.i((String)"Info", (String)("method:" + method));
            String sign = this.genJavaMethodSign(method);
            if (sign == null) continue;
            this.mMethodsMap.put(sign, method);
            sb.append(String.format("a.%s=", method.getName()));
        }
        sb.append("function(){var f=Array.prototype.slice.call(arguments,0);if(f.length<1){throw\"");
        sb.append(this.mInterfacedName);
        sb.append(" call result, message:miss method name\"}var e=[];for(var h=1;h<f.length;h++){var c=f[h];var j=typeof c;e[e.length]=j;if(j==\"function\"){var d=a.queue.length;a.queue[d]=c;f[h]=d}}var k = new Date().getTime();var l = f.shift();var m=prompt('");
        sb.append(MSG_PROMPT_HEADER);
        sb.append("'+JSON.stringify(");
        sb.append(JsCallJava.promptMsgFormat("'" + this.mInterfacedName + "'", "l", "e", "f"));
        sb.append("));console.log(\"invoke \"+l+\", time: \"+(new Date().getTime()-k));var g=JSON.parse(m);if(g.CODE!=200){throw\"");
        sb.append(this.mInterfacedName);
        sb.append(" call result, CODE:\"+g.CODE+\", message:\"+g.result}return g.result};Object.getOwnPropertyNames(a).forEach(function(d){var c=a[d];if(typeof c===\"function\"&&d!==\"callback\"){a[d]=function(){return c.apply(a,[d].concat(Array.prototype.slice.call(arguments,0)))}}});b.");
        sb.append(this.mInterfacedName);
        sb.append("=a;console.log(\"");
        sb.append(this.mInterfacedName);
        sb.append(" init end\")})(window)");
        this.mPreloadInterfaceJs = sb.toString();
        sb.setLength(0);
    }

    public static JsCallJava newCall(Object object, String name) {
        return new JsCallJava(object, name);
    }

    public String getPreloadInterfaceJs() {
        return this.mPreloadInterfaceJs;
    }

    public String call(WebView webView, JSONObject jsonObject) {
        long time = 0L;
        if (jsonObject != null) {
            try {
                String methodName = jsonObject.getString(KEY_METHOD);
                JSONArray argsTypes = jsonObject.getJSONArray(KEY_TYPES);
                JSONArray argsVals = jsonObject.getJSONArray(KEY_ARGS);
                String sign = methodName;
                int len = argsTypes.length();
                Object[] values = new Object[len];
                int numIndex = 0;
                for (int k = 0; k < len; ++k) {
                    String currType = argsTypes.optString(k);
                    if ("string".equals(currType)) {
                        sign = sign + "_S";
                        values[k] = argsVals.isNull(k) ? null : argsVals.getString(k);
                        continue;
                    }
                    if ("number".equals(currType)) {
                        sign = sign + "_N";
                        numIndex = numIndex * 10 + k + 1;
                        continue;
                    }
                    if ("boolean".equals(currType)) {
                        sign = sign + "_B";
                        values[k] = argsVals.getBoolean(k);
                        continue;
                    }
                    if ("object".equals(currType)) {
                        sign = sign + "_O";
                        values[k] = argsVals.isNull(k) ? null : argsVals.getJSONObject(k);
                        continue;
                    }
                    if ("function".equals(currType)) {
                        sign = sign + "_F";
                        values[k] = new JsCallback(webView, this.mInterfacedName, argsVals.getInt(k));
                        continue;
                    }
                    sign = sign + "_P";
                }
                Method currMethod = this.mMethodsMap.get(sign);
                if (currMethod == null) {
                    return this.getReturn(jsonObject, 500, "not found method(" + sign + ") with valid parameters", time);
                }
                if (numIndex > 0) {
                    Class<?>[] methodTypes = currMethod.getParameterTypes();
                    while (numIndex > 0) {
                        int currIndex = numIndex - numIndex / 10 * 10 - 1;
                        Class<?> currCls = methodTypes[currIndex];
                        values[currIndex] = currCls == Integer.TYPE ? (Number)argsVals.getInt(currIndex) : (Number)(currCls == Long.TYPE ? (Number)Long.parseLong(argsVals.getString(currIndex)) : (Number)argsVals.getDouble(currIndex));
                        numIndex /= 10;
                    }
                }
                return this.getReturn(jsonObject, 200, currMethod.invoke(this.mInterfaceObj, values), time);
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    return this.getReturn(jsonObject, 500, "method execute result:" + e.getCause().getMessage(), time);
                }
                return this.getReturn(jsonObject, 500, "method execute result:" + e.getMessage(), time);
            }
        }
        return this.getReturn(jsonObject, 500, "call data empty", time);
    }

    private String genJavaMethodSign(Method method) {
        String sign = method.getName();
        Class<?>[] argsTypes = method.getParameterTypes();
        for (String ignoreMethod : IGNORE_UNSAFE_METHODS) {
            if (!ignoreMethod.equals(sign)) continue;
            return null;
        }
        for (Class<?> cls : argsTypes) {
            sign = cls == String.class ? sign + "_S" : (cls == Integer.TYPE || cls == Long.TYPE || cls == Float.TYPE || cls == Double.TYPE ? sign + "_N" : (cls == Boolean.TYPE ? sign + "_B" : (cls == JSONObject.class ? sign + "_O" : (cls == JsCallback.class ? sign + "_F" : sign + "_P"))));
        }
        return sign;
    }

    private String getReturn(JSONObject reqJson, int stateCode, Object result, long time) {
        String insertRes;
        if (result == null) {
            insertRes = "null";
        } else if (result instanceof String) {
            result = ((String)result).replace("\"", "\\\"");
            insertRes = "\"".concat(String.valueOf(result)).concat("\"");
        } else {
            insertRes = String.valueOf(result);
        }
        return String.format(Locale.getDefault(), RETURN_RESULT_FORMAT, stateCode, insertRes);
    }

    private static String promptMsgFormat(String object, String method, String types, String args) {
        return "{obj:" + object + "," + KEY_METHOD + ":" + method + "," + KEY_TYPES + ":" + types + "," + KEY_ARGS + ":" + args + "}";
    }

    static boolean isSafeWebViewCallMsg(String message) {
        return message.startsWith(MSG_PROMPT_HEADER);
    }

    static JSONObject getMsgJSONObject(String message) {
        JSONObject jsonObject;
        message = message.substring(MSG_PROMPT_HEADER.length());
        try {
            jsonObject = new JSONObject(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            jsonObject = new JSONObject();
        }
        return jsonObject;
    }

    static String getInterfacedName(JSONObject jsonObject) {
        return jsonObject.optString(KEY_OBJ);
    }
}

