/*
 * Decompiled with CFR 0.152.
 */
package com.talent.compat.web.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Pair;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.talent.compat.web.core.WebChromeClientWrapper;
import com.talent.compat.web.core.WebViewClientWrapper;
import com.talent.compat.web.core.callback.SupportWebClient;
import com.talent.compat.web.core.callback.WebClient;
import com.talent.compat.web.core.compat.AccessibilityCompat;
import com.talent.compat.web.core.compat.WebViewCompat;
import com.talent.compat.web.core.compat.WebViewConfigCompat;
import com.talent.compat.web.core.js.JellyBeanJsInjection;
import com.talent.compat.web.core.js.JsConstructors;
import com.talent.compat.web.core.js.JsInjection;
import com.talent.compat.web.core.js.UnderSupportJsInjection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompatWebView
extends WebView {
    private static final WebViewConfigCompat.WebViewConfigHandler mConfigHandler = Build.VERSION.SDK_INT < 16 ? new WebViewConfigCompat.LowVersionHandler() : (Build.VERSION.SDK_INT < 19 ? new WebViewConfigCompat.JellyBeanHandler() : new WebViewConfigCompat.KitKatHandler());
    private final JsInjection mJsInjection;
    private Map<String, String> mInjectJavaScripts;
    private final SupportWebClient mSupportWebClient;
    private final List<WebClient> mWebClients = new ArrayList<WebClient>();
    private final AccessibilityCompat mAccessCompat;
    private boolean mHasConstructed = false;
    private boolean mHasWebViewClient = false;
    private boolean mHasWebChromeClient = false;

    public CompatWebView(Context context) {
        this(context, null);
    }

    public CompatWebView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842885);
    }

    public CompatWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mJsInjection = Build.VERSION.SDK_INT >= 17 ? new JellyBeanJsInjection() : new UnderSupportJsInjection();
        this.mSupportWebClient = new SupportWebClient();
        this.registerWebClient(this.mSupportWebClient);
        this.mAccessCompat = new AccessibilityCompat(this);
        WebViewCompat.removeSearchBoxJavaBridge(this);
        this.mHasConstructed = true;
    }

    @SuppressLint(value={"JavascriptInterface", "AddJavascriptInterface"})
    public void addJavascriptInterface(Object object, String name) {
        super.addJavascriptInterface(object, name);
    }

    public final void addJavascript(Object object, String name) {
        this.mJsInjection.addJavascriptInterface(this, object, name);
        this.onJavaScriptInterfaceAdded(object, name);
    }

    public final void addJavascript(String javaScript) {
        if (this.mInjectJavaScripts == null) {
            this.mInjectJavaScripts = new HashMap<String, String>();
        }
        this.mInjectJavaScripts.put(String.valueOf(javaScript.hashCode()), javaScript);
    }

    public final void setWebChromeClient(WebChromeClient client) {
        this.mHasWebChromeClient = true;
        WebChromeClientWrapper wrapper = new WebChromeClientWrapper(this);
        wrapper.setDelegate(client);
        this.mSupportWebClient.setWebChromeClient(wrapper);
        super.setWebChromeClient((WebChromeClient)wrapper);
        this.onWebChromeClientSetup(wrapper);
    }

    public final void setWebViewClient(WebViewClient client) {
        this.mHasWebViewClient = true;
        WebViewClientWrapper wrapper = new WebViewClientWrapper(this, this.mAccessCompat);
        wrapper.setDelegate(client);
        super.setWebViewClient((WebViewClient)wrapper);
        this.onWebViewClientSetup(wrapper);
    }

    public void destroy() {
        this.setVisibility(8);
        this.mJsInjection.unregister();
        if (this.mInjectJavaScripts != null) {
            this.mInjectJavaScripts.clear();
            this.mInjectJavaScripts = null;
        }
        this.mWebClients.clear();
        super.setWebChromeClient(null);
        super.setWebViewClient(null);
        this.removeAllViewsInLayout();
        WebViewCompat.detachWebParent(this);
        mConfigHandler.destroyWebViewConfigCallback();
        if (this.mHasConstructed) {
            this.mAccessCompat.resetAccessibilityEnabled();
        }
        super.destroy();
    }

    public void clearHistory() {
        if (this.mHasConstructed) {
            super.clearHistory();
        }
    }

    public void setOverScrollMode(int mode) {
        try {
            super.setOverScrollMode(mode);
        }
        catch (Throwable e) {
            Pair<Boolean, String> pair = WebViewCompat.isWebViewPackageException(e);
            if (((Boolean)pair.first).booleanValue()) {
                Toast.makeText((Context)this.getContext(), (CharSequence)((CharSequence)pair.second), (int)0).show();
                this.destroy();
            }
            throw e;
        }
    }

    public boolean isPrivateBrowsingEnabled() {
        if (Build.VERSION.SDK_INT == 15 && this.getSettings() == null) {
            return false;
        }
        return super.isPrivateBrowsingEnabled();
    }

    protected void onWebChromeClientSetup(WebChromeClient client) {
    }

    protected void onJavaScriptInterfaceAdded(Object interfaceObj, String interfaceName) {
    }

    public void onWebViewClientSetup(WebViewClient client) {
    }

    final void onReceivedTitle(WebView view, String title) {
        for (WebClient client : this.mWebClients) {
            client.onReceivedTitle(view, title);
        }
    }

    final void onPageStarted(WebView view, String url, Bitmap favicon) {
        for (WebClient client : this.mWebClients) {
            client.onPageStarted(view, url, favicon);
        }
    }

    final void onPageFinished(WebView view, String url) {
        for (WebClient client : this.mWebClients) {
            client.onPageFinished(view, url);
        }
    }

    final void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        for (WebClient client : this.mWebClients) {
            client.onReceivedError(view, errorCode, description, failingUrl);
        }
    }

    final void onProgressChanged(WebView view, int newProgress) {
        for (WebClient client : this.mWebClients) {
            client.onProgressChanged(view, newProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWebClient(WebClient client) {
        if (client == null) {
            return;
        }
        List<WebClient> list = this.mWebClients;
        synchronized (list) {
            this.mWebClients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterWebClient(WebClient client) {
        if (client == null) {
            return;
        }
        List<WebClient> list = this.mWebClients;
        synchronized (list) {
            this.mWebClients.remove(client);
        }
    }

    public void useDefaultWebViewClient() {
        this.setWebViewClient(null);
    }

    public void useDefaultWebChromeClient() {
        this.setWebChromeClient(null);
    }

    public JsInjection getJsInjection() {
        return this.mJsInjection;
    }

    public void injectJavaScript() {
        if (this.mInjectJavaScripts == null) {
            return;
        }
        for (Map.Entry<String, String> entry : this.mInjectJavaScripts.entrySet()) {
            this.loadUrl(JsConstructors.buildNotRepeatInjectJS(entry.getKey(), entry.getValue()));
        }
    }

    public boolean isInstallWebViewClient() {
        return this.mHasWebViewClient;
    }

    public boolean isInstallWebChromeClient() {
        return this.mHasWebChromeClient;
    }

    public void prepare() {
        if (!this.isInstallWebViewClient()) {
            this.useDefaultWebViewClient();
        }
        if (!this.isInstallWebChromeClient()) {
            this.useDefaultWebChromeClient();
        }
    }
}

