package com.talent.compat.web.core.compat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.accessibility.AccessibilityManager;
import android.webkit.WebView;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;

/**
 * Created by wbs on 2018/3/20 0020.
 */

public class AccessibilityCompat {

    private final WebView mWebView;

    private Context mContext;

    private Boolean mIsAccessibilityEnabledOriginal;

    public AccessibilityCompat(WebView mWebView) {
        this.mWebView = mWebView;
        mContext = mWebView.getContext();
    }
    public void fixedAccessibilityInjectorExceptionForOnPageFinished(String url) {
        if (Build.VERSION.SDK_INT == Build.VERSION_CODES.JELLY_BEAN
                && mWebView.getSettings().getJavaScriptEnabled()
                && mIsAccessibilityEnabledOriginal == null
                && isAccessibilityEnabled()) {
            try {
                try {
                    URLEncoder.encode(String.valueOf(new URI(url)), "utf-8");
                } catch (IllegalArgumentException e) {
                    if ("bad parameter".equals(e.getMessage())) {
                        mIsAccessibilityEnabledOriginal = true;
                        setAccessibilityEnabled(false);
                    }
                }
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
    private boolean isAccessibilityEnabled() {
        AccessibilityManager am = (AccessibilityManager) mContext.getSystemService(Context.ACCESSIBILITY_SERVICE);
        return am != null && am.isEnabled();
    }
    private void setAccessibilityEnabled(boolean enabled) {
        AccessibilityManager am = (AccessibilityManager)mContext.getSystemService(Context.ACCESSIBILITY_SERVICE);
        if(am==null){
            return;
        }
        try {
            @SuppressLint("PrivateApi")
            Method setAccessibilityState = am.getClass().getDeclaredMethod("setAccessibilityState", boolean.class);
            setAccessibilityState.setAccessible(true);
            setAccessibilityState.invoke(am, enabled);
            setAccessibilityState.setAccessible(false);
        } catch (Throwable e) {
           e.printStackTrace();
        }
    }

    public void resetAccessibilityEnabled() {
        if (mIsAccessibilityEnabledOriginal != null) {
            setAccessibilityEnabled(mIsAccessibilityEnabledOriginal);
        }
    }
}
