/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.avatargenerator.element.identicon;

import com.talanlabs.avatargenerator.utils.AvatarUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class NineBlockIdenticonRenderer {
    private static final int PATCH_GRIDS = 5;
    private static final float DEFAULT_PATCH_SIZE = 20.0f;
    private static final byte PATCH_SYMMETRIC = 1;
    private static final byte PATCH_INVERTED = 2;
    private static final int PATCH_MOVETO = -1;
    private static final byte[] patch0 = new byte[]{0, 4, 24, 20};
    private static final byte[] patch1 = new byte[]{0, 4, 20};
    private static final byte[] patch2 = new byte[]{2, 24, 20};
    private static final byte[] patch3 = new byte[]{0, 2, 20, 22};
    private static final byte[] patch4 = new byte[]{2, 14, 22, 10};
    private static final byte[] patch5 = new byte[]{0, 14, 24, 22};
    private static final byte[] patch6 = new byte[]{2, 24, 22, 13, 11, 22, 20};
    private static final byte[] patch7 = new byte[]{0, 14, 22};
    private static final byte[] patch8 = new byte[]{6, 8, 18, 16};
    private static final byte[] patch9 = new byte[]{4, 20, 10, 12, 2};
    private static final byte[] patch10 = new byte[]{0, 2, 12, 10};
    private static final byte[] patch11 = new byte[]{10, 14, 22};
    private static final byte[] patch12 = new byte[]{20, 12, 24};
    private static final byte[] patch13 = new byte[]{10, 2, 12};
    private static final byte[] patch14 = new byte[]{0, 2, 10};
    private static final byte[][] patchTypes = new byte[][]{patch0, patch1, patch2, patch3, patch4, patch5, patch6, patch7, patch8, patch9, patch10, patch11, patch12, patch13, patch14, patch0};
    private static final byte[] patchFlags = new byte[]{1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 3};
    private static int[] centerPatchTypes = new int[]{0, 4, 8, 15};
    private float patchSize;
    private GeneralPath[] patchShapes;
    private float patchOffset;
    private Color backgroundColor = Color.WHITE;

    public NineBlockIdenticonRenderer() {
        this.setPatchSize(20.0f);
    }

    public float getPatchSize() {
        return this.patchSize;
    }

    public void setPatchSize(float size) {
        this.patchSize = size;
        this.patchOffset = this.patchSize / 2.0f;
        float patchScale = this.patchSize / 4.0f;
        this.patchShapes = new GeneralPath[patchTypes.length];
        for (int i = 0; i < patchTypes.length; ++i) {
            GeneralPath patch = new GeneralPath(1);
            boolean moveTo = true;
            byte[] patchVertices = patchTypes[i];
            for (int j = 0; j < patchVertices.length; ++j) {
                byte v = patchVertices[j];
                if (v == -1) {
                    moveTo = true;
                }
                float vx = (float)(v % 5) * patchScale - this.patchOffset;
                float vy = (float)Math.floor((float)v / 5.0f) * patchScale - this.patchOffset;
                if (!moveTo) {
                    patch.lineTo(vx, vy);
                    continue;
                }
                moveTo = false;
                patch.moveTo(vx, vy);
            }
            patch.closePath();
            this.patchShapes[i] = patch;
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public BufferedImage render(int code, int size) {
        return this.renderQuilt(code, size);
    }

    protected BufferedImage renderQuilt(int code, int size) {
        int middleType = centerPatchTypes[code & 3];
        boolean middleInvert = (code >> 2 & 1) != 0;
        int cornerType = code >> 3 & 0xF;
        boolean cornerInvert = (code >> 7 & 1) != 0;
        int cornerTurn = code >> 8 & 3;
        int sideType = code >> 10 & 0xF;
        boolean sideInvert = (code >> 14 & 1) != 0;
        int sideTurn = code >> 15 & 3;
        int blue = code >> 16 & 0x1F;
        int green = code >> 21 & 0x1F;
        int red = code >> 27 & 0x1F;
        Color fillColor = new Color(red << 3, green << 3, blue << 3);
        Color strokeColor = null;
        if (AvatarUtils.getColorDistance(fillColor, this.backgroundColor) < 32.0f) {
            strokeColor = AvatarUtils.getComplementaryColor(fillColor);
        }
        BufferedImage targetImage = new BufferedImage(size, size, 1);
        Graphics2D g = targetImage.createGraphics();
        AvatarUtils.activeAntialiasing(g);
        g.setBackground(this.backgroundColor);
        g.clearRect(0, 0, size, size);
        float blockSize = (float)size / 3.0f;
        float blockSize2 = blockSize * 2.0f;
        this.drawPatch(g, blockSize, blockSize, blockSize, middleType, 0, middleInvert, fillColor, strokeColor);
        this.drawPatch(g, blockSize, 0.0f, blockSize, sideType, sideTurn++, sideInvert, fillColor, strokeColor);
        this.drawPatch(g, blockSize2, blockSize, blockSize, sideType, sideTurn++, sideInvert, fillColor, strokeColor);
        this.drawPatch(g, blockSize, blockSize2, blockSize, sideType, sideTurn++, sideInvert, fillColor, strokeColor);
        this.drawPatch(g, 0.0f, blockSize, blockSize, sideType, sideTurn++, sideInvert, fillColor, strokeColor);
        this.drawPatch(g, 0.0f, 0.0f, blockSize, cornerType, cornerTurn++, cornerInvert, fillColor, strokeColor);
        this.drawPatch(g, blockSize2, 0.0f, blockSize, cornerType, cornerTurn++, cornerInvert, fillColor, strokeColor);
        this.drawPatch(g, blockSize2, blockSize2, blockSize, cornerType, cornerTurn++, cornerInvert, fillColor, strokeColor);
        this.drawPatch(g, 0.0f, blockSize2, blockSize, cornerType, cornerTurn++, cornerInvert, fillColor, strokeColor);
        g.dispose();
        return targetImage;
    }

    private void drawPatch(Graphics2D g, float x, float y, float size, int patch, int turn, boolean invert, Color fillColor, Color strokeColor) {
        assert (patch >= 0);
        assert (turn >= 0);
        turn %= 4;
        if ((patchFlags[patch %= patchTypes.length] & 2) != 0) {
            invert = !invert;
        }
        GeneralPath shape = this.patchShapes[patch];
        double scale = (double)size / (double)this.patchSize;
        float offset = size / 2.0f;
        g.setColor(invert ? fillColor : this.backgroundColor);
        g.fill(new Rectangle2D.Float(x, y, size, size));
        AffineTransform savet = g.getTransform();
        g.translate(x + offset, y + offset);
        g.scale(scale, scale);
        g.rotate(Math.toRadians(turn * 90));
        if (strokeColor != null) {
            g.setColor(strokeColor);
            g.draw(shape);
        }
        g.setColor(invert ? this.backgroundColor : fillColor);
        g.fill(shape);
        g.setTransform(savet);
    }
}

