/*
 * Decompiled with CFR 0.152.
 */
package com.takwolf.android.widget;

import android.widget.AbsListView;
import java.util.ArrayList;
import java.util.List;

class AbsListViewOnScrollListenerProxy
implements AbsListView.OnScrollListener {
    private AbsListView.OnScrollListener onScrollListener;
    private List<AbsListView.OnScrollListener> onScrollListenerList;

    AbsListViewOnScrollListenerProxy() {
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.onScrollListener != null) {
            this.onScrollListener.onScrollStateChanged(view, scrollState);
        }
        if (this.onScrollListenerList != null && this.onScrollListenerList.size() > 0) {
            for (AbsListView.OnScrollListener onScrollListener : this.onScrollListenerList) {
                onScrollListener.onScrollStateChanged(view, scrollState);
            }
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.onScrollListener != null) {
            this.onScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
        if (this.onScrollListenerList != null && this.onScrollListenerList.size() > 0) {
            for (AbsListView.OnScrollListener onScrollListener : this.onScrollListenerList) {
                onScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        }
    }

    void setOnScrollListener(AbsListView.OnScrollListener listener) {
        this.onScrollListener = listener;
    }

    void addOnScrollListener(AbsListView.OnScrollListener listener) {
        if (this.onScrollListenerList == null) {
            this.onScrollListenerList = new ArrayList<AbsListView.OnScrollListener>();
        }
        this.onScrollListenerList.add(listener);
    }

    void removeOnScrollListener(AbsListView.OnScrollListener listener) {
        if (this.onScrollListenerList != null) {
            this.onScrollListenerList.remove(listener);
        }
    }

    void clearOnScrollListeners() {
        if (this.onScrollListenerList != null) {
            this.onScrollListenerList.clear();
        }
    }
}

