package com.takwolf.android.widget;

import android.widget.AbsListView;

import java.util.ArrayList;
import java.util.List;

class AbsListViewOnScrollListenerProxy implements AbsListView.OnScrollListener {

    private AbsListView.OnScrollListener onScrollListener;
    private List<AbsListView.OnScrollListener> onScrollListenerList;

    @Override
    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (onScrollListener != null) {
            onScrollListener.onScrollStateChanged(view, scrollState);
        }
        if (onScrollListenerList != null && onScrollListenerList.size() > 0) {
            for (AbsListView.OnScrollListener onScrollListener : onScrollListenerList) {
                onScrollListener.onScrollStateChanged(view, scrollState);
            }
        }
    }

    @Override
    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (onScrollListener != null) {
            onScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
        if (onScrollListenerList != null && onScrollListenerList.size() > 0) {
            for (AbsListView.OnScrollListener onScrollListener : onScrollListenerList) {
                onScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        }
    }

    public void setOnScrollListener(AbsListView.OnScrollListener listener) {
        onScrollListener = listener;
    }

    public void addOnScrollListener(AbsListView.OnScrollListener listener) {
        if (onScrollListenerList == null) {
            onScrollListenerList = new ArrayList<>();
        }
        onScrollListenerList.add(listener);
    }

    public void removeOnScrollListener(AbsListView.OnScrollListener listener) {
        if (onScrollListenerList != null) {
            onScrollListenerList.remove(listener);
        }
    }

    public void clearOnScrollListeners() {
        if (onScrollListenerList != null) {
            onScrollListenerList.clear();
        }
    }

}
