/*
 * Decompiled with CFR 0.152.
 */
package com.takwolf.android.fragmentswitcher;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.AttributeSet;
import android.widget.FrameLayout;

public class FragmentSwitcher
extends FrameLayout {
    private Adapter adapter = null;
    private int currentItem = -1;
    private OnItemSelectedListener onItemSelectedListener = null;

    public FragmentSwitcher(Context context) {
        super(context);
    }

    public FragmentSwitcher(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FragmentSwitcher(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public FragmentSwitcher(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    private String makeFragmentName(int position) {
        return "fragment:pager:" + this.getId() + ":" + position;
    }

    public void setAdapter(@NonNull Adapter adapter) {
        this.adapter = adapter;
        this.currentItem = 0;
        FragmentTransaction transaction = adapter.getFragmentManager().beginTransaction();
        Fragment fragment = adapter.getItem(this.currentItem);
        fragment.setMenuVisibility(true);
        fragment.setUserVisibleHint(true);
        transaction.replace(this.getId(), fragment, this.makeFragmentName(this.currentItem));
        transaction.commitAllowingStateLoss();
    }

    public void setOnItemSelectedListener(@Nullable OnItemSelectedListener onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    public int getCurrentItem() {
        if (this.adapter == null) {
            throw new RuntimeException("Must set adapter before call this function.");
        }
        return this.currentItem;
    }

    public void setCurrentItem(int position) {
        if (this.adapter == null) {
            throw new RuntimeException("Must set adapter before call this function.");
        }
        if (position != this.currentItem) {
            FragmentTransaction transaction = this.adapter.getFragmentManager().beginTransaction();
            Fragment fragmentCurrent = this.adapter.getItem(this.currentItem);
            transaction.hide(fragmentCurrent);
            fragmentCurrent.setMenuVisibility(false);
            fragmentCurrent.setUserVisibleHint(false);
            if (this.onItemSelectedListener != null) {
                this.onItemSelectedListener.onItemSelected(this.currentItem, fragmentCurrent, false);
            }
            String name = this.makeFragmentName(position);
            Fragment fragmentNext = this.adapter.getFragmentManager().findFragmentByTag(name);
            if (fragmentNext != null) {
                transaction.show(fragmentNext);
            } else {
                fragmentNext = this.adapter.getItem(position);
                transaction.add(this.getId(), fragmentNext, name);
            }
            fragmentNext.setMenuVisibility(true);
            fragmentNext.setUserVisibleHint(true);
            if (this.onItemSelectedListener != null) {
                this.onItemSelectedListener.onItemSelected(position, fragmentNext, true);
            }
            transaction.commitAllowingStateLoss();
            this.currentItem = position;
        }
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(int var1, @NonNull Fragment var2, boolean var3);
    }

    public static abstract class Adapter {
        private final FragmentManager fragmentManager;

        public Adapter(@NonNull FragmentManager fragmentManager) {
            this.fragmentManager = fragmentManager;
        }

        @NonNull
        private FragmentManager getFragmentManager() {
            return this.fragmentManager;
        }

        public abstract Fragment getItem(int var1);
    }
}

