package com.takwolf.android.fragmentswitcher;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.AttributeSet;
import android.widget.FrameLayout;

public class FragmentSwitcher extends FrameLayout {

    private Adapter adapter = null;
    private int currentItem = -1;
    private OnItemSelectedListener onItemSelectedListener = null;

    public FragmentSwitcher(Context context) {
        super(context);
    }

    public FragmentSwitcher(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FragmentSwitcher(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public FragmentSwitcher(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    private String makeFragmentName(int position) {
        return "fragment:pager:" + getId() + ":" + position;
    }

    public void setAdapter(@NonNull Adapter adapter) {
        this.adapter = adapter;
        currentItem = 0;
        FragmentTransaction transaction = adapter.getFragmentManager().beginTransaction();
        Fragment fragment = adapter.getItem(currentItem);
        fragment.setMenuVisibility(true);
        fragment.setUserVisibleHint(true);
        transaction.replace(getId(), fragment, makeFragmentName(currentItem));
        transaction.commitAllowingStateLoss();
    }

    public void setOnItemSelectedListener(@Nullable OnItemSelectedListener onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    public int getCurrentItem() {
        if (adapter == null) {
            throw new RuntimeException("Must set adapter before call this function.");
        }
        return currentItem;
    }

    public void setCurrentItem(int position) {
        if (adapter == null) {
            throw new RuntimeException("Must set adapter before call this function.");
        }
        if (position != currentItem) {
            FragmentTransaction transaction = adapter.getFragmentManager().beginTransaction();

            Fragment fragmentCurrent = adapter.getItem(currentItem);
            transaction.hide(fragmentCurrent);
            fragmentCurrent.setMenuVisibility(false);
            fragmentCurrent.setUserVisibleHint(false);
            if (onItemSelectedListener != null) {
                onItemSelectedListener.onItemSelected(currentItem, fragmentCurrent, false);
            }

            String name = makeFragmentName(position);
            Fragment fragmentNext = adapter.getFragmentManager().findFragmentByTag(name);
            if (fragmentNext != null) {
                transaction.show(fragmentNext);
            } else {
                fragmentNext = adapter.getItem(position);
                transaction.add(getId(), fragmentNext, name);
            }
            fragmentNext.setMenuVisibility(true);
            fragmentNext.setUserVisibleHint(true);
            if (onItemSelectedListener != null) {
                onItemSelectedListener.onItemSelected(position, fragmentNext, true);
            }

            transaction.commitAllowingStateLoss();
            currentItem = position;
        }
    }

    public static abstract class Adapter {

        private final FragmentManager fragmentManager;

        public Adapter(@NonNull FragmentManager fragmentManager) {
            this.fragmentManager = fragmentManager;
        }

        @NonNull
        private FragmentManager getFragmentManager() {
            return fragmentManager;
        }

        public abstract Fragment getItem(int position);

    }

    public interface OnItemSelectedListener {

        void onItemSelected(int position, @NonNull Fragment fragment, boolean selected);

    }

}
