/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.fix.support.v7.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.takisoft.fix.support.v7.preference.EditTextPreference;
import com.takisoft.fix.support.v7.preference.R;

public class AutoSummaryEditTextPreference
extends EditTextPreference {
    private CharSequence summaryHasText;
    private CharSequence summary;
    private String passwordSubstitute;
    private int passwordSubstituteLength;

    public AutoSummaryEditTextPreference(Context context) {
        this(context, null);
    }

    public AutoSummaryEditTextPreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.editTextPreferenceStyle);
    }

    public AutoSummaryEditTextPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public AutoSummaryEditTextPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AutoSummaryEditTextPreference, defStyleAttr, 0);
        this.summaryHasText = a.getText(R.styleable.AutoSummaryEditTextPreference_pref_summaryHasText);
        this.passwordSubstitute = a.getString(R.styleable.AutoSummaryEditTextPreference_pref_summaryPasswordSubstitute);
        this.passwordSubstituteLength = a.getInt(R.styleable.AutoSummaryEditTextPreference_pref_summaryPasswordSubstituteLength, 5);
        if (this.passwordSubstitute == null) {
            this.passwordSubstitute = "\u2022";
        }
        a.recycle();
        this.summary = super.getSummary();
    }

    public CharSequence getSummary() {
        boolean hasText;
        String text = this.getText();
        boolean bl = hasText = !TextUtils.isEmpty((CharSequence)text);
        if (!hasText) {
            return this.summary;
        }
        int inputType = this.getEditText().getInputType();
        if ((inputType & 0x10) == 16 || (inputType & 0x80) == 128 || (inputType & 0xE0) == 224) {
            text = new String(new char[this.passwordSubstituteLength > 0 ? this.passwordSubstituteLength : text.length()]).replaceAll("\u0000", this.passwordSubstitute);
        }
        if (this.summaryHasText != null) {
            return String.format(this.summaryHasText.toString(), text);
        }
        return text;
    }

    public void setSummary(CharSequence summary) {
        super.setSummary(summary);
        if (summary == null && this.summary != null) {
            this.summary = null;
        } else if (summary != null && !summary.equals(this.summary)) {
            this.summary = summary.toString();
        }
    }

    @Nullable
    public CharSequence getSummaryHasText() {
        return this.summaryHasText;
    }

    public void setSummaryHasText(@StringRes int resId) {
        this.setSummaryHasText(this.getContext().getString(resId));
    }

    public void setSummaryHasText(@Nullable CharSequence summaryHasText) {
        if (summaryHasText == null && this.summaryHasText != null) {
            this.summaryHasText = null;
        } else if (summaryHasText != null && !summaryHasText.equals(this.summaryHasText)) {
            this.summaryHasText = summaryHasText.toString();
        }
        this.notifyChanged();
    }

    public CharSequence getPasswordSubstitute() {
        return this.passwordSubstitute;
    }

    public void setPasswordSubstitute(@StringRes int resId) {
        this.setPasswordSubstitute(this.getContext().getString(resId));
    }

    public void setPasswordSubstitute(String passwordSubstitute) {
        this.passwordSubstitute = passwordSubstitute;
    }

    public int getPasswordSubstituteLength() {
        return this.passwordSubstituteLength;
    }

    public void setPasswordSubstituteLength(int passwordSubstituteLength) {
        this.passwordSubstituteLength = passwordSubstituteLength;
    }
}

