/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.fix.support.v7.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v7.preference.DialogPreference;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.takisoft.fix.support.v7.preference.PreferenceFragmentCompat;
import com.takisoft.fix.support.v7.preference.RingtonePreferenceDialogFragmentCompat;
import com.takisoft.fix.support.v7.preference.ringtone.R;

public class RingtonePreference
extends DialogPreference {
    private static final int CUSTOM_RINGTONE_REQUEST_CODE = 36864;
    private static final int WRITE_FILES_PERMISSION_REQUEST_CODE = 36865;
    private int ringtoneType;
    private boolean showDefault;
    private boolean showSilent;
    private boolean showAdd;
    private Uri ringtoneUri;
    private int miscCustomRingtoneRequestCode = 36864;
    private int miscPermissionRequestCode = 36865;

    public RingtonePreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        android.preference.RingtonePreference proxyPreference = Build.VERSION.SDK_INT >= 21 ? new android.preference.RingtonePreference(context, attrs, defStyleAttr, defStyleRes) : new android.preference.RingtonePreference(context, attrs, defStyleAttr);
        this.ringtoneType = proxyPreference.getRingtoneType();
        this.showDefault = proxyPreference.getShowDefault();
        this.showSilent = proxyPreference.getShowSilent();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RingtonePreference, defStyleAttr, 0);
        this.showAdd = a.getBoolean(R.styleable.RingtonePreference_showAdd, true);
        a.recycle();
    }

    public RingtonePreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @SuppressLint(value={"RestrictedApi"})
    public RingtonePreference(Context context, AttributeSet attrs) {
        this(context, attrs, TypedArrayUtils.getAttr((Context)context, (int)R.attr.dialogPreferenceStyle, (int)0x1010091));
    }

    public RingtonePreference(Context context) {
        this(context, null);
    }

    public int getRingtoneType() {
        return this.ringtoneType;
    }

    public void setRingtoneType(int ringtoneType) {
        this.ringtoneType = ringtoneType;
    }

    public boolean getShowDefault() {
        return this.showDefault;
    }

    public void setShowDefault(boolean showDefault) {
        this.showDefault = showDefault;
    }

    public boolean getShowSilent() {
        return this.showSilent;
    }

    public void setShowSilent(boolean showSilent) {
        this.showSilent = showSilent;
    }

    public boolean getShowAdd() {
        return this.showAdd;
    }

    boolean shouldShowAdd() {
        if (this.showAdd) {
            try {
                String[] permissions;
                PackageInfo pInfo = this.getContext().getPackageManager().getPackageInfo(this.getContext().getPackageName(), 4096);
                for (String permission2 : permissions = pInfo.requestedPermissions) {
                    if (!"android.permission.WRITE_EXTERNAL_STORAGE".equals(permission2)) continue;
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void setShowAdd(boolean showAdd) {
        this.showAdd = showAdd;
    }

    public int getCustomRingtoneRequestCode() {
        return this.miscCustomRingtoneRequestCode;
    }

    public void setCustomRingtoneRequestCode(int customRingtoneRequestCode) {
        this.miscCustomRingtoneRequestCode = customRingtoneRequestCode;
    }

    public int getPermissionRequestCode() {
        return this.miscPermissionRequestCode;
    }

    public void setPermissionRequestCode(int permissionRequestCode) {
        this.miscPermissionRequestCode = permissionRequestCode;
    }

    public Uri getRingtone() {
        return this.onRestoreRingtone();
    }

    public void setRingtone(Uri uri) {
        this.setInternalRingtone(uri, false);
    }

    private void setInternalRingtone(Uri uri, boolean force) {
        boolean changed;
        Uri oldUri = this.onRestoreRingtone();
        boolean bl = changed = oldUri != null && !oldUri.equals((Object)uri) || uri != null && !uri.equals((Object)oldUri);
        if (changed || force) {
            boolean wasBlocking = this.shouldDisableDependents();
            this.ringtoneUri = uri;
            this.onSaveRingtone(uri);
            boolean isBlocking = this.shouldDisableDependents();
            this.notifyChanged();
            if (isBlocking != wasBlocking) {
                this.notifyDependencyChange(isBlocking);
            }
        }
    }

    protected void onSaveRingtone(Uri ringtoneUri) {
        this.persistString(ringtoneUri != null ? ringtoneUri.toString() : "");
    }

    protected Uri onRestoreRingtone() {
        String uriString = this.getPersistedString(this.ringtoneUri == null ? null : this.ringtoneUri.toString());
        return !TextUtils.isEmpty((CharSequence)uriString) ? Uri.parse((String)uriString) : null;
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    protected void onSetInitialValue(boolean restoreValue, Object defaultValueObj) {
        String defaultValue = (String)defaultValueObj;
        this.setInternalRingtone((Uri)(restoreValue ? this.onRestoreRingtone() : (!TextUtils.isEmpty((CharSequence)defaultValue) ? Uri.parse((String)defaultValue) : null)), true);
    }

    public boolean shouldDisableDependents() {
        return super.shouldDisableDependents() || this.onRestoreRingtone() == null;
    }

    static {
        PreferenceFragmentCompat.addDialogPreference(RingtonePreference.class, RingtonePreferenceDialogFragmentCompat.class);
    }
}

