/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.datetimepicker.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.content.res.AppCompatResources;
import com.takisoft.datetimepicker.R;

public class Utils {
    public static boolean colorHasState(ColorStateList color, int state) {
        Parcel parcel = Parcel.obtain();
        color.writeToParcel(parcel, 0);
        int specCount = parcel.readInt();
        for (int specIndex = 0; specIndex < specCount; ++specIndex) {
            int[] states = parcel.createIntArray();
            int stateCount = states.length;
            for (int stateIndex = 0; stateIndex < stateCount; ++stateIndex) {
                if (states[stateIndex] != state && states[stateIndex] != ~state) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLightTheme(@NonNull Context context) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{R.attr.isLightTheme});
        boolean isLightTheme = typedArray.getBoolean(0, false);
        typedArray.recycle();
        return isLightTheme;
    }

    public static Drawable tintDrawable(Context context, Drawable drawable, int tintAttr) {
        Drawable wrapped = DrawableCompat.wrap((Drawable)drawable);
        TypedArray arr = context.obtainStyledAttributes(new int[]{tintAttr});
        ColorStateList tintList = Utils.getColorStateList(context, arr, 0);
        arr.recycle();
        if (tintList != null) {
            DrawableCompat.setTintList((Drawable)wrapped, (ColorStateList)tintList);
        }
        return wrapped;
    }

    @Nullable
    public static ColorStateList getColorStateList(Context context, TypedArray original, int index) {
        if (Build.VERSION.SDK_INT >= 23) {
            return original.getColorStateList(index);
        }
        int resId = original.getResourceId(index, 0);
        return AppCompatResources.getColorStateList((Context)context, (int)resId);
    }

    @Nullable
    public static Drawable getDrawable(Context context, TypedArray original, int index, int tintResId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return original.getDrawable(index);
        }
        int resId = original.getResourceId(index, 0);
        Drawable drawable = AppCompatResources.getDrawable((Context)context, (int)resId);
        if (drawable != null) {
            Drawable wrapped = DrawableCompat.wrap((Drawable)drawable);
            DrawableCompat.applyTheme((Drawable)wrapped, (Resources.Theme)context.getTheme());
            TypedArray a = context.obtainStyledAttributes(new int[]{tintResId});
            ColorStateList tintList = a.getColorStateList(0);
            if (tintList != null) {
                DrawableCompat.setTintList((Drawable)wrapped, (ColorStateList)tintList);
            }
            drawable = wrapped;
            a.recycle();
        }
        return drawable;
    }
}

