/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.datetimepicker.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

class DayPickerViewPager
extends ViewPager {
    private final ArrayList<View> mMatchParentChildren = new ArrayList(1);

    public DayPickerViewPager(Context context) {
        this(context, null);
    }

    public DayPickerViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DayPickerViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public DayPickerViewPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        try {
            Method populate = ViewPager.class.getDeclaredMethod("populate", new Class[0]);
            populate.setAccessible(true);
            populate.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        int count = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            ViewPager.LayoutParams lp = (ViewPager.LayoutParams)child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            childState = DayPickerViewPager.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable2 = Build.VERSION.SDK_INT >= 23 ? this.getForeground() : null;
        if (drawable2 != null) {
            maxHeight = Math.max(maxHeight, drawable2.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable2.getMinimumWidth());
        }
        this.setMeasuredDimension(DayPickerViewPager.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), DayPickerViewPager.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (int i = 0; i < count; ++i) {
                View child = this.mMatchParentChildren.get(i);
                ViewPager.LayoutParams lp = (ViewPager.LayoutParams)child.getLayoutParams();
                int childWidthMeasureSpec = lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000) : DayPickerViewPager.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)lp.width);
                int childHeightMeasureSpec = lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000) : DayPickerViewPager.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)lp.height);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
        this.mMatchParentChildren.clear();
    }
}

