/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.datetimepicker.widget;

import android.content.Context;
import android.os.Build;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.view.View;
import com.takisoft.datetimepicker.widget.CalendarView;
import com.takisoft.datetimepicker.widget.DayPickerView;
import java.util.Calendar;

class CalendarViewMaterialDelegate
extends CalendarView.AbstractCalendarViewDelegate {
    private final DayPickerView mDayPickerView;
    private CalendarView.OnDateChangeListener mOnDateChangeListener;
    private final DayPickerView.OnDaySelectedListener mOnDaySelectedListener = new DayPickerView.OnDaySelectedListener(){

        @Override
        public void onDaySelected(DayPickerView view, Calendar day) {
            if (CalendarViewMaterialDelegate.this.mOnDateChangeListener != null) {
                int year = day.get(1);
                int month = day.get(2);
                int dayOfMonth = day.get(5);
                CalendarViewMaterialDelegate.this.mOnDateChangeListener.onSelectedDayChange(CalendarViewMaterialDelegate.this.mDelegator, year, month, dayOfMonth);
            }
        }
    };

    public CalendarViewMaterialDelegate(CalendarView delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(delegator, context);
        this.mDayPickerView = Build.VERSION.SDK_INT >= 21 ? new DayPickerView(context, attrs, defStyleAttr, defStyleRes) : new DayPickerView(context, attrs, defStyleAttr);
        this.mDayPickerView.setOnDaySelectedListener(this.mOnDaySelectedListener);
        delegator.addView((View)this.mDayPickerView);
    }

    @Override
    public void setWeekDayTextAppearance(@StyleRes int resId) {
        this.mDayPickerView.setDayOfWeekTextAppearance(resId);
    }

    @Override
    @StyleRes
    public int getWeekDayTextAppearance() {
        return this.mDayPickerView.getDayOfWeekTextAppearance();
    }

    @Override
    public void setDateTextAppearance(@StyleRes int resId) {
        this.mDayPickerView.setDayTextAppearance(resId);
    }

    @Override
    @StyleRes
    public int getDateTextAppearance() {
        return this.mDayPickerView.getDayTextAppearance();
    }

    @Override
    public void setMinDate(long minDate) {
        this.mDayPickerView.setMinDate(minDate);
    }

    @Override
    public long getMinDate() {
        return this.mDayPickerView.getMinDate();
    }

    @Override
    public void setMaxDate(long maxDate) {
        this.mDayPickerView.setMaxDate(maxDate);
    }

    @Override
    public long getMaxDate() {
        return this.mDayPickerView.getMaxDate();
    }

    @Override
    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.mDayPickerView.setFirstDayOfWeek(firstDayOfWeek);
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.mDayPickerView.getFirstDayOfWeek();
    }

    @Override
    public void setDate(long date) {
        this.mDayPickerView.setDate(date, true);
    }

    @Override
    public void setDate(long date, boolean animate, boolean center) {
        this.mDayPickerView.setDate(date, animate);
    }

    @Override
    public long getDate() {
        return this.mDayPickerView.getDate();
    }

    @Override
    public void setOnDateChangeListener(CalendarView.OnDateChangeListener listener) {
        this.mOnDateChangeListener = listener;
    }
}

