/*
 * Decompiled with CFR 0.152.
 */
package com.tailoredapps.androidutil;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"Lcom/tailoredapps/androidutil/IntentUtil;", "", "()V", "appSettings", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "call", "number", "", "mail", "maps", "location", "notificationSettings", "playstore", "web", "url", "androidutil_release"})
public final class IntentUtil {
    public static final IntentUtil INSTANCE;

    @NotNull
    public final Intent web(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return new Intent("android.intent.action.VIEW", Uri.parse((String)url));
    }

    @NotNull
    public final Intent mail(@NotNull String mail) {
        Intrinsics.checkParameterIsNotNull((Object)mail, (String)"mail");
        return new Intent("android.intent.action.SENDTO", Uri.parse((String)("mailto:" + mail)));
    }

    @NotNull
    public final Intent call(@NotNull String number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        return new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + number)));
    }

    @NotNull
    public final Intent maps(@NotNull String location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        return new Intent("android.intent.action.VIEW", Uri.parse((String)("http://maps.google.co.in/maps?q=" + location)));
    }

    @NotNull
    public final Intent playstore(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        StringBuilder stringBuilder = new StringBuilder().append("https://play.google.com/store/apps/details?id=");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        return new Intent("android.intent.action.VIEW", Uri.parse((String)stringBuilder.append(context2.getPackageName()).toString()));
    }

    @NotNull
    public final Intent appSettings(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)context.getPackageName(), null));
    }

    @NotNull
    public final Intent notificationSettings(@NotNull Context context) {
        Intent intent;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent $receiver = intent = new Intent("android.settings.APP_NOTIFICATION_SETTINGS");
        boolean bl = false;
        $receiver.putExtra("app_package", context.getPackageName());
        $receiver.putExtra("app_uid", context.getApplicationInfo().uid);
        $receiver.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
        return intent;
    }

    private IntentUtil() {
    }

    static {
        IntentUtil intentUtil;
        INSTANCE = intentUtil = new IntentUtil();
    }
}

