/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.lightnetwork.dynamic_url;

import android.text.TextUtils;
import android.util.Log;
import com.taboola.lightnetwork.dynamic_url.annotations.Body;
import com.taboola.lightnetwork.dynamic_url.annotations.GET;
import com.taboola.lightnetwork.dynamic_url.annotations.POST;
import com.taboola.lightnetwork.dynamic_url.annotations.Path;
import com.taboola.lightnetwork.dynamic_url.annotations.Query;
import com.taboola.lightnetwork.dynamic_url.annotations.QueryMap;
import com.taboola.lightnetwork.dynamic_url.annotations.TrackHeader;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.url_components.MutableUrl;
import com.taboola.lightnetwork.url_components.PathParam;
import com.taboola.lightnetwork.url_components.UrlParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.json.JSONObject;

public class DynamicRequest {
    private static final String TAG = DynamicRequest.class.getSimpleName();
    private HttpManager mHttpManager;
    private String mUrlString;
    private int mRequestType;
    private JSONObject mJsonBody;
    private String mTrackHeaderByGroup;
    private String mTrackHeadersKey;
    private String mBaseUrl;

    DynamicRequest(HttpManager httpManager, Method method, String baseUrl, Object[] args) {
        this.mHttpManager = httpManager;
        this.mBaseUrl = baseUrl;
        this.buildRequest(method, args);
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(HttpManager.NetworkResponse networkResponse) {
        switch (this.mRequestType) {
            case 0: {
                this.mHttpManager.get(this.mUrlString, this.mTrackHeadersKey, this.mTrackHeaderByGroup, networkResponse);
                break;
            }
            case 1: {
                this.mHttpManager.post(this.mUrlString, this.mJsonBody, this.mTrackHeadersKey, this.mTrackHeaderByGroup, networkResponse);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"Error processing method, methodType unrecognized");
            }
        }
    }

    public String getFinalUrl() {
        return this.mUrlString;
    }

    public JSONObject getJsonBody() {
        return this.mJsonBody;
    }

    private void buildRequest(Method method, Object[] args) {
        this.getRequestType(method);
        String baseUrl = this.getBaseUrl(method);
        this.parseAnnotations(baseUrl, method, args);
        this.determineHeaderTracking(method);
    }

    private void determineHeaderTracking(Method method) {
        TrackHeader trackHeaderAnnotation = method.getAnnotation(TrackHeader.class);
        if (trackHeaderAnnotation != null) {
            this.mTrackHeaderByGroup = trackHeaderAnnotation.group();
            this.mTrackHeadersKey = trackHeaderAnnotation.headerReadKey();
        }
    }

    private void parseAnnotations(String baseUrl, Method method, Object[] args) {
        MutableUrl mutableUrl = new MutableUrl(baseUrl);
        Annotation[][] perParametersAnnotations = method.getParameterAnnotations();
        if (perParametersAnnotations != null) {
            for (int parameter = 0; parameter < perParametersAnnotations.length; ++parameter) {
                for (int annotation = 0; annotation < perParametersAnnotations[parameter].length; ++annotation) {
                    Annotation tmpAnnotation = perParametersAnnotations[parameter][annotation];
                    if (tmpAnnotation instanceof Path) {
                        this.handlePathAnnotation(args[parameter], mutableUrl, tmpAnnotation);
                        continue;
                    }
                    if (tmpAnnotation instanceof Query) {
                        this.handleQueryAnnotation(args[parameter], mutableUrl, tmpAnnotation);
                        continue;
                    }
                    if (tmpAnnotation instanceof QueryMap) {
                        this.handleQueryMapAnnotation(args[parameter], mutableUrl);
                        continue;
                    }
                    if (tmpAnnotation instanceof Body) {
                        this.handleBodyAnnotation(args[parameter]);
                        continue;
                    }
                    Log.e((String)TAG, (String)("Annotation not recognized: " + tmpAnnotation.annotationType()));
                }
            }
        }
        this.mUrlString = mutableUrl.getUrl();
        Log.d((String)TAG, (String)("parseAnnotation | finalUrl = " + this.mUrlString));
    }

    private void handlePathAnnotation(Object arg, MutableUrl mutableUrl, Annotation tmpAnnotation) {
        String pathKey = ((Path)tmpAnnotation).value();
        Object pathVal = arg;
        mutableUrl.addPathParam(new PathParam(pathKey, String.valueOf(pathVal)));
    }

    private void handleQueryAnnotation(Object arg, MutableUrl mutableUrl, Annotation tmpAnnotation) {
        String queryKey = ((Query)tmpAnnotation).value();
        Object queryVal = arg;
        mutableUrl.addQueryParameter(new UrlParameter(queryKey, queryVal));
    }

    private void handleQueryMapAnnotation(Object arg, MutableUrl mutableUrl) {
        if (!(arg instanceof Map)) {
            throw new RuntimeException("DynamicRequest | parseAnnotation | @QueryMap parameter type must be Map.");
        }
        Map parameterMap = (Map)arg;
        for (Map.Entry mapParameter : parameterMap.entrySet()) {
            String queryMapParamKey = String.valueOf(mapParameter.getKey());
            String queryMapParamValue = String.valueOf(mapParameter.getValue());
            mutableUrl.addQueryParameter(new UrlParameter(queryMapParamKey, queryMapParamValue));
        }
    }

    private void handleBodyAnnotation(Object arg) {
        if (!(arg instanceof JSONObject)) {
            throw new RuntimeException("DynamicRequest | parseAnnotation | @Body parameter type must be of type org.json.JSONObject.");
        }
        this.mJsonBody = (JSONObject)arg;
    }

    private void getRequestType(Method method) {
        if (method.getAnnotation(GET.class) != null) {
            this.mRequestType = 0;
            return;
        }
        if (method.getAnnotation(POST.class) != null) {
            this.mRequestType = 1;
            return;
        }
        Log.e((String)TAG, (String)"DynamicRequest | getRequestType | Request interface must declare a known Http method (See REQUEST_TYPE) in method annotation.");
        this.mRequestType = -1;
    }

    private String getBaseUrl(Method method) {
        StringBuilder urlBuilder = new StringBuilder(TextUtils.isEmpty((CharSequence)this.mBaseUrl) ? "" : this.mBaseUrl);
        switch (this.mRequestType) {
            case 0: {
                urlBuilder.append(method.getAnnotation(GET.class).value());
                break;
            }
            case 1: {
                urlBuilder.append(method.getAnnotation(POST.class).value());
                break;
            }
            default: {
                Log.e((String)TAG, (String)"DynamicRequest | getBaseUrl | Request interface must declare a known Http method (See REQUEST_TYPE) in method annotation.");
            }
        }
        return urlBuilder.toString();
    }
}

