/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.text.TextUtils;
import com.taboola.android.utils.Logger;

public class UrlUtils {
    private static final String TAG = UrlUtils.class.getSimpleName();

    public static String replaceImageSizeInUrl(String imageUrl, int height, int width) {
        boolean addHeight = false;
        boolean addWidth = false;
        if (TextUtils.isEmpty((CharSequence)imageUrl)) {
            return imageUrl;
        }
        int imageUrlSeparatorIndex = imageUrl.lastIndexOf("/");
        if (imageUrlSeparatorIndex != -1) {
            String taboolaImageUrl = imageUrl.substring(0, imageUrlSeparatorIndex);
            String publisherImageUrl = imageUrl.substring(imageUrlSeparatorIndex + 1);
            if (!taboolaImageUrl.contains("%2Ch_")) {
                taboolaImageUrl = taboolaImageUrl + "%2Ch_" + height;
                addHeight = true;
            }
            if (!taboolaImageUrl.contains("%2Cw_")) {
                taboolaImageUrl = taboolaImageUrl + "%2Cw_" + width;
                addWidth = true;
            }
            if (!addWidth) {
                taboolaImageUrl = taboolaImageUrl.replaceFirst("%2Cw_\\d*", "%2Cw_" + width);
            }
            if (!addHeight) {
                taboolaImageUrl = taboolaImageUrl.replaceFirst("%2Ch_\\d*", "%2Ch_" + height);
            }
            try {
                imageUrl = String.format("%s/%s", taboolaImageUrl, publisherImageUrl);
            }
            catch (Exception e) {
                Logger.e(TAG, "replaceImageSizeInUrl() : Unable to format final Url. Returning original image url: " + imageUrl);
            }
        }
        return imageUrl;
    }
}

