/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Point;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.util.Pair;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.ListView;
import android.widget.ScrollView;
import androidx.core.view.ScrollingView;
import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;
import com.taboola.android.Taboola;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.monitor.TBSimCodeChange;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.NumberUtils;
import com.taboola.android.utils.PermissionUtils;
import com.taboola.android.utils.SecurityUtils;
import com.taboola.android.utils.SharedPrefUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

@Keep
public class SdkDetailsHelper {
    private static final String TAG = SdkDetailsHelper.class.getSimpleName();
    private static final String SDK_DATA = "sdkd";
    private static final String SDK_TYPE = "sdkt";
    private static final String SDK_VERSION = "sdkv";
    private static final String APP_NAME = "app";
    private static final String APP_VERSION = "appv";
    private static final String APP_ID = "appid";
    private static final String DEVICE_MODEL = "model";
    private static final String LANGUAGES_ROOT = "lng";
    private static final String KEYBOARD_LANGUAGES = "kbd";
    private static final String MAIN_LANGUAGE = "main";
    private static final String LOCALE_LANGUAGE = "locale";
    private static final String SIM_LANGUAGE = "sim";
    private static final String NETWORK_LANGUAGE = "netw";
    private static final String DISPLAY_LANGUAGE = "dsplng";
    private static final String OS = "os";
    private static final String OS_VERSION = "osv";
    private static final String MEDIATED_VIA = "mdtd";
    private static final String NETWORK_TYPE = "net";
    private static final String TOTAL_MEMORY = "mem";
    private static final String SCREEN_SIZE = "scr";
    private static final String WIDTH = "wd";
    private static final String HEIGHT = "ht";
    private static final String LOCATION = "loc";
    private static final String LAT = "lat";
    private static final String LON = "lng";
    private static final String ROOT_KEY = "additional_data";
    private static final String IS_KOTLIN = "kotlin";
    private static final String IS_ANDROIDX = "androidx";
    private static final String NT_2G = "2g";
    private static final String NT_3G = "3g";
    private static final String NT_4G = "4g";
    private static final String NT_WIFI = "wifi";
    public static final String SDK_TYPE_WIDGET = "Taboola Android SDK";
    public static final String SDK_TYPE_API = "Taboola Android SDK - API";
    public static final String SDK_TYPE_JS = "Taboola Android SDK - JS";
    private static final String ANDROID = "Android";
    public static final String UNDEFINED = "undefined";
    private static String sForcedSimCountryCode = null;
    private static String sApplicationName;

    private SdkDetailsHelper() {
    }

    public static String getDefaultBrowser(Context applicationContext) {
        String DEFAULT_RETURN_VALUE = "";
        try {
            if (applicationContext == null) {
                return "";
            }
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://"));
            PackageManager packageManager = applicationContext.getPackageManager();
            if (packageManager == null) {
                return "";
            }
            ResolveInfo resolveInfo = packageManager.resolveActivity(browserIntent, 65536);
            if (resolveInfo == null) {
                return "";
            }
            return resolveInfo.loadLabel(packageManager).toString();
        }
        catch (Exception e) {
            Logger.e(TAG, e.getMessage(), e);
            return "";
        }
    }

    public static HashMap<String, String> createSdkDetailsMap(Context context, @Nullable String mediatedVia, String sdkType) {
        HashMap<String, String> detailsMap = new HashMap<String, String>();
        detailsMap.put(ROOT_KEY, SdkDetailsHelper.createSdkDetailsJSON(context, mediatedVia, sdkType).toString());
        return detailsMap;
    }

    public static String createSdkJsonString(Context context, @Nullable String mediatedVia, String sdkType, boolean disableLocationCollection) {
        return SdkDetailsHelper.createSdkDetailsJSON(context, mediatedVia, sdkType, disableLocationCollection).toString();
    }

    private static JSONObject createSdkDetailsJSON(Context context, @Nullable String mediatedVia, String sdkType) {
        return SdkDetailsHelper.createSdkDetailsJSON(context, mediatedVia, sdkType, false);
    }

    public static JSONObject createSdkDetailsJSON(Context context, @Nullable String mediatedVia, String sdkType, boolean disableLocationCollection) {
        JSONObject sdkDataJsonObject = new JSONObject();
        JSONObject detailsJsonObject = new JSONObject();
        try {
            PackageInfo packageInfo = SdkDetailsHelper.getPackageInfo(context);
            detailsJsonObject.put(SDK_TYPE, (Object)sdkType);
            detailsJsonObject.put(SDK_VERSION, (Object)"2.8.3");
            detailsJsonObject.put(APP_NAME, (Object)TextUtils.htmlEncode((String)SdkDetailsHelper.getApplicationName(context)));
            detailsJsonObject.put(APP_VERSION, (Object)packageInfo.versionName);
            detailsJsonObject.put(APP_ID, (Object)packageInfo.packageName);
            detailsJsonObject.put(DEVICE_MODEL, (Object)TextUtils.htmlEncode((String)SdkDetailsHelper.getDeviceName()));
            detailsJsonObject.put("lng", (Object)SdkDetailsHelper.getLanguagesJson(context));
            detailsJsonObject.put(OS, (Object)ANDROID);
            detailsJsonObject.put(OS_VERSION, (Object)Build.VERSION.RELEASE);
            detailsJsonObject.put(IS_KOTLIN, SdkDetailsHelper.isPublisherAppUsesKotlin());
            detailsJsonObject.put(IS_ANDROIDX, SdkDetailsHelper.isPublisherAppUsesAndroidx());
            if (mediatedVia != null) {
                detailsJsonObject.put(MEDIATED_VIA, (Object)mediatedVia);
            }
            detailsJsonObject.put(NETWORK_TYPE, (Object)SdkDetailsHelper.getNetworkClass(context));
            if (Build.VERSION.SDK_INT >= 16) {
                detailsJsonObject.put(TOTAL_MEMORY, (Object)SdkDetailsHelper.getMemory(context));
            }
            JSONObject screenSize = new JSONObject();
            int width = SdkDetailsHelper.getDisplayWidth(context);
            int height = SdkDetailsHelper.getDisplayHeight(context);
            screenSize.put(WIDTH, width);
            screenSize.put(HEIGHT, height);
            detailsJsonObject.put(SCREEN_SIZE, (Object)screenSize);
            if (!disableLocationCollection) {
                SdkDetailsHelper.addLocation(context, detailsJsonObject);
            }
            sdkDataJsonObject.put(SDK_DATA, (Object)detailsJsonObject);
        }
        catch (Exception e) {
            Logger.e(TAG, "createSdkDetailsJSON() failed, sdkType = [" + sdkType + "] " + e.toString(), e);
        }
        try {
            Logger.d(TAG, "createSdkDetailsJSON() finished with " + sdkDataJsonObject.toString(2));
        }
        catch (Exception e) {
            Logger.e(TAG, e.toString());
        }
        return sdkDataJsonObject;
    }

    @SuppressLint(value={"MissingPermission"})
    private static void addLocation(Context context, JSONObject detailsJsonObject) {
        try {
            LocationManager locationManager = (LocationManager)context.getApplicationContext().getSystemService("location");
            if (locationManager != null) {
                Location lastKnownLocation = null;
                List providers = locationManager.getProviders(true);
                if (providers != null) {
                    for (String provider : providers) {
                        Location location = locationManager.getLastKnownLocation(provider);
                        if (location == null || lastKnownLocation != null && !(location.getAccuracy() < lastKnownLocation.getAccuracy())) continue;
                        lastKnownLocation = location;
                    }
                }
                if (lastKnownLocation != null) {
                    double lat = lastKnownLocation.getLatitude();
                    double lng = lastKnownLocation.getLongitude();
                    JSONObject location = new JSONObject();
                    location.put(LAT, NumberUtils.formatDouble(lat, 2));
                    location.put("lng", NumberUtils.formatDouble(lng, 2));
                    detailsJsonObject.put(LOCATION, (Object)location);
                    Logger.d(TAG, "location is available");
                } else {
                    Logger.d(TAG, "location is not available");
                }
            } else {
                Logger.d(TAG, "location permission is not granted");
            }
        }
        catch (Exception e) {
            Logger.e(TAG, e.getMessage(), e);
        }
    }

    public static JSONObject getBridgeInfo(Context context, @Nullable String mediatedVia, String sdkType) {
        JSONObject bridge = new JSONObject();
        try {
            JSONObject additionalData = (JSONObject)SdkDetailsHelper.createSdkDetailsJSON(context, mediatedVia, sdkType).get(SDK_DATA);
            AdvertisingIdInfo advertisingIdInfo = Taboola.getTaboolaImpl().getAdvertisingIdInfo();
            String deviceId = "";
            if (advertisingIdInfo != null) {
                deviceId = advertisingIdInfo.getAdvertisingId();
            }
            bridge.put("deviceId", (Object)deviceId);
            bridge.put("AppName", additionalData.get(APP_NAME));
            bridge.put("BundleName", additionalData.get(APP_ID));
            bridge.put("SDKVersion", additionalData.get(SDK_VERSION));
            bridge.put("OSVersion", additionalData.get(OS_VERSION));
            bridge.put(DEVICE_MODEL, additionalData.get(DEVICE_MODEL));
            bridge.put("SDKType", additionalData.get(SDK_TYPE));
        }
        catch (Exception e) {
            Logger.e(TAG, "getBridgeInfo" + e.getMessage());
        }
        return bridge;
    }

    private static JSONObject getLanguagesJson(Context ctx) {
        JSONObject languagesJson = new JSONObject();
        try {
            InputMethodManager imm;
            String mainLanguage = Resources.getSystem().getConfiguration().locale.getISO3Language();
            languagesJson.put(MAIN_LANGUAGE, (Object)mainLanguage);
            Locale deviceLocale = Locale.getDefault();
            if (deviceLocale != null) {
                languagesJson.put(LOCALE_LANGUAGE, (Object)deviceLocale);
                languagesJson.put(DISPLAY_LANGUAGE, (Object)deviceLocale.getDisplayLanguage());
            }
            String simCountryIso = SdkDetailsHelper.getSimCountryIso(ctx);
            languagesJson.put(SIM_LANGUAGE, (Object)simCountryIso);
            TelephonyManager tm = (TelephonyManager)ctx.getSystemService("phone");
            if (tm != null) {
                languagesJson.put(NETWORK_LANGUAGE, (Object)tm.getNetworkCountryIso());
            }
            if ((imm = (InputMethodManager)ctx.getSystemService("input_method")) != null) {
                JSONArray keyboardLanguages = new JSONArray();
                List ims = imm.getEnabledInputMethodList();
                for (InputMethodInfo method : ims) {
                    List submethods = imm.getEnabledInputMethodSubtypeList(method, true);
                    for (InputMethodSubtype submethod : submethods) {
                        if (!submethod.getMode().equals("keyboard")) continue;
                        keyboardLanguages.put((Object)submethod.getLocale());
                    }
                }
                languagesJson.put(KEYBOARD_LANGUAGES, (Object)keyboardLanguages);
            }
        }
        catch (Exception e) {
            Logger.d(TAG, "getLanguagesJson() | error = " + e.getMessage());
        }
        return languagesJson;
    }

    public static String getDeviceName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return SdkDetailsHelper.capitalize(model);
        }
        return SdkDetailsHelper.capitalize(manufacturer) + " " + model;
    }

    public static String getCarrier(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        if (manager != null) {
            return manager.getNetworkOperatorName();
        }
        return "";
    }

    public static String getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            Logger.e(TAG, e.getLocalizedMessage(), e);
            return "";
        }
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    @RequiresApi(api=16)
    @Nullable
    private static String getMemory(Context context) {
        ActivityManager actManager = (ActivityManager)context.getSystemService("activity");
        if (actManager == null) {
            Logger.e(TAG, "Activity manager is null");
            return null;
        }
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        actManager.getMemoryInfo(memInfo);
        return Long.toString(memInfo.totalMem / 1024L);
    }

    @Nullable
    private static Display getDisplay(Context context) {
        if (context == null) {
            return null;
        }
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            return null;
        }
        return windowManager.getDefaultDisplay();
    }

    public static View getParentScrollView(View view) {
        for (ViewParent vp = view.getParent(); vp != null; vp = vp.getParent()) {
            if (vp instanceof ScrollView || vp instanceof ListView) {
                Logger.d(TAG, vp.getClass().getSimpleName() + " is recognized as scrolling.");
                return (View)vp;
            }
            try {
                if (vp instanceof android.support.v4.view.ScrollingView) {
                    Logger.i(TAG, "getParentScrollView | View is recognized as SupportV4 scrolling view.");
                    return (View)vp;
                }
            }
            catch (NoClassDefFoundError ncdfe) {
                Logger.i(TAG, "getParentScrollView | Info: view parent is not of android.support.v4.view.ScrollingView type. | e = " + ncdfe.getLocalizedMessage());
            }
            try {
                if (!(vp instanceof ScrollingView)) continue;
                Logger.i(TAG, "getParentScrollView | View is recognized as AndroidX scrolling view.");
                return (View)vp;
            }
            catch (NoClassDefFoundError ncdfe) {
                Logger.i(TAG, "Info: view parent is not of androidx.core.view.ScrollingView type. | e = " + ncdfe.getLocalizedMessage());
            }
        }
        return null;
    }

    public static boolean shouldRemoveFocus(View view) {
        for (ViewParent vp = view.getParent(); vp != null; vp = vp.getParent()) {
            try {
                if (vp instanceof android.support.v4.view.ScrollingView || vp instanceof android.support.v4.view.ViewPager) {
                    Logger.i(TAG, "shouldRemoveFocus | View is recognized as SupportV4 view.");
                    return true;
                }
            }
            catch (NoClassDefFoundError ncdfe) {
                Logger.i(TAG, "shouldRemoveFocus | Info: android.support.v4 class might not be installed in host app. | e = " + ncdfe.getLocalizedMessage());
            }
            try {
                if (!(vp instanceof ScrollingView) && !(vp instanceof ViewPager) && !(vp instanceof ViewPager2)) continue;
                Logger.i(TAG, "shouldRemoveFocus | View is recognized as AndroidX view.");
                return true;
            }
            catch (NoClassDefFoundError ncdfe) {
                Logger.i(TAG, "shouldRemoveFocus | Info: AndroidX class might not be installed in host app. | e = " + ncdfe.getLocalizedMessage());
            }
        }
        return false;
    }

    public static int getDisplayHeight(Context context) {
        Integer displaySize = (Integer)SdkDetailsHelper.getDisplaySize((Context)context).second;
        return displaySize == null ? 0 : displaySize;
    }

    public static int getDisplayWidth(Context context) {
        Integer displaySize = (Integer)SdkDetailsHelper.getDisplaySize((Context)context).first;
        return displaySize == null ? 0 : displaySize;
    }

    private static Pair<Integer, Integer> getDisplaySize(Context context) {
        Pair widthAndHeightPair;
        Display display = SdkDetailsHelper.getDisplay(context);
        if (display == null) {
            try {
                DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
                widthAndHeightPair = new Pair((Object)displayMetrics.widthPixels, (Object)displayMetrics.heightPixels);
            }
            catch (Exception e) {
                widthAndHeightPair = new Pair((Object)0, (Object)0);
            }
        } else {
            Point size = new Point();
            display.getSize(size);
            widthAndHeightPair = new Pair((Object)size.x, (Object)size.y);
        }
        return widthAndHeightPair;
    }

    public static String getApplicationName(Context context) {
        if (null == sApplicationName) {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            sApplicationName = stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
        }
        return sApplicationName;
    }

    public static PackageInfo getPackageInfo(Context context) throws PackageManager.NameNotFoundException {
        String packageName = context.getPackageName();
        return context.getPackageManager().getPackageInfo(packageName, 0);
    }

    @SuppressLint(value={"MissingPermission"})
    private static String getNetworkClass(Context context) {
        String defaultResponse = NT_WIFI;
        TelephonyManager mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (mTelephonyManager == null) {
            return defaultResponse;
        }
        int networkType = Build.VERSION.SDK_INT >= 24 && PermissionUtils.isPermissionGranted(context, "android.permission.READ_PHONE_STATE") ? mTelephonyManager.getDataNetworkType() : (Build.VERSION.SDK_INT < 24 ? mTelephonyManager.getNetworkType() : 0);
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return NT_2G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                return NT_3G;
            }
            case 13: {
                return NT_4G;
            }
        }
        return defaultResponse;
    }

    public static boolean forceSimCountryCode(String simCode, String password) {
        String keyHash = SecurityUtils.getSHA256(password).toLowerCase();
        if (!keyHash.equalsIgnoreCase("376c21021b2800b444ae9214a5b251460c04490611dadf1585987e12ce0b6c21")) {
            return false;
        }
        sForcedSimCountryCode = simCode;
        return true;
    }

    public static void verifyIfNeededToChangeSimCode(@Nullable TBSimCodeChange codeChange) {
        String simCode = null;
        String password = null;
        if (codeChange != null) {
            simCode = codeChange.getSimCode();
            password = codeChange.getPassword();
        }
        SdkDetailsHelper.forceSimCountryCode(simCode, password);
    }

    @NonNull
    public static String getSimCountryIso(@NonNull Context context) {
        if (context == null) {
            Logger.e(TAG, "getSimCountryIso | Context == null");
            return UNDEFINED;
        }
        boolean forceSimCountryIso = !TextUtils.isEmpty((CharSequence)sForcedSimCountryCode) && !UNDEFINED.equalsIgnoreCase(sForcedSimCountryCode);
        String simCountryIso = forceSimCountryIso ? sForcedSimCountryCode : SdkDetailsHelper.getSimCodeFromTelephonyManager(context);
        return simCountryIso;
    }

    @NonNull
    private static String getSimCodeFromTelephonyManager(@NonNull Context context) {
        String simCountryIso = null;
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm != null) {
            simCountryIso = tm.getSimCountryIso();
        } else {
            Logger.e(TAG, "can't get access to TelephonyManager");
        }
        if (TextUtils.isEmpty((CharSequence)simCountryIso)) {
            simCountryIso = SharedPrefUtil.getCachedSimCode(context);
            Logger.e(TAG, "getSimCodeFromTelephonyManager failed, fallback to " + simCountryIso);
        } else {
            SharedPrefUtil.saveSimCodeToSharedPreferences(context, simCountryIso);
        }
        return simCountryIso;
    }

    private static boolean isPublisherAppUsesKotlin() {
        return SdkDetailsHelper.isClassExist("kotlin.jvm.internal.Intrinsics", "kotlin.jvm.internal.Reflection");
    }

    private static boolean isPublisherAppUsesAndroidx() {
        return SdkDetailsHelper.isClassExist("androidx.appcompat.app.AppCompatActivity", "androidx.core.R");
    }

    private static boolean isClassExist(String ... classNames) {
        for (String className : classNames) {
            try {
                Class.forName(className);
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }
}

