/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.app.KeyguardManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.ProviderInfo;
import android.os.Build;
import android.os.PowerManager;
import android.support.annotation.Keep;
import com.taboola.android.TaboolaContextProvider;
import com.taboola.android.utils.Logger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DeviceUtils {
    private static final String TAG = "DeviceUtils";

    @DeviceScreenState
    public static int getScreenState(Context context) {
        try {
            boolean isScreenOn;
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (keyguardManager == null) {
                return -1;
            }
            boolean inKeyguardRestrictedInputMode = keyguardManager.inKeyguardRestrictedInputMode();
            if (inKeyguardRestrictedInputMode) {
                isScreenOn = false;
            } else {
                PowerManager powerManager = (PowerManager)context.getSystemService("power");
                if (powerManager == null) {
                    return -1;
                }
                isScreenOn = Build.VERSION.SDK_INT >= 20 ? powerManager.isInteractive() : powerManager.isScreenOn();
            }
            return isScreenOn ? 1 : 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static boolean isSDKAlreadyInstalledOnDevice(Context context) throws Exception {
        if (context == null) {
            throw new Exception("context is null");
        }
        try {
            for (PackageInfo pack : context.getPackageManager().getInstalledPackages(8)) {
                ProviderInfo[] providers = pack.providers;
                if (providers == null) continue;
                for (ProviderInfo provider : providers) {
                    if (provider.authority == null || !provider.authority.contains(TaboolaContextProvider.class.getSimpleName()) || provider.authority.contains(context.getPackageName())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            Logger.d(TAG, e.getMessage());
            throw e;
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Keep
    public static @interface DeviceScreenState {
        public static final int ERROR = -1;
        public static final int OFF = 0;
        public static final int SCREEN_ON = 1;
    }
}

