/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.content.Context;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.taboola.android.utils.Logger;

public class CcpaUtil {
    private static final String TAG = "CcpaUtil";
    private static final String CCPA_OPTOUT_DEFAULT_VALUE = "none";
    private static final String CCPA_INVALID_VALUE_ERROR_MESSAGE = "The value [%s] for %s is invalid. Using [%s] instead.";
    private static final String CCPA_EMPTY_STRING = "";
    private static final String CCPA_PRIVACY_STRING = "IABUSPrivacy_String";

    public static String validateAndReturnCcpaValue(String publisherValue) {
        if (!TextUtils.isEmpty((CharSequence)publisherValue)) {
            switch (publisherValue = publisherValue.toLowerCase()) {
                case "true": 
                case "false": 
                case "none": {
                    return publisherValue;
                }
            }
            Logger.e(TAG, String.format(CCPA_INVALID_VALUE_ERROR_MESSAGE, publisherValue, "cdns", CCPA_OPTOUT_DEFAULT_VALUE));
            return CCPA_OPTOUT_DEFAULT_VALUE;
        }
        Logger.e(TAG, String.format(CCPA_INVALID_VALUE_ERROR_MESSAGE, CCPA_EMPTY_STRING, "cdns", CCPA_OPTOUT_DEFAULT_VALUE));
        return CCPA_OPTOUT_DEFAULT_VALUE;
    }

    public static String getAppPrivacyString(Context applicationContext) {
        return PreferenceManager.getDefaultSharedPreferences((Context)applicationContext).getString(CCPA_PRIVACY_STRING, CCPA_EMPTY_STRING);
    }
}

