/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.handlers;

import android.support.annotation.Keep;
import android.util.Log;
import com.taboola.android.global_components.network.requests.kusto.KustoRequest;
import com.taboola.lightnetwork.dynamic_url.DynamicRequest;
import com.taboola.lightnetwork.dynamic_url.NetworkExecutable;
import com.taboola.lightnetwork.dynamic_url.annotations.GET;
import com.taboola.lightnetwork.dynamic_url.annotations.Query;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;

@Keep
public class KustoHandler {
    private static final String KUSTO_TR_5_URL = "https://cdn.taboola.com/libtrc/tr5";
    private KustoApiService mKustoApiService;
    private static final String TAG = "KustoHandler";

    public void setHttpManager(HttpManager httpManager) {
        NetworkExecutable networkExecutable = new NetworkExecutable(httpManager);
        this.mKustoApiService = networkExecutable.create(KustoApiService.class);
    }

    public void sendEventToKusto(KustoRequest kustoRequest, HttpManager.NetworkResponse networkResponse) {
        block2: {
            try {
                String data = kustoRequest.getJsonBody().toString(2);
                DynamicRequest request = this.mKustoApiService.sendEvent(data);
                request.execute(networkResponse);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("sendEventToKusto: error " + e.getLocalizedMessage()), (Throwable)e);
                if (networkResponse == null) break block2;
                networkResponse.onError(new HttpError(e.getLocalizedMessage()));
            }
        }
    }

    static interface KustoApiService {
        @GET(value="https://cdn.taboola.com/libtrc/tr5")
        public DynamicRequest sendEvent(@Query(value="data") String var1);
    }
}

