/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.fsd;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.support.customtabs.CustomTabsCallback;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import android.text.TextUtils;
import com.taboola.android.Taboola;
import com.taboola.android.global_components.TaboolaContextManager;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.fsd.FSDCCTabCallback;
import com.taboola.android.global_components.fsd.FSDCCTabsServiceConnection;
import com.taboola.android.global_components.fsd.FSDManager;
import com.taboola.android.global_components.fsd.IFSDCCTabServiceConnectionCallback;
import com.taboola.android.global_components.fsd.IFSDNavigationEventCallback;
import com.taboola.android.utils.DeviceUtils;
import com.taboola.android.utils.GDPRUtils;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.OnClickHelper;
import com.taboola.android.utils.SecurityUtils;
import com.taboola.android.utils.SharedPrefUtil;

public class FSDActivity
extends Activity
implements IFSDCCTabServiceConnectionCallback {
    private static final String TAG = FSDActivity.class.getSimpleName();
    private static final int MAX_TIMEOUT_IN_MILLISECONDS = 5000;
    private static final long GAID_MAX_TIMEOUT_IN_MILLISECONDS = 3000L;
    private static final String GAID_HASHED_KEY_STRING = "did";
    static final String EXTRA_KEY_SHOULD_LEAVE_OPEN = "shouldLeaveOpen";
    private FSDCCTabsServiceConnection mCustomTabServiceConnection;
    private FSDCCTabCallback mTabsCallback;
    private IFSDNavigationEventCallback mNavigationEventCallback;
    private CustomTabsSession mCustomTabsSession;
    private Handler mGlobalTimeoutHandler;
    private Runnable mGlobalTimeoutRunnable;
    private CustomTabsClient mCustomTabsClient;
    private boolean mShouldFinishInOnResume = false;
    private boolean mIsFsdKillSwitchOn = true;
    private boolean mShowOnlyWhenScreenOff = true;
    private boolean mShouldLeaveOpen = false;
    private boolean mShouldSendEvents = true;
    private String mLogLevel = "A";
    private String mCustomTabPackageName;
    private FSDManager mFsdManager;
    private String mGaidSha256;
    private String mBaseUrl = "https://trc.taboola.com/sg/tdt/1/um/?redir=";
    private String mRedirUrl = "https://topreport.news/static/impl/html/TopNewsIndex2.html";
    private boolean mIsActivityStartedFromForeground;
    static final String FOREGROUND_KEY = "foreground";

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (!intent.getBooleanExtra(EXTRA_KEY_SHOULD_LEAVE_OPEN, false)) {
            this.unbindCustomTabsService();
            Logger.d(TAG, "onNewIntent(): closing FSD activity.");
            this.finishActivity();
        } else {
            Logger.d(TAG, "onNewIntent(): should Leave FSD open.");
        }
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            if (!OnClickHelper.areChromeCustomTabsSupported((Context)this)) {
                this.finishActivity();
                return;
            }
            if (this.isActivityOpenedFromDeepLink()) {
                this.finishActivity();
                return;
            }
            this.mIsActivityStartedFromForeground = this.isHostedAppInForeground();
            this.mFsdManager = Taboola.getTaboolaImpl().getFsdManager();
            if (this.mFsdManager == null) {
                this.finishActivity();
            }
            if (Build.VERSION.SDK_INT >= 29) {
                SharedPrefUtil.setFsdFail((Context)this, System.currentTimeMillis());
                this.finishActivity();
            }
            this.mIsFsdKillSwitchOn = this.mFsdManager.getKillSwitch(this.mIsFsdKillSwitchOn);
            if (this.mIsFsdKillSwitchOn) {
                Logger.d(TAG, "FSD kill switch is active.");
                this.mFsdManager.addStats(this.mLogLevel, System.currentTimeMillis(), "fsd_err_ks", new String[0]);
                this.finishActivity();
                return;
            }
            if (!FSDManager.isDeviceConnectedToNetwork()) {
                this.mFsdManager.markAsFailedWithStats(this.mLogLevel, "fsd_err_network");
                this.finishActivity();
                return;
            }
            this.mShowOnlyWhenScreenOff = this.mFsdManager.getScreenOff(this.mShowOnlyWhenScreenOff);
            if (this.mShowOnlyWhenScreenOff && DeviceUtils.getScreenState((Context)this) != 0) {
                this.mFsdManager.markAsFailedWithStats(this.mLogLevel, "fsd_err_so");
                this.finishActivity();
                return;
            }
            if (GDPRUtils.isSubjectToGdpr((Context)this) || GDPRUtils.isSubjectToGdprV2((Context)this)) {
                this.mFsdManager.markAsFailedWithStats(this.mLogLevel, "fsd_err_gdpr");
                this.finishActivity();
                return;
            }
            this.mShouldLeaveOpen = this.mFsdManager.getShouldLeaveOpen(this.mShouldLeaveOpen);
            this.mShouldSendEvents = this.mFsdManager.getShouldSendEvents(this.mShouldSendEvents);
            this.mLogLevel = this.mFsdManager.getLogLevel(this.mLogLevel);
            this.mBaseUrl = this.mFsdManager.getBaseUrl(this.mBaseUrl);
            this.mRedirUrl = this.mFsdManager.getRedirUrl(this.mRedirUrl);
            final Runnable gaidFinishRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        FSDActivity.this.mFsdManager.markAsFailedWithStats(FSDActivity.this.mLogLevel, "fsd_err_gaerror");
                    }
                    catch (Exception e) {
                        Logger.e(TAG, e.getMessage(), e);
                    }
                    finally {
                        Logger.d(TAG, "GAID timed out - closing FSD activity");
                        FSDActivity.this.finishActivity();
                    }
                }
            };
            final Handler gaidHandler = new Handler(Looper.getMainLooper());
            gaidHandler.postDelayed(gaidFinishRunnable, 3000L);
            final AdvertisingIdInfo mAdvertisingIdInfo = Taboola.getTaboolaImpl().getAdvertisingIdInfo();
            mAdvertisingIdInfo.updateAdvertisingIdAsync(TaboolaContextManager.getInstance().getApplicationContext(), new AdvertisingIdInfo.AdvertisingIdCallback(){

                @Override
                public void onIdRetrieved(String advertisingId) {
                    gaidHandler.removeCallbacks(gaidFinishRunnable);
                    if (mAdvertisingIdInfo.isLimitedAdTrackingEnabled()) {
                        FSDActivity.this.mFsdManager.markAsFailedWithStats(FSDActivity.this.mLogLevel, "fsd_err_galimit");
                        FSDActivity.this.finishActivity();
                    } else {
                        FSDActivity.this.mGaidSha256 = SecurityUtils.getSHA256(advertisingId);
                        if (!TextUtils.isEmpty((CharSequence)FSDActivity.this.mGaidSha256)) {
                            FSDActivity.this.bindCustomTabs();
                        } else {
                            FSDActivity.this.mFsdManager.markAsFailedWithStats(FSDActivity.this.mLogLevel, "fsd_err_gaerror");
                            FSDActivity.this.finishActivity();
                        }
                    }
                }

                @Override
                public void onIdUnavailable() {
                    gaidHandler.removeCallbacks(gaidFinishRunnable);
                    FSDActivity.this.mFsdManager.markAsFailedWithStats(FSDActivity.this.mLogLevel, "fsd_err_gaerror");
                    FSDActivity.this.finishActivity();
                }
            });
        }
        catch (Exception e) {
            Logger.e(TAG, "onCreate() | " + e.getMessage(), e);
            this.finishActivity();
        }
    }

    private boolean isActivityOpenedFromDeepLink() {
        Intent intent = this.getIntent();
        if (intent != null) {
            String intentDataString = intent.getDataString();
            return !TextUtils.isEmpty((CharSequence)intentDataString) && intentDataString.contains("tblfsd");
        }
        return false;
    }

    private boolean isHostedAppInForeground() {
        Intent intent = this.getIntent();
        if (intent != null) {
            return intent.getBooleanExtra(FOREGROUND_KEY, false);
        }
        return false;
    }

    protected void onResume() {
        super.onResume();
        if (this.mShouldFinishInOnResume) {
            this.finishActivity();
            return;
        }
        Intent intent = this.getIntent();
        if (intent != null && intent.hasExtra(EXTRA_KEY_SHOULD_LEAVE_OPEN) && intent.getBooleanExtra(EXTRA_KEY_SHOULD_LEAVE_OPEN, false) || this.mShouldLeaveOpen) {
            this.mShouldFinishInOnResume = true;
        }
    }

    protected void onDestroy() {
        try {
            Logger.d(TAG, "unbindCustomTabsService");
            this.unbindCustomTabsService();
        }
        catch (Exception e) {
            Logger.e(TAG, "onDestroy() error: " + e.getMessage(), e);
        }
        super.onDestroy();
    }

    private void bindCustomTabs() {
        if (this.mTabsCallback != null) {
            Logger.w(TAG, "bindCustomTabs() called but TabsCallback already defined!");
            return;
        }
        this.mCustomTabPackageName = this.mFsdManager.getCustomTabPackageName((Context)this);
        if (TextUtils.isEmpty((CharSequence)this.mCustomTabPackageName)) {
            Logger.e(TAG, "CCTab is not available");
            this.mFsdManager.markAsFailedWithStats(this.mLogLevel, "fsd_err_cctabna");
            this.finishActivity();
            return;
        }
        Logger.d(TAG, "Binding CCTab with package [" + this.mCustomTabPackageName + "]");
        this.mCustomTabServiceConnection = new FSDCCTabsServiceConnection(this);
        boolean bindSuccessful = false;
        try {
            bindSuccessful = CustomTabsClient.bindCustomTabsService((Context)this, (String)this.mCustomTabPackageName, (CustomTabsServiceConnection)this.mCustomTabServiceConnection);
        }
        catch (Exception e) {
            Logger.e(TAG, e.getMessage(), e);
        }
        Logger.d(TAG, "Did bind successfull? " + bindSuccessful + " !");
    }

    public void unbindCustomTabsService() {
        Logger.d(TAG, "unbindCustomTabsService() called");
        if (this.mCustomTabServiceConnection == null) {
            Logger.d(TAG, "unbindCustomTabsService() called and is already null..");
            return;
        }
        try {
            this.unbindService((ServiceConnection)this.mCustomTabServiceConnection);
            this.mCustomTabServiceConnection = null;
        }
        catch (Exception e) {
            Logger.e(TAG, "unbindCustomTabsService() | " + e.getMessage());
        }
        this.mCustomTabsSession = null;
        this.mGlobalTimeoutRunnable = null;
        this.mGlobalTimeoutHandler = null;
        this.mNavigationEventCallback = null;
        this.mTabsCallback = null;
        this.mCustomTabsClient = null;
    }

    @Override
    public void onCCTabServiceConnected(ComponentName name, CustomTabsClient client) {
        this.mCustomTabsClient = client;
        this.mCustomTabsClient.warmup(0L);
        this.mNavigationEventCallback = new IFSDNavigationEventCallback(){

            @Override
            public void onNavigationFinished() {
                FSDActivity.this.mFsdManager.markAsSuccessWithStats(FSDActivity.this.mLogLevel);
                if (FSDActivity.this.mGlobalTimeoutRunnable != null) {
                    FSDActivity.this.mGlobalTimeoutHandler.removeCallbacks(FSDActivity.this.mGlobalTimeoutRunnable);
                }
                FSDActivity.this.mGlobalTimeoutRunnable = null;
                FSDActivity.this.mGlobalTimeoutHandler = null;
                FSDActivity.this.mFsdManager.closeCCTabActivity((Context)FSDActivity.this, FSDActivity.this.mShouldLeaveOpen);
            }
        };
        this.mTabsCallback = new FSDCCTabCallback(this.mNavigationEventCallback);
        this.mCustomTabsSession = this.mCustomTabsClient.newSession((CustomTabsCallback)this.mTabsCallback);
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(this.mCustomTabsSession);
        CustomTabsIntent customTabsIntent = builder.build();
        customTabsIntent.intent.addFlags(0x800000);
        customTabsIntent.intent.addFlags(65536);
        customTabsIntent.intent.addFlags(0x40000000);
        customTabsIntent.intent.setPackage(this.mCustomTabPackageName);
        Uri urlToOpen = this.buildEndpointUrl();
        if (urlToOpen != null) {
            customTabsIntent.launchUrl((Context)this, urlToOpen);
        }
        this.mGlobalTimeoutHandler = new Handler();
        this.mGlobalTimeoutRunnable = new Runnable(){

            @Override
            public void run() {
                if (FSDActivity.this.mTabsCallback != null) {
                    FSDActivity.this.mTabsCallback.disableNavigationEvents(true);
                }
                Logger.d(TAG, "FSD timeout reached.");
                try {
                    FSDActivity.this.unbindCustomTabsService();
                    PowerManager pm = (PowerManager)FSDActivity.this.getSystemService("power");
                    if (Build.VERSION.SDK_INT >= 23 && pm != null && pm.isDeviceIdleMode()) {
                        FSDActivity.this.mFsdManager.markAsFailedWithStats(FSDActivity.this.mLogLevel, "fsd_err_dmode");
                    } else {
                        FSDActivity.this.mFsdManager.markAsFailedWithStats(FSDActivity.this.mLogLevel, "fsd_err_to");
                    }
                    FSDActivity.this.mFsdManager.closeCCTabActivity((Context)FSDActivity.this, FSDActivity.this.mShouldLeaveOpen);
                }
                catch (Exception e) {
                    Logger.e(TAG, e.getMessage(), e);
                }
            }
        };
        if (!this.mShouldLeaveOpen) {
            try {
                int maxTimeoutInMilliseconds = this.mFsdManager.getMaxTimeoutInMilliseconds(5000);
                this.mGlobalTimeoutHandler.postDelayed(this.mGlobalTimeoutRunnable, (long)maxTimeoutInMilliseconds);
            }
            catch (Exception e) {
                Logger.e(TAG, e.getMessage(), e);
            }
        }
    }

    @Nullable
    private Uri buildEndpointUrl() {
        try {
            String gaidParam = this.mFsdManager.getGaidParam(GAID_HASHED_KEY_STRING);
            Uri parsedUri = Uri.parse((String)(this.mBaseUrl + Uri.encode((String)this.mRedirUrl))).buildUpon().appendQueryParameter(gaidParam, this.mGaidSha256).build();
            Logger.d(TAG, "final url = " + parsedUri);
            return parsedUri;
        }
        catch (Exception e) {
            if (this.mFsdManager != null) {
                this.mFsdManager.addStats(this.mLogLevel, System.currentTimeMillis(), "fsd_err_url", new String[0]);
            }
            Logger.e(TAG, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void onCCTabServiceDisconnected(ComponentName name) {
        Logger.d(TAG, "cctab service disconnected.");
    }

    private void finishActivity() {
        if (!this.isFinishing()) {
            if (!this.isTaskRoot() && !this.mIsActivityStartedFromForeground) {
                this.moveTaskToBack(true);
            }
            this.finish();
        }
    }
}

