/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.globalNotifications;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import com.taboola.android.TaboolaWidget;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.TaboolaSerializable;
import java.io.Serializable;

@Keep
public class GlobalNotificationReceiver
extends BroadcastReceiver {
    private static final String TAG = GlobalNotificationReceiver.class.getSimpleName();
    private OnGlobalNotificationsListener mOnGlobalNotificationsListener;
    public static final String GLOBAL_NOTIFICATIONS_KEY = "com.taboola.android.GLOBAL_NOTIFICATIONS_KEY";
    public static final String GLOBAL_NOTIFICATIONS_MESSAGES_KEY = "GLOBAL_NOTIFICATIONS_MESSAGES_KEY";
    public static final String GLOBAL_NOTIFICATIONS_WIDGET_KEY = "GLOBAL_NOTIFICATIONS_WIDGET_KEY";
    public static final String GLOBAL_NOTIFICATIONS_VALUE_KEY = "GLOBAL_NOTIFICATIONS_VALUE_KEY";
    public static final String TABOOLA_DID_RECEIVE_AD = "TABOOLA_DID_RECEIVE_AD";
    public static final String TABOOLA_VIEW_RESIZED = "TABOOLA_VIEW_RESIZED";
    public static final String TABOOLA_ITEM_DID_CLICK = "TABOOLA_ITEM_DID_CLICK";
    public static final String TABOOLA_DID_FAIL_AD = "TABOOLA_DID_FAIL_AD";
    private IntentFilter mIntentFilter = new IntentFilter("com.taboola.android.GLOBAL_NOTIFICATIONS_KEY");

    public void onReceive(Context context, Intent intent) {
        Logger.d(TAG, "receive global notification" + intent.getStringExtra(GLOBAL_NOTIFICATIONS_MESSAGES_KEY));
        TaboolaWidget taboolaWidget = null;
        if (intent.getExtras() != null && intent.hasExtra(GLOBAL_NOTIFICATIONS_WIDGET_KEY)) {
            Serializable serializable = intent.getSerializableExtra(GLOBAL_NOTIFICATIONS_WIDGET_KEY);
            taboolaWidget = ((TaboolaSerializable)serializable).getTaboolaWidget();
        }
        if (taboolaWidget != null) {
            Object receivedValue = intent.getExtras().get(GLOBAL_NOTIFICATIONS_VALUE_KEY);
            switch (intent.getStringExtra(GLOBAL_NOTIFICATIONS_MESSAGES_KEY)) {
                case "TABOOLA_DID_RECEIVE_AD": {
                    if (this.getOnGlobalNotificationsListener() == null) break;
                    this.getOnGlobalNotificationsListener().taboolaDidReceiveAd(taboolaWidget);
                    break;
                }
                case "TABOOLA_VIEW_RESIZED": {
                    if (this.getOnGlobalNotificationsListener() == null) break;
                    this.getOnGlobalNotificationsListener().taboolaViewResized(taboolaWidget, (Integer)receivedValue);
                    break;
                }
                case "TABOOLA_ITEM_DID_CLICK": {
                    if (this.getOnGlobalNotificationsListener() == null) break;
                    this.getOnGlobalNotificationsListener().taboolaItemDidClick(taboolaWidget);
                    break;
                }
                case "TABOOLA_DID_FAIL_AD": {
                    if (this.getOnGlobalNotificationsListener() == null) break;
                    this.getOnGlobalNotificationsListener().taboolaDidFailAd(taboolaWidget, (String)receivedValue);
                }
            }
        }
    }

    public void registerReceiver(@NonNull Context context) {
        LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)this, this.mIntentFilter);
    }

    public void unregisterReceiver(@NonNull Context context) {
        LocalBroadcastManager.getInstance((Context)context).unregisterReceiver((BroadcastReceiver)this);
    }

    public OnGlobalNotificationsListener getOnGlobalNotificationsListener() {
        return this.mOnGlobalNotificationsListener;
    }

    public void registerNotificationsListener(OnGlobalNotificationsListener onGlobalNotificationsListener) {
        this.mOnGlobalNotificationsListener = onGlobalNotificationsListener;
    }

    public void unregisterNotificationsListener() {
        this.mOnGlobalNotificationsListener = null;
    }

    @Keep
    public static interface OnGlobalNotificationsListener {
        public void taboolaDidReceiveAd(TaboolaWidget var1);

        public void taboolaViewResized(TaboolaWidget var1, int var2);

        public void taboolaItemDidClick(TaboolaWidget var1);

        public void taboolaDidFailAd(TaboolaWidget var1, String var2);
    }
}

